/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyAppend<T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyBase<T, V> {
    private final IValueTypeListProxy<T, V> list;
    private final V value;

    public ValueTypeListProxyAppend(IValueTypeListProxy<T, V> list, V value) {
        super(ValueTypeListProxyFactories.APPEND.getName(), list.getValueType());
        this.list = list;
        this.value = value;
    }

    @Override
    public int getLength() throws EvaluationException {
        return this.list.getLength() + 1;
    }

    @Override
    public V get(int index) throws EvaluationException {
        int listLength = this.list.getLength();
        if (index < listLength) {
            return this.list.get(index);
        }
        if (index == listLength) {
            return this.value;
        }
        return null;
    }

    public static class Factory
    extends ValueTypeListProxyNBTFactorySimple<IValueType<IValue>, IValue, ValueTypeListProxyAppend<IValueType<IValue>, IValue>> {
        @Override
        public ResourceLocation getName() {
            return new ResourceLocation("integrateddynamics", "append");
        }

        @Override
        protected void serializeNbt(ValueTypeListProxyAppend<IValueType<IValue>, IValue> value, CompoundNBT tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            tag.func_74778_a("valueType", ((ValueTypeListProxyAppend)value).value.getType().getUniqueName().toString());
            tag.func_218657_a("value", ValueHelpers.serializeRaw(((ValueTypeListProxyAppend)value).value));
            tag.func_218657_a("sublist", ValueTypeListProxyFactories.REGISTRY.serialize(((ValueTypeListProxyAppend)value).list));
        }

        @Override
        protected ValueTypeListProxyAppend<IValueType<IValue>, IValue> deserializeNbt(CompoundNBT tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(tag.func_74779_i("valueType")));
            Object value = ValueHelpers.deserializeRaw(valueType, tag.func_74781_a("value"));
            Object list = ValueTypeListProxyFactories.REGISTRY.deserialize(tag.func_74781_a("sublist"));
            return new ValueTypeListProxyAppend<IValueType<IValue>, IValue>((IValueTypeListProxy<IValueType<IValue>, IValue>)list, (IValue)value);
        }
    }
}

