/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableConfig;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.network.event.NetworkInitializedEvent;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class CableHelpers {
    public static final Collection<Direction> ALL_SIDES = Sets.newIdentityHashSet();
    private static boolean removingCable;

    public static LazyOptional<ICable> getCable(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side, CableConfig.CAPABILITY);
    }

    public static LazyOptional<ICableFakeable> getCableFakeable(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side, CableFakeableConfig.CAPABILITY);
    }

    public static LazyOptional<IPathElement> getPathElement(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side, PathElementConfig.CAPABILITY);
    }

    public static void updateConnectionsNeighbours(IBlockReader world, BlockPos pos, Collection<Direction> sides) {
        for (Direction side : sides) {
            CableHelpers.updateConnections(world, pos.func_177972_a(side), side.func_176734_d());
        }
    }

    public static void updateConnections(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        CableHelpers.getCable(world, pos, side).ifPresent(ICable::updateConnections);
    }

    public static boolean isCableConnected(IBlockReader world, BlockPos pos, Direction side) {
        return CableHelpers.getCable(world, pos, side).map(cable -> cable.isConnected(side)).orElse(false);
    }

    public static boolean canCableConnectTo(IBlockReader world, BlockPos pos, Direction side, ICable originCable) {
        BlockPos neighbourPos = pos.func_177972_a(side);
        return CableHelpers.getCable(world, neighbourPos, side.func_176734_d()).map(neighbourCable -> originCable.canConnect((ICable)neighbourCable, side) && neighbourCable.canConnect(originCable, side.func_176734_d())).orElse(false);
    }

    public static boolean isNoFakeCable(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return CableHelpers.getCableFakeable(world, pos, side).map(ICableFakeable::isRealCable).orElse(true);
    }

    public static ActionResultType onCableActivated(World world, BlockPos pos, BlockState state, PlayerEntity player, ItemStack heldItem, Direction side, @Nullable Direction cableConnectionHit) {
        ICable cable = (ICable)CableHelpers.getCable((IBlockReader)world, pos, side).orElse(null);
        if (cable == null) {
            return ActionResultType.PASS;
        }
        if (WrenchHelpers.isWrench(player, heldItem, world, pos, side)) {
            BlockPos neighbourPos;
            ICable neighbourCable;
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            if (player.func_213453_ef()) {
                CableHelpers.removeCable(world, pos, player);
            } else if (cableConnectionHit != null) {
                cable.disconnect(cableConnectionHit);
                cable.updateConnections();
                Collection<Direction> sidesToUpdate = CableHelpers.getCableConnections(cable);
                sidesToUpdate.add(cableConnectionHit);
                CableHelpers.updateConnectionsNeighbours((IBlockReader)world, pos, sidesToUpdate);
                NetworkHelpers.initNetwork(world, pos, side);
                NetworkHelpers.initNetwork(world, pos.func_177972_a(cableConnectionHit), side.func_176734_d());
            } else if (cableConnectionHit == null && (neighbourCable = (ICable)CableHelpers.getCable((IBlockReader)world, neighbourPos = pos.func_177972_a(side), side.func_176734_d()).orElse(null)) != null && !cable.isConnected(side) && (cable.canConnect(neighbourCable, side) || neighbourCable.canConnect(cable, side.func_176734_d()))) {
                cable.reconnect(side);
                neighbourCable.reconnect(side.func_176734_d());
                cable.updateConnections();
                Collection<Direction> sidesToUpdate = CableHelpers.getCableConnections(cable);
                sidesToUpdate.add(side);
                CableHelpers.updateConnectionsNeighbours((IBlockReader)world, pos, sidesToUpdate);
                NetworkHelpers.initNetwork(world, pos, side);
                NetworkHelpers.initNetwork(world, neighbourPos, side.func_176734_d());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void onCableAdded(World world, BlockPos pos) {
        CableHelpers.updateConnectionsNeighbours((IBlockReader)world, pos, ALL_SIDES);
        if (!world.func_201670_d()) {
            NetworkHelpers.initNetwork(world, pos, null).ifPresent(network -> MinecraftForge.EVENT_BUS.post((Event)new NetworkInitializedEvent((INetwork)network, world, pos, null)));
        }
    }

    public static void onCableAddedByPlayer(World world, BlockPos pos, @Nullable LivingEntity placer) {
        CableHelpers.updateConnectionsNeighbours((IBlockReader)world, pos, ALL_SIDES);
        if (!world.func_201670_d()) {
            NetworkHelpers.initNetwork(world, pos, null).ifPresent(network -> MinecraftForge.EVENT_BUS.post((Event)new NetworkInitializedEvent((INetwork)network, world, pos, placer)));
        }
    }

    public static boolean onCableRemoving(World world, BlockPos pos, boolean dropMainElement, boolean saveState) {
        if (!world.func_201670_d() && CableHelpers.isNoFakeCable((IBlockReader)world, pos, null)) {
            INetworkCarrier networkCarrier = (INetworkCarrier)NetworkHelpers.getNetworkCarrier((IBlockReader)world, pos, null).orElse(null);
            LinkedList itemStacks = Lists.newLinkedList();
            INetworkElementProvider networkElementProvider = (INetworkElementProvider)NetworkHelpers.getNetworkElementProvider((IBlockReader)world, pos, null).orElse(null);
            if (networkElementProvider != null) {
                for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                    networkElement.addDrops(itemStacks, dropMainElement, saveState);
                }
                for (ItemStack itemStack : itemStacks) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
            if (networkCarrier != null && networkCarrier.getNetwork() != null) {
                IPathElement pathElement = (IPathElement)CableHelpers.getPathElement((IBlockReader)world, pos, null).orElseThrow(() -> new IllegalStateException("Could not find a valid path element capability"));
                INetwork network = networkCarrier.getNetwork();
                networkCarrier.setNetwork(null);
                return network.removePathElement(pathElement, null);
            }
        }
        return true;
    }

    public static boolean onCableRemoved(World world, BlockPos pos, Collection<Direction> sides) {
        CableHelpers.updateConnectionsNeighbours((IBlockReader)world, pos, sides);
        if (!world.func_201670_d()) {
            for (Direction side : sides) {
                BlockPos sidePos = pos.func_177972_a(side);
                NetworkHelpers.initNetwork(world, sidePos, side.func_176734_d());
            }
        }
        return true;
    }

    public static boolean isRemovingCable() {
        return removingCable;
    }

    public static void setRemovingCable(boolean removingCable) {
        CableHelpers.removingCable = removingCable;
    }

    public static void removeCable(World world, BlockPos pos, @Nullable PlayerEntity player) {
        removingCable = true;
        ICable cable = (ICable)CableHelpers.getCable((IBlockReader)world, pos, null).orElse(null);
        ICableFakeable cableFakeable = (ICableFakeable)CableHelpers.getCableFakeable((IBlockReader)world, pos, null).orElse(null);
        IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer((IBlockReader)world, pos, null).orElse(null);
        BlockState blockState = world.func_180495_p(pos);
        if (cable == null) {
            removingCable = false;
            return;
        }
        Collection<Direction> connectedCables = CableHelpers.getCableConnections(cable);
        CableHelpers.onCableRemoving(world, pos, false, false);
        if (cableFakeable == null || partContainer == null || !partContainer.hasParts()) {
            cable.destroy();
        } else {
            cableFakeable.setRealCable(false);
        }
        if (player == null) {
            ItemStackHelpers.spawnItemStack((World)world, (BlockPos)pos, (ItemStack)cable.getItemStack());
        } else if (!player.func_184812_l_()) {
            ItemStackHelpers.spawnItemStackToPlayer((World)world, (BlockPos)pos, (ItemStack)cable.getItemStack(), (PlayerEntity)player);
        }
        CableHelpers.onCableRemoved(world, pos, connectedCables);
        ItemBlockCable.playBreakSound(world, pos, blockState);
        removingCable = false;
    }

    public static boolean hasFacade(IBlockReader world, BlockPos pos) {
        LazyOptional ret = TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, null, FacadeableConfig.CAPABILITY);
        ret.resolve();
        return ret.map(IFacadeable::hasFacade).orElse(false);
    }

    public static LazyOptional<BlockState> getFacade(IBlockReader world, BlockPos pos) {
        return TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, null, FacadeableConfig.CAPABILITY).lazyMap(IFacadeable::getFacade);
    }

    public static boolean isLightTransparent(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return PartHelpers.getPartContainer(world, pos, side).map(partContainer -> {
            for (Map.Entry<Direction, IPartType<?, ?>> entry : partContainer.getParts().entrySet()) {
                IPartType<?, ?> part = entry.getValue();
                if (!part.forceLightTransparency(partContainer.getPartState(entry.getKey()))) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public static Collection<Direction> getCableConnections(ICable cable) {
        Set sides = Sets.newIdentityHashSet();
        for (Direction side : Direction.values()) {
            if (!cable.isConnected(side)) continue;
            sides.add(side);
        }
        return sides;
    }

    public static Collection<Direction> getExternallyConnectedCables(World world, BlockPos pos) {
        Set sides = Sets.newIdentityHashSet();
        for (Direction side : Direction.values()) {
            if (!CableHelpers.isCableConnected((IBlockReader)world, pos.func_177972_a(side), side.func_176734_d())) continue;
            sides.add(side);
        }
        return sides;
    }

    static {
        for (Direction side : Direction.values()) {
            ALL_SIDES.add(side);
        }
        removingCable = false;
    }
}

