/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.part.PartTypeConfigurable;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartTypeAspects<P extends IPartType<P, S>, S extends IPartState<P>>
extends PartTypeConfigurable<P, S> {
    public PartTypeAspects(String name, PartRenderPosition partRenderPosition) {
        super(name, partRenderPosition);
    }

    public Set<IAspect> getAspects() {
        return Aspects.REGISTRY.getAspects(this);
    }

    @Override
    public boolean isUpdate(S state) {
        return !this.getAspects().isEmpty();
    }

    @Override
    public int getConsumptionRate(S state) {
        return 1;
    }

    @Override
    public void loadTooltip(ItemStack itemStack, List<ITextComponent> lines) {
        super.loadTooltip(itemStack, lines);
        if (this.getAspects().isEmpty()) {
            lines.add((ITextComponent)new TranslationTextComponent("parttype.integrateddynamics.tooltip.noaspects").func_240699_a_(TextFormatting.GOLD));
        }
    }
}

