/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;

public class RecipeDryingBasin
implements IRecipe<IInventoryFluid> {
    private final ResourceLocation id;
    private final Ingredient inputIngredient;
    private final FluidStack inputFluid;
    private final ItemStack outputItem;
    private final FluidStack outputFluid;
    private final int duration;

    public RecipeDryingBasin(ResourceLocation id, Ingredient inputIngredient, FluidStack inputFluid, ItemStack outputItem, FluidStack outputFluid, int duration) {
        this.id = id;
        this.inputIngredient = inputIngredient;
        this.inputFluid = inputFluid;
        this.outputItem = outputItem;
        this.outputFluid = outputFluid;
        this.duration = duration;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean matches(IInventoryFluid inv, World worldIn) {
        return this.inputIngredient.test(inv.func_70301_a(0)) && this.inputFluid.getFluid() == inv.getFluidHandler().getFluidInTank(0).getFluid() && this.inputFluid.getAmount() <= inv.getFluidHandler().getFluidInTank(0).getAmount();
    }

    public ItemStack getCraftingResult(IInventoryFluid inv) {
        return this.outputItem.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack func_77571_b() {
        return this.outputItem;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RegistryEntries.RECIPESERIALIZER_DRYING_BASIN;
    }

    public IRecipeType<?> func_222127_g() {
        return RegistryEntries.RECIPETYPE_DRYING_BASIN;
    }
}

