/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RecipeSerializerSqueezer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RecipeSqueezer> {
    protected static RecipeSqueezer.ItemStackChance getJsonItemStackChance(JsonObject json) {
        ItemStack itemStack = RecipeSerializerHelpers.getJsonItemStackOrTag((JsonObject)json, (boolean)true, GeneralConfig.recipeTagOutputModPriorities);
        float chance = JSONUtils.func_151221_a((JsonObject)json, (String)"chance", (float)1.0f);
        return new RecipeSqueezer.ItemStackChance(itemStack, chance);
    }

    protected static NonNullList<RecipeSqueezer.ItemStackChance> getJsonItemStackChances(JsonObject json, String key) {
        JsonElement element = json.get(key);
        if (element == null) {
            return NonNullList.func_191196_a();
        }
        if (element.isJsonArray()) {
            JsonArray jsonElements = element.getAsJsonArray();
            NonNullList elements = NonNullList.func_191196_a();
            for (JsonElement jsonElement : jsonElements) {
                elements.add((Object)RecipeSerializerSqueezer.getJsonItemStackChance(jsonElement.getAsJsonObject()));
            }
            return elements;
        }
        throw new JsonSyntaxException("A JSON array is required as value for " + key);
    }

    public RecipeSqueezer read(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)true);
        NonNullList<RecipeSqueezer.ItemStackChance> outputItemStacks = RecipeSerializerSqueezer.getJsonItemStackChances(result, "items");
        FluidStack outputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)result, (String)"fluid", (boolean)false);
        if (inputIngredient.func_203189_d()) {
            throw new JsonSyntaxException("An input item is required");
        }
        if (outputItemStacks.isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        return new RecipeSqueezer(recipeId, inputIngredient, outputItemStacks, outputFluid);
    }

    @Nullable
    public RecipeSqueezer read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient inputIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        NonNullList outputItemStacks = NonNullList.func_191196_a();
        int outputItemStacksCount = buffer.readInt();
        for (int i = 0; i < outputItemStacksCount; ++i) {
            outputItemStacks.add((Object)new RecipeSqueezer.ItemStackChance(buffer.func_150791_c(), buffer.readFloat()));
        }
        FluidStack outputFluid = FluidStack.readFromPacket((PacketBuffer)buffer);
        return new RecipeSqueezer(recipeId, inputIngredient, (NonNullList<RecipeSqueezer.ItemStackChance>)outputItemStacks, outputFluid);
    }

    public void write(PacketBuffer buffer, RecipeSqueezer recipe) {
        recipe.getInputIngredient().func_199564_a(buffer);
        buffer.writeInt(recipe.getOutputItems().size());
        for (RecipeSqueezer.ItemStackChance outputItem : recipe.getOutputItems()) {
            buffer.func_150788_a(outputItem.getItemStack());
            buffer.writeFloat(outputItem.getChance());
        }
        recipe.getOutputFluid().writeToPacket(buffer);
    }
}

