/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import java.util.Optional;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.slot.SlotRemoveOnly;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerActiveVariableBase;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.tileentity.TileDelay;

public class ContainerDelay
extends ContainerActiveVariableBase<TileDelay> {
    private final int lastUpdateValueId;
    private final int lastCapacityValueId;

    public ContainerDelay(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, (IInventory)new Inventory(3), Optional.empty());
    }

    public ContainerDelay(int id, PlayerInventory playerInventory, IInventory inventory, Optional<TileDelay> tileSupplier) {
        super(RegistryEntries.CONTAINER_DELAY, id, playerInventory, inventory, tileSupplier);
        this.func_75146_a((Slot)new SlotVariable(inventory, 0, 81, 25));
        this.func_75146_a((Slot)new SlotVariable(inventory, 1, 56, 78));
        this.func_75146_a((Slot)new SlotRemoveOnly(inventory, 2, 104, 78));
        this.addPlayerInventory(playerInventory, this.offsetX + 9, this.offsetY + 145);
        this.lastUpdateValueId = this.getNextValueId();
        this.lastCapacityValueId = this.getNextValueId();
        this.getTileSupplier().ifPresent(tile -> tile.setLastPlayer(playerInventory.field_70458_d));
    }

    protected void initializeValues() {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastUpdateValueId, (int)this.getTileSupplier().map(TileDelay::getUpdateInterval).orElse(0));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastCapacityValueId, (int)this.getTileSupplier().map(TileDelay::getCapacity).orElse(0));
    }

    public int getLastUpdateValueId() {
        return this.lastUpdateValueId;
    }

    public int getLastCapacityValueId() {
        return this.lastCapacityValueId;
    }

    public int getLastUpdateValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.getLastUpdateValueId());
    }

    public int getLastCapacityValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.getLastCapacityValueId());
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        super.onUpdate(valueId, value);
        this.getTileSupplier().ifPresent(tile -> {
            if (valueId == this.getLastUpdateValueId()) {
                tile.setUpdateInterval(this.getLastUpdateValue());
            } else if (valueId == this.getLastCapacityValueId()) {
                tile.setCapacity(this.getLastCapacityValue());
            }
        });
    }
}

