/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.client.render.model.FacadeModel;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemFacade
extends Item
implements IDynamicModelElement {
    public ItemFacade(Item.Properties properties) {
        super(properties);
    }

    public BlockState getFacadeBlock(ItemStack itemStack) {
        if (!itemStack.func_190926_b() && itemStack.func_77942_o()) {
            CompoundNBT tag = itemStack.func_77978_p();
            return BlockHelpers.deserializeBlockState((CompoundNBT)tag.func_74775_l("block"));
        }
        return null;
    }

    public ItemStack getFacadeBlockItem(ItemStack itemStack) {
        BlockState blockState = this.getFacadeBlock(itemStack);
        if (blockState != null) {
            return BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
        }
        return null;
    }

    public void writeFacadeBlock(ItemStack itemStack, BlockState blockState) {
        CompoundNBT tag = itemStack.func_196082_o();
        CompoundNBT serializedBlockState = BlockHelpers.serializeBlockState((BlockState)blockState);
        tag.func_218657_a("block", (INBT)serializedBlockState);
    }

    public ITextComponent func_200295_i(ItemStack itemStack) {
        IFormattableTextComponent suffix = new TranslationTextComponent("general.integrateddynamics.info.none").func_240699_a_(TextFormatting.ITALIC);
        ItemStack itemStackInner = this.getFacadeBlockItem(itemStack);
        if (itemStackInner != null) {
            suffix = this.getFacadeBlockItem(itemStack).func_200301_q();
        }
        return ((IFormattableTextComponent)super.func_200295_i(itemStack)).func_240702_b_(" - ").func_230529_a_((ITextComponent)suffix);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        if (!context.func_195991_k().func_201670_d()) {
            IFacadeable facadeable = (IFacadeable)TileHelpers.getCapability((IBlockReader)context.func_195991_k(), (BlockPos)context.func_195995_a(), null, FacadeableConfig.CAPABILITY).orElse(null);
            BlockState blockState = this.getFacadeBlock(itemStack);
            if (facadeable != null && blockState != null && !facadeable.hasFacade()) {
                facadeable.setFacade(blockState);
                ItemBlockCable.playPlaceSound(context.func_195991_k(), context.func_195995_a());
                itemStack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBakedModel createDynamicModel(ModelBakeEvent event) {
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "inventory");
        FacadeModel.emptyModel = (IBakedModel)event.getModelRegistry().get(location);
        return new FacadeModel();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemFacade)) {
            return false;
        }
        ItemFacade other = (ItemFacade)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemFacade;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "ItemFacade()";
    }
}

