/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventoryState;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.recipe.type.InventoryFluid;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerDryingBasin;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class TileDryingBasin
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    private static final int WOOD_IGNITION_TEMPERATURE = 573;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private final SimpleInventory inventory;
    private final SingleUseTank tank;
    @NBTPersist
    private Float randomRotation = Float.valueOf(0.0f);
    @NBTPersist
    private int progress = 0;
    @NBTPersist
    private int fire = 0;
    private SingleCache<Pair<ItemStack, FluidStack>, Optional<RecipeDryingBasin>> recipeCache;

    public TileDryingBasin() {
        super(RegistryEntries.TILE_ENTITY_DRYING_BASIN);
        this.inventory = new SimpleInventory(1, 1){

            public boolean func_94041_b(int i, ItemStack itemstack) {
                return this.func_70301_a(0).func_190926_b();
            }

            public void func_70299_a(int slotId, ItemStack itemstack) {
                super.func_70299_a(slotId, itemstack);
                TileDryingBasin.this.randomRotation = Float.valueOf(((TileDryingBasin)TileDryingBasin.this).field_145850_b.field_73012_v.nextFloat() * 360.0f);
                TileDryingBasin.this.sendUpdate();
            }
        };
        this.tank = new SingleUseTank(1000);
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> ((SimpleInventory)this.getInventory()).getItemHandler()));
        this.addCapabilityInternal(Capabilities.INVENTORY_STATE, LazyOptional.of(() -> new SimpleInventoryState(this.getInventory())));
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(this::getTank));
        this.inventory.addDirtyMarkListener(() -> ((TileDryingBasin)this).sendUpdate());
        this.tank.addDirtyMarkListener(() -> ((SimpleInventory)this.inventory).func_70296_d());
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, Optional<RecipeDryingBasin>>(){

            public Optional<RecipeDryingBasin> getNewValue(Pair<ItemStack, FluidStack> key) {
                InventoryFluid recipeInput = new InventoryFluid(NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{(ItemStack)key.getLeft()}), NonNullList.func_193580_a((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{(FluidStack)key.getRight()}));
                return CraftingHelpers.findServerRecipe(TileDryingBasin.this.getRegistry(), (IInventory)recipeInput, (World)TileDryingBasin.this.func_145831_w());
            }

            public boolean isKeyEqual(Pair<ItemStack, FluidStack> cacheKey, Pair<ItemStack, FluidStack> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getRight()), (FluidStack)((FluidStack)newKey.getRight())) && FluidHelpers.getAmount((FluidStack)((FluidStack)cacheKey.getRight())) == FluidHelpers.getAmount((FluidStack)((FluidStack)newKey.getRight()));
            }
        });
        this.addCapabilityInternal(Capabilities.RECIPE_HANDLER, LazyOptional.of(() -> new RecipeHandlerDryingBasin(() -> ((TileDryingBasin)this).func_145831_w())));
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void read(CompoundNBT tag) {
        this.inventory.readFromNBT(tag, "inventory");
        this.tank.readFromNBT(tag, "tank");
        super.read(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.writeToNBT(tag, "inventory");
        this.tank.writeToNBT(tag, "tank");
        return super.func_189515_b(tag);
    }

    protected IRecipeType<RecipeDryingBasin> getRegistry() {
        return RegistryEntries.RECIPETYPE_DRYING_BASIN;
    }

    public Optional<RecipeDryingBasin> getCurrentRecipe() {
        return (Optional)this.recipeCache.get((Object)Pair.of((Object)this.getInventory().func_70301_a(0).func_77946_l(), (Object)FluidHelpers.copy((FluidStack)this.getTank().getFluid())));
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.field_145850_b.func_201670_d()) {
            Optional<RecipeDryingBasin> currentRecipe = this.getCurrentRecipe();
            if (!this.getTank().isEmpty() && this.getTank().getFluid().getFluid().getAttributes().getTemperature(this.getTank().getFluid()) >= 573) {
                if (++this.fire >= 100) {
                    this.func_145831_w().func_175656_a(this.func_174877_v(), Blocks.field_150480_ab.func_176223_P());
                } else if (this.func_145831_w().func_175623_d(this.func_174877_v().func_177972_a(Direction.UP)) && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                    this.func_145831_w().func_175656_a(this.func_174877_v().func_177972_a(Direction.UP), Blocks.field_150480_ab.func_176223_P());
                }
            } else if (currentRecipe.isPresent()) {
                RecipeDryingBasin recipe = currentRecipe.get();
                if (this.progress >= recipe.getDuration()) {
                    ItemStack output = recipe.getOutputItem();
                    if (!output.func_190926_b()) {
                        output = output.func_77946_l();
                        this.getInventory().func_70299_a(0, output);
                        int amount = FluidHelpers.getAmount((FluidStack)recipe.getInputFluid());
                        this.getTank().drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        if (!recipe.getOutputFluid().isEmpty() && this.getTank().fill(recipe.getOutputFluid(), IFluidHandler.FluidAction.EXECUTE) == 0) {
                            IntegratedDynamics.clog(Level.ERROR, "Encountered an invalid recipe: " + recipe.func_199560_c());
                        }
                    }
                    this.progress = 0;
                } else {
                    ++this.progress;
                    this.func_70296_d();
                }
                this.fire = 0;
            } else if (this.progress > 0 || this.fire > 0) {
                this.progress = 0;
                this.fire = 0;
                this.func_70296_d();
            }
        } else if (this.progress > 0 && this.field_145850_b.field_73012_v.nextInt(5) == 0) {
            BlockState blockState;
            if (!this.getTank().isEmpty() && (blockState = this.getTank().getFluid().getFluid().getAttributes().getBlock((IBlockDisplayReader)this.func_145831_w(), this.func_174877_v(), this.getTank().getFluid().getFluid().func_207188_f())) != null) {
                this.func_145831_w().func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, blockState), (double)this.func_174877_v().func_177958_n() + Math.random() * 0.8 + 0.1, (double)this.func_174877_v().func_177956_o() + Math.random() * 0.1 + 0.9, (double)this.func_174877_v().func_177952_p() + Math.random() * 0.8 + 0.1, 0.0, 0.1, 0.0);
            }
            if (!this.getInventory().func_70301_a(0).func_190926_b()) {
                ItemStack itemStack = this.getInventory().func_70301_a(0);
                this.func_145831_w().func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemStack), (double)this.func_174877_v().func_177958_n() + Math.random() * 0.8 + 0.1, (double)this.func_174877_v().func_177956_o() + Math.random() * 0.1 + 0.9, (double)this.func_174877_v().func_177952_p() + Math.random() * 0.8 + 0.1, 0.0, 0.1, 0.0);
            }
        }
    }

    public float getRandomRotation() {
        return this.randomRotation.floatValue();
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

