/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DifferShapedRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> pattern = new ArrayList<String>();
    private final Map<Character, Ingredient> key = new LinkedHashMap<Character, Ingredient>();
    private String group;
    private String[] mods;
    private String[] conditions;
    private String[] flags;

    public DifferShapedRecipeBuilder(IItemProvider resultIn, int countIn) {
        this.result = resultIn.func_199767_j();
        this.count = countIn;
    }

    public DifferShapedRecipeBuilder key(Character symbol, ITag<Item> tagIn) {
        return this.key(symbol, Ingredient.func_199805_a(tagIn));
    }

    public DifferShapedRecipeBuilder key(Character symbol, IItemProvider itemIn) {
        return this.key(symbol, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public DifferShapedRecipeBuilder key(Character symbol, Ingredient ingredientIn) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredientIn);
        return this;
    }

    public DifferShapedRecipeBuilder patternLine(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public DifferShapedRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public DifferShapedRecipeBuilder addModCompat(String ... mods) {
        this.mods = mods;
        return this;
    }

    public DifferShapedRecipeBuilder addConditions(String ... conditions) {
        this.conditions = conditions;
        return this;
    }

    public DifferShapedRecipeBuilder addFlags(String ... flags) {
        this.flags = flags;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        ResourceLocation loc = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        this.build(consumerIn, new ResourceLocation(loc.func_110624_b(), "crafting/" + loc.func_110623_a()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.pattern, this.key, this.mods == null ? new String[]{} : this.mods, this.conditions == null ? new String[]{} : this.conditions, this.flags == null ? new String[]{} : this.flags));
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet<Character> set = new HashSet<Character>(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final String[] mods;
        private final String[] conditions;
        private final String[] flags;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<String> patternIn, Map<Character, Ingredient> keyIn, String[] mods, String[] conditions, String[] flags) {
            this.id = idIn;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.pattern = patternIn;
            this.key = keyIn;
            this.mods = mods;
            this.conditions = conditions;
            this.flags = flags;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            if (this.conditions.length != 0 || this.mods.length != 0 || this.flags.length != 0) {
                JsonObject temp;
                JsonArray jsonArray = new JsonArray();
                for (String mod : this.mods) {
                    if (mod == null) continue;
                    temp = new JsonObject();
                    temp.addProperty("type", "forge:mod_loaded");
                    temp.addProperty("modid", mod);
                    jsonArray.add((JsonElement)temp);
                }
                for (String condition : this.conditions) {
                    if (condition == null) continue;
                    temp = new JsonObject();
                    temp.addProperty("type", "differentiate:condition");
                    temp.addProperty("condition", condition);
                    jsonArray.add((JsonElement)temp);
                }
                for (String flag : this.flags) {
                    if (flag == null) continue;
                    temp = new JsonObject();
                    temp.addProperty("type", "differentiate:flag");
                    temp.addProperty("flag", flag);
                    jsonArray.add((JsonElement)temp);
                }
                json.add("conditions", (JsonElement)jsonArray);
            }
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222157_a;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

