/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.registrator;

import co.eltrut.differentiate.common.item.FuelBlockItem;
import co.eltrut.differentiate.core.registrator.AbstractHelper;
import co.eltrut.differentiate.core.registrator.ItemHelper;
import co.eltrut.differentiate.core.registrator.Registrator;
import co.eltrut.differentiate.core.util.GroupUtil;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockHelper
extends AbstractHelper<Block> {
    protected final ItemHelper itemRegister;

    public BlockHelper(Registrator parent) {
        super(parent, ForgeRegistries.BLOCKS);
        this.itemRegister = (ItemHelper)this.parent.getHelper(ForgeRegistries.ITEMS);
    }

    public RegistryObject<Block> createBlock(String name, Supplier<Block> block, Item.Properties props) {
        RegistryObject registeredBlock = this.registry.register(name, block);
        this.itemRegister.createItem(name, () -> new BlockItem((Block)registeredBlock.get(), props));
        return registeredBlock;
    }

    public RegistryObject<Block> createSimpleBlock(String name, Supplier<Block> block, ItemGroup group, String ... mods) {
        return this.createBlock(name, block, GroupUtil.getProps(group, mods));
    }

    public RegistryObject<Block> createFuelBlock(String name, Supplier<Block> block, Item.Properties props, int burnTime) {
        RegistryObject registeredBlock = this.registry.register(name, block);
        this.itemRegister.createItem(name, () -> new FuelBlockItem((Block)registeredBlock.get(), props, burnTime));
        return registeredBlock;
    }

    public RegistryObject<Block> createSimpleFuelBlock(String name, Supplier<Block> block, ItemGroup group, int burnTime, String ... mods) {
        return this.createFuelBlock(name, block, GroupUtil.getProps(group, mods), burnTime);
    }
}

