/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.registrator;

import co.eltrut.differentiate.common.interf.IColoredBlock;
import co.eltrut.differentiate.common.interf.IColoredItem;
import co.eltrut.differentiate.common.interf.ICompostableItem;
import co.eltrut.differentiate.common.interf.IFlammableBlock;
import co.eltrut.differentiate.common.interf.IRenderTypeBlock;
import co.eltrut.differentiate.common.interf.IRendererTileEntity;
import co.eltrut.differentiate.common.interf.Interface;
import co.eltrut.differentiate.core.registrator.BlockHelper;
import co.eltrut.differentiate.core.registrator.IHelper;
import co.eltrut.differentiate.core.registrator.ItemHelper;
import co.eltrut.differentiate.core.registrator.TileEntityHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Registrator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<Registrator> REGISTRATORS = new ArrayList<Registrator>();
    private final String modid;
    private final Map<IForgeRegistry<?>, IHelper<?>> helpers = new HashMap();

    public Registrator(String modid) {
        this.modid = modid;
        REGISTRATORS.add(this);
        this.helpers.put(ForgeRegistries.ITEMS, new ItemHelper(this));
        this.helpers.put(ForgeRegistries.BLOCKS, new BlockHelper(this));
        this.helpers.put(ForgeRegistries.TILE_ENTITIES, new TileEntityHelper(this));
    }

    public static Registrator create(String modid, Consumer<Registrator> consumer) {
        Registrator registrator = new Registrator(modid);
        consumer.accept(registrator);
        return registrator;
    }

    public void register(IEventBus bus) {
        for (IHelper<?> helper : this.helpers.values()) {
            helper.register(bus);
        }
    }

    public static void registerCommon(FMLCommonSetupEvent event) {
        Registrator.registerAttribute(ForgeRegistries.BLOCKS, ICompostableItem.class, s -> ComposterBlock.field_220299_b.put((Object)s.func_199767_j(), ((ICompostableItem)s).getCompostableChance()));
        Registrator.registerAttribute(ForgeRegistries.ITEMS, ICompostableItem.class, s -> ComposterBlock.field_220299_b.put(s, ((ICompostableItem)s).getCompostableChance()));
        LOGGER.info("Registered block and item compostables");
        Registrator.registerAttribute(ForgeRegistries.BLOCKS, IFlammableBlock.class, s -> ((FireBlock)Blocks.field_150480_ab).func_180686_a(s, ((IFlammableBlock)s).getEncouragement(), ((IFlammableBlock)s).getFlammability()));
        LOGGER.info("Registered block flammables");
    }

    public static void registerClient(FMLClientSetupEvent event) {
        Registrator.registerAttribute(ForgeRegistries.BLOCKS, IRenderTypeBlock.class, s -> RenderTypeLookup.setRenderLayer((Block)s, (RenderType)((IRenderTypeBlock)s).getRenderType()));
        LOGGER.info("Registered block cutouts");
        Registrator.registerAttribute(ForgeRegistries.BLOCKS, IColoredBlock.class, s -> Minecraft.func_71410_x().func_184125_al().func_186722_a(((IColoredBlock)s).getBlockColor(), new Block[]{s}));
        Registrator.registerAttribute(ForgeRegistries.ITEMS, IColoredItem.class, s -> Minecraft.func_71410_x().getItemColors().func_199877_a(((IColoredItem)s).getItemColor(), new IItemProvider[]{s}));
        LOGGER.info("Registered block and item colors");
        Registrator.registerAttribute(ForgeRegistries.TILE_ENTITIES, IRendererTileEntity.class, s -> ClientRegistry.bindTileEntityRenderer((TileEntityType)s, ((IRendererTileEntity)s).getRendererFactory()));
        LOGGER.info("Registered tile entity renderers");
    }

    public String getModId() {
        return this.modid;
    }

    public <T extends IHelper<?>> T getHelper(IForgeRegistry<?> registry) {
        return (T)this.helpers.get(registry);
    }

    public Map<IForgeRegistry<?>, IHelper<?>> getHelpers() {
        return this.helpers;
    }

    public static <T extends IForgeRegistryEntry<T>> void registerAttribute(IForgeRegistry<T> registry, Class<? extends Interface> clazz, Consumer<T> consumer) {
        registry.getValues().stream().filter(clazz::isInstance).forEach(consumer);
    }
}

