/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.util;

import co.eltrut.differentiate.core.datagen.recipe.CuttingRecipeBuilder;
import co.eltrut.differentiate.core.datagen.recipe.DifferCookingRecipeBuilder;
import co.eltrut.differentiate.core.datagen.recipe.DifferShapedRecipeBuilder;
import co.eltrut.differentiate.core.datagen.recipe.DifferShapelessRecipeBuilder;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public class RecipeUtil {
    public static DifferShapedRecipeBuilder shapedRecipe(IItemProvider resultIn) {
        return RecipeUtil.shapedRecipe(resultIn, 1);
    }

    public static DifferShapedRecipeBuilder shapedRecipe(IItemProvider resultIn, int countIn) {
        return new DifferShapedRecipeBuilder(resultIn, countIn);
    }

    public static DifferShapelessRecipeBuilder shapelessRecipe(IItemProvider resultIn) {
        return RecipeUtil.shapelessRecipe(resultIn, 1);
    }

    public static DifferShapelessRecipeBuilder shapelessRecipe(IItemProvider resultIn, int countIn) {
        return new DifferShapelessRecipeBuilder(resultIn, countIn);
    }

    public static DifferCookingRecipeBuilder cookingRecipe(Ingredient ingredientIn, IItemProvider resultIn, float experienceIn, int cookingTimeIn, CookingRecipeSerializer<?> serializer) {
        return new DifferCookingRecipeBuilder(resultIn, ingredientIn, experienceIn, cookingTimeIn, serializer);
    }

    public static DifferCookingRecipeBuilder blastingRecipe(Ingredient ingredientIn, IItemProvider resultIn, float experienceIn, int cookingTimeIn) {
        return RecipeUtil.cookingRecipe(ingredientIn, resultIn, experienceIn, cookingTimeIn, IRecipeSerializer.field_222172_p);
    }

    public static DifferCookingRecipeBuilder smeltingRecipe(Ingredient ingredientIn, IItemProvider resultIn, float experienceIn, int cookingTimeIn) {
        return RecipeUtil.cookingRecipe(ingredientIn, resultIn, experienceIn, cookingTimeIn, IRecipeSerializer.field_222171_o);
    }

    public static DifferCookingRecipeBuilder smokingRecipe(Ingredient ingredientIn, IItemProvider resultIn, float experienceIn, int cookingTimeIn) {
        return RecipeUtil.cookingRecipe(ingredientIn, resultIn, experienceIn, cookingTimeIn, IRecipeSerializer.field_222173_q);
    }

    public static DifferCookingRecipeBuilder bakingRecipe(Ingredient ingredientIn, IItemProvider resultIn, float experienceIn, int cookingTimeIn) {
        return RecipeUtil.cookingRecipe(ingredientIn, resultIn, experienceIn, cookingTimeIn, (CookingRecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation("environmental", "baking")));
    }

    public static CuttingRecipeBuilder stonecuttingRecipe(Ingredient ingredientIn, IItemProvider resultIn) {
        return RecipeUtil.stonecuttingRecipe(ingredientIn, resultIn, 1);
    }

    public static CuttingRecipeBuilder stonecuttingRecipe(Ingredient ingredientIn, IItemProvider resultIn, int countIn) {
        return new CuttingRecipeBuilder(IRecipeSerializer.field_222175_s, ingredientIn, resultIn, countIn);
    }

    public static CuttingRecipeBuilder sawingRecipe(Ingredient ingredientIn, IItemProvider resultIn) {
        return RecipeUtil.sawingRecipe(ingredientIn, resultIn, 1);
    }

    public static CuttingRecipeBuilder sawingRecipe(Ingredient ingredientIn, IItemProvider resultIn, int countIn) {
        return new CuttingRecipeBuilder((IRecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation("environmental", "sawing")), ingredientIn, resultIn, countIn);
    }

    public static void slabCraftingRecipe(Consumer<IFinishedRecipe> consumer, Block result, Block parent, String[] mods, String[] conditions, String[] flags) {
        RecipeUtil.shapedRecipe((IItemProvider)result, 6).patternLine("XXX").key(Character.valueOf('X'), (IItemProvider)parent).addModCompat(mods).addConditions(conditions).addFlags(flags).build(consumer);
    }

    public static void stairsCraftingRecipe(Consumer<IFinishedRecipe> consumer, Block result, Block parent, String[] mods, String[] conditions, String[] flags) {
        RecipeUtil.shapedRecipe((IItemProvider)result, 4).patternLine("X  ").patternLine("XX ").patternLine("XXX").key(Character.valueOf('X'), (IItemProvider)parent).addModCompat(mods).addConditions(conditions).addFlags(flags).build(consumer);
    }

    public static void wallCraftingRecipe(Consumer<IFinishedRecipe> consumer, Block result, Block parent, String[] mods, String[] conditions, String[] flags) {
        RecipeUtil.shapedRecipe((IItemProvider)result, 6).patternLine("XXX").patternLine("XXX").key(Character.valueOf('X'), (IItemProvider)parent).addModCompat(mods).addConditions(conditions).addFlags(flags).build(consumer);
    }

    public static void verticalSlabCraftingRecipe(Consumer<IFinishedRecipe> consumer, Block verticalSlab, Block slab, String[] mods, String[] conditions, String[] flags) {
        RecipeUtil.shapedRecipe((IItemProvider)verticalSlab, 3).patternLine("X").patternLine("X").patternLine("X").key(Character.valueOf('X'), (IItemProvider)slab).addModCompat(mods).addConditions(conditions).addFlags((String[])ArrayUtils.add((Object[])flags, (Object)"vertical_slabs")).build(consumer);
    }

    public static void verticalSlabRevertCraftingRecipe(Consumer<IFinishedRecipe> consumer, Block slab, Block verticalSlab, String[] mods, String[] conditions, String[] flags) {
        RecipeUtil.shapelessRecipe((IItemProvider)slab).addIngredient((IItemProvider)verticalSlab.func_199767_j()).addModCompat(mods).addConditions(conditions).addFlags((String[])ArrayUtils.add((Object[])flags, (Object)"vertical_slabs")).build(consumer);
    }
}

