/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus;

import com.legacy.structure_gel.util.ConfigTemplates;
import net.minecraft.world.Dimension;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DPConfig {
    public static final Common COMMON;
    protected static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ConfigTemplates.StructureConfig tower;
        public final ConfigTemplates.StructureConfig leviathan;
        public final ConfigTemplates.StructureConfig snowyTemple;
        public final ConfigTemplates.StructureConfig biggerDungeon;
        public final ConfigTemplates.StructureConfig endRuins;
        public final ConfigTemplates.StructureConfig warpedGarden;
        public final ConfigTemplates.StructureConfig soulPrison;
        public final ForgeConfigSpec.IntValue biggerDungeonMonsterBoxChance;
        public final ForgeConfigSpec.IntValue towerWaystoneChance;

        protected Common(ForgeConfigSpec.Builder builder) {
            this.tower = new ConfigTemplates.StructureConfig(builder, "tower").probability(0.75).spacing(25).offset(6).biomes(true, "#structure_gel:plains, #structure_gel:oak_forest, #structure_gel:dark_forest, #structure_gel:birch_forest, #structure_gel:mountain").validDimensions(Dimension.field_236053_b_.func_240901_a_().toString());
            this.leviathan = new ConfigTemplates.StructureConfig(builder, "leviathan").probability(1.0).spacing(36).offset(8).biomes(true, "#structure_gel:desert").validDimensions(Dimension.field_236053_b_.func_240901_a_().toString());
            this.snowyTemple = new ConfigTemplates.StructureConfig(builder, "snowy_temple").probability(1.0).spacing(36).offset(8).biomes(true, "#structure_gel:snowy_plains, #structure_gel:snowy_spruce_forest").validDimensions(Dimension.field_236053_b_.func_240901_a_().toString());
            this.biggerDungeon = new ConfigTemplates.StructureConfig(builder, "bigger_dungeon").probability(0.4).spacing(12).offset(5).biomes(true, "#structure_gel:overworld, !mushroom_fields, !mushroom_field_shore").validDimensions(Dimension.field_236053_b_.func_240901_a_().toString());
            this.endRuins = new ConfigTemplates.StructureConfig(builder, "end_ruins").probability(0.8).spacing(24).offset(8).biomes(true, "#structure_gel:outer_end_island").validDimensions(Dimension.field_236055_d_.func_240901_a_().toString());
            this.warpedGarden = new ConfigTemplates.StructureConfig(builder, "warped_garden").spacing(36).offset(8).biomes(true, "#structure_gel:ocean, !#structure_gel:frozen").validDimensions(Dimension.field_236053_b_.func_240901_a_().toString());
            this.soulPrison = new ConfigTemplates.StructureConfig(builder, "soul_prison").spacing(25).offset(6).biomes(true, "minecraft:soul_sand_valley").validDimensions(Dimension.field_236054_c_.func_240901_a_().toString());
            builder.push("quark compat");
            this.biggerDungeonMonsterBoxChance = builder.comment("Percent chance for monster boxes from Quark to generate in the buried dungeon").defineInRange("bigger_dungeon_monster_box_chance", 35, 0, 100);
            builder.pop();
            builder.push("waystones compat");
            this.towerWaystoneChance = builder.comment("Percent chance for a waystone from Waystones to generate on top of the tower").defineInRange("tower_waystone_chance", 100, 0, 100);
            builder.pop();
        }
    }
}

