/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures;

import com.legacy.dungeons_plus.DPUtil;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelConfigJigsawStructure;
import com.legacy.structure_gel.worldgen.jigsaw.GelJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EndRuinsStructure
extends GelConfigJigsawStructure {
    public EndRuinsStructure(Codec<VillageConfig> codec, ConfigTemplates.StructureConfig config) {
        super(codec, config, 0, true, true);
    }

    public int getSeed() {
        return 843152;
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public void handleStartFactory(GelJigsawStructure.Start start, DynamicRegistries dynamicRegistries, ChunkGenerator chunkGen, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, VillageConfig config) {
        int x = chunkX * 16 + 7;
        int z = chunkZ * 16 + 7;
        int y = chunkGen.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE_WG);
        if (y >= 60) {
            super.handleStartFactory(start, dynamicRegistries, chunkGen, templateManager, chunkX, chunkZ, biome, config);
            start.func_186161_c().removeIf(c -> c.func_74874_b().field_78895_b < 5);
            start.func_202500_a();
        }
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super(template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt);
        }

        public IStructurePieceType func_214807_k() {
            return DungeonsPlus.Structures.END_RUINS.getPieceType();
        }

        public boolean func_237001_a_(ISeedReader seedReader, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox bounds, BlockPos pos, boolean isLegacy) {
            if (super.func_237001_a_(seedReader, structureManager, chunkGen, rand, bounds, pos, isLegacy)) {
                if (this.getLocation().toString().contains("end_ruins/tower/base_")) {
                    this.extendDown((IWorld)seedReader, Blocks.field_150377_bs.func_176223_P(), bounds, this.field_214834_c, rand);
                }
                if (this.getLocation().toString().contains("end_ruins/pylon/")) {
                    this.extendDown((IWorld)seedReader, Blocks.field_150343_Z.func_176223_P(), bounds, this.field_214834_c, rand);
                }
                return true;
            }
            return false;
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox bounds) {
            if (key.contains("spawner")) {
                String[] data = key.split("-");
                DPUtil.placeSpawner(data[1], (IWorld)world, pos);
            }
        }
    }
}

