/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures;

import com.google.common.collect.ImmutableList;
import com.legacy.dungeons_plus.DPLoot;
import com.legacy.dungeons_plus.DPUtil;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelConfigJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.registries.ForgeRegistries;

public class TowerStructure
extends GelConfigJigsawStructure {
    public TowerStructure(Codec<VillageConfig> codec, ConfigTemplates.StructureConfig config) {
        super(codec, config, 0, true, true);
    }

    public int getSeed() {
        return 155166;
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public static final class Piece
    extends AbstractGelStructurePiece {
        public Piece(TemplateManager templateManager, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox bounds) {
            super(templateManager, jigsawPiece, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(templateManager, nbt);
        }

        public IStructurePieceType func_214807_k() {
            return DungeonsPlus.Structures.TOWER.getPieceType();
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox bounds) {
            String[] data;
            if (key.contains("chest")) {
                data = key.split("-");
                ResourceLocation lootTable = DPLoot.CHESTS_SIMPLE_DUNGEON;
                if (data[0].contains(":")) {
                    switch (data[0].split(":")[1]) {
                        case "vex": {
                            lootTable = DPLoot.Tower.CHEST_VEX_MAP;
                            break;
                        }
                        case "map": {
                            lootTable = DPLoot.Tower.CHEST_VEX;
                        }
                    }
                }
                DPUtil.createChest((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((Piece)this).func_191080_a(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5), world, bounds, rand, pos, lootTable, this.field_214834_c, data);
            }
            if (key.contains("spawner")) {
                data = key.split("-");
                DPUtil.placeSpawner(data[1], (IWorld)world, pos);
            }
            if (key.equals("armor_stand")) {
                this.setAir((IWorld)world, pos);
                ArmorStandEntity entity = (ArmorStandEntity)this.createEntity(EntityType.field_200789_c, world, pos, this.field_214834_c);
                entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151171_ah));
                for (Item item : ImmutableList.of((Object)Items.field_151169_ag, (Object)Items.field_151149_ai, (Object)Items.field_151151_aj)) {
                    if (!((double)rand.nextFloat() < 0.25)) continue;
                    entity.func_184201_a(MobEntity.func_184640_d((ItemStack)new ItemStack((IItemProvider)item)), new ItemStack((IItemProvider)item));
                }
                world.func_217376_c((Entity)entity);
            }
            if (key.contains("waystone")) {
                DPUtil.placeWaystone(world, pos, rand, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key.split("-")[1])));
            }
        }
    }
}

