/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.wandering_trapper.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import lilypuree.wandering_trapper.compat.IWeaponSelector;
import lilypuree.wandering_trapper.entity.WanderingTrapperEntity;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WanderingTrapperModel<T extends WanderingTrapperEntity>
extends EntityModel<T>
implements IHasArm,
IHasHead {
    public ModelRenderer head;
    public ModelRenderer body;
    public ModelRenderer handR;
    public ModelRenderer handL;
    public ModelRenderer legR;
    public ModelRenderer legL;
    public ModelRenderer hat;
    public ModelRenderer nose;
    public ModelRenderer coat;
    public ArmPose armPose = ArmPose.EMPTY;

    public WanderingTrapperModel(float scale) {
        this(scale, 64, 64);
    }

    public WanderingTrapperModel(float scale, int textureWidth, int textureHeight) {
        this.field_78090_t = textureWidth;
        this.field_78089_u = textureHeight;
        this.body = new ModelRenderer((Model)this).func_78787_b(textureWidth, textureHeight);
        this.body.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_78784_a(0, 38).func_228301_a_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, scale);
        this.coat = new ModelRenderer((Model)this).func_78787_b(textureWidth, textureHeight);
        this.coat.func_78793_a(0.0f, 0.0f, 0.0f);
        this.coat.func_78784_a(0, 0).func_228301_a_(-4.0f, 0.5f, -3.0f, 8.0f, 18.0f, 6.0f, scale + 0.7f);
        this.body.func_78792_a(this.coat);
        this.head = new ModelRenderer((Model)this).func_78787_b(textureWidth, textureHeight);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78784_a(20, 20).func_228301_a_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, scale);
        this.hat = new ModelRenderer((Model)this).func_78787_b(textureWidth, textureHeight);
        this.hat.func_78793_a(0.0f, 0.0f, 0.0f);
        this.hat.func_78784_a(28, 0).func_228301_a_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, scale + 0.5f);
        this.head.func_78792_a(this.hat);
        this.nose = new ModelRenderer((Model)this).func_78787_b(textureWidth, textureHeight);
        this.nose.func_78793_a(0.0f, -2.0f, 0.0f);
        this.nose.func_78784_a(22, 0).func_228301_a_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, scale);
        this.head.func_78792_a(this.nose);
        this.handR = new ModelRenderer((Model)this, 44, 44).func_78787_b(textureWidth, textureHeight);
        this.handR.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, scale);
        this.handR.func_78793_a(-5.0f, 2.0f, 0.0f);
        this.handL = new ModelRenderer((Model)this, 44, 44).func_78787_b(textureWidth, textureHeight);
        this.handL.field_78809_i = true;
        this.handL.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, scale);
        this.handL.func_78793_a(5.0f, 2.0f, 0.0f);
        this.legR = new ModelRenderer((Model)this, 28, 38).func_78787_b(textureWidth, textureHeight);
        this.legR.func_78793_a(-2.0f, 12.0f, 0.0f);
        this.legR.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, scale);
        this.legL = new ModelRenderer((Model)this, 28, 38).func_78787_b(textureWidth, textureHeight);
        this.legL.field_78809_i = true;
        this.legL.func_78793_a(2.0f, 12.0f, 0.0f);
        this.legL.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, scale);
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, int i, int i1, float v, float v1, float v2, float v3) {
        this.head.func_228309_a_(matrixStack, iVertexBuilder, i, i1, v, v1, v2, v3);
        this.body.func_228309_a_(matrixStack, iVertexBuilder, i, i1, v, v1, v2, v3);
        this.handR.func_228309_a_(matrixStack, iVertexBuilder, i, i1, v, v1, v2, v3);
        this.handL.func_228309_a_(matrixStack, iVertexBuilder, i, i1, v, v1, v2, v3);
        this.legL.func_228309_a_(matrixStack, iVertexBuilder, i, i1, v, v1, v2, v3);
        this.legR.func_228309_a_(matrixStack, iVertexBuilder, i, i1, v, v1, v2, v3);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78796_g = (float)Math.toRadians(netHeadYaw);
        this.head.field_78795_f = (float)Math.toRadians(headPitch);
        this.legR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.legL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.legR.field_78796_g = 0.0f;
        this.legL.field_78796_g = 0.0f;
        this.handR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.2f;
        this.handR.field_78796_g = 0.0f;
        this.handR.field_78808_h = 0.0f;
        this.handL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.2f;
        this.handL.field_78796_g = 0.0f;
        this.handL.field_78808_h = 0.0f;
        if (this.armPose == ArmPose.BOW_AND_ARROW) {
            this.handR.field_78796_g = -0.1f + this.head.field_78796_g;
            this.handR.field_78795_f = -1.5707964f + this.head.field_78795_f;
            this.handL.field_78795_f = -0.9424779f + this.head.field_78795_f;
            this.handL.field_78796_g = this.head.field_78796_g - 0.4f;
            this.handL.field_78808_h = 1.5707964f;
        } else if (this.armPose == ArmPose.CROSSBOW_CHARGE) {
            this.handR.field_78796_g = -0.3f + this.head.field_78796_g;
            this.handL.field_78796_g = 0.6f + this.head.field_78796_g;
            this.handR.field_78795_f = -1.5707964f + this.head.field_78795_f + 0.1f;
            this.handL.field_78795_f = -1.5f + this.head.field_78795_f;
        } else if (this.armPose == ArmPose.ATTACKING) {
            float f = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI));
            float f1 = MathHelper.func_76126_a((float)((1.0f - (1.0f - this.field_217112_c) * (1.0f - this.field_217112_c)) * (float)Math.PI));
            this.handR.field_78795_f = -0.4f;
            this.handR.field_78796_g = 0.0f;
            this.handR.field_78808_h = 0.0f;
            this.handL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.2f;
            this.handL.field_78796_g = 0.0f;
            this.handL.field_78808_h = 0.0f;
            if (entityIn.func_184591_cq() == HandSide.RIGHT) {
                this.handR.field_78795_f = -0.4f;
                this.handR.field_78796_g = 0.0f;
                this.handR.field_78808_h = 0.0f;
                this.handL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.2f;
                this.handL.field_78796_g = 0.0f;
                this.handL.field_78808_h = 0.0f;
                this.handR.field_78795_f += f * 2.2f - f1 * 0.4f;
                this.handL.field_78795_f += f * 1.2f - f1 * 0.4f;
            } else {
                this.handR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.2f;
                this.handR.field_78796_g = 0.0f;
                this.handR.field_78808_h = 0.0f;
                this.handL.field_78795_f = -0.4f;
                this.handL.field_78796_g = 0.0f;
                this.handL.field_78808_h = 0.0f;
                this.handR.field_78795_f += f * 1.2f - f1 * 0.4f;
                this.handL.field_78795_f += f * 2.2f - f1 * 0.4f;
            }
        }
        this.handR.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.handL.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.handR.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        this.handL.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public ModelRenderer func_205072_a() {
        return this.head;
    }

    public ModelRenderer getArm(HandSide handSide) {
        return handSide == HandSide.LEFT ? this.handL : this.handR;
    }

    public void func_225599_a_(HandSide handSide, MatrixStack matrixStack) {
        this.getArm(handSide).func_228307_a_(matrixStack);
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.armPose = ArmPose.EMPTY;
        ItemStack itemStack = entityIn.func_184586_b(Hand.MAIN_HAND);
        IWeaponSelector weaponSelector = WanderingTrapperEntity.weaponSelector;
        if (weaponSelector.isGun() && entityIn.func_213398_dR()) {
            this.armPose = ArmPose.CROSSBOW_CHARGE;
        } else if (itemStack.func_77973_b() instanceof BowItem && entityIn.func_213398_dR()) {
            this.armPose = ArmPose.BOW_AND_ARROW;
        } else if (entityIn.func_213398_dR()) {
            this.armPose = ArmPose.ATTACKING;
        }
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78808_h = z;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78795_f = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ArmPose {
        EMPTY,
        ATTACKING,
        BOW_AND_ARROW,
        THROW_SPEAR,
        CROSSBOW_CHARGE,
        CROSSBOW_HOLD;

    }
}

