/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.wandering_trapper.compat;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.Config;
import ewewukek.musketmod.MusketItem;
import ewewukek.musketmod.MusketMod;
import lilypuree.wandering_trapper.compat.IWeaponSelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class MusketWeapon
implements IWeaponSelector {
    @Override
    public Item getWeapon() {
        return MusketMod.MUSKET;
    }

    @Override
    public double getMoveSpeedAmp() {
        return 0.4;
    }

    @Override
    public int getAttackCooldown() {
        return 30;
    }

    @Override
    public int getWeaponLoadTime() {
        return 35;
    }

    @Override
    public float getProjectileSpeed(int loadTime) {
        return 1.0f;
    }

    @Override
    public float getMaxAttackDistance() {
        return 120.0f;
    }

    @Override
    public Entity getProjectile(LivingEntity shooter, float distanceFactor) {
        BulletEntity bullet = new BulletEntity(shooter.field_70170_p);
        bullet.func_212361_a((Entity)shooter);
        bullet.func_70107_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() - 0.1, shooter.func_226281_cx_());
        return bullet;
    }

    @Override
    public Entity shoot(Entity projectile, double dirX, double dirY, double dirZ, int difficulty) {
        if (projectile instanceof BulletEntity) {
            Vector3d front = new Vector3d(dirX, dirY, dirZ).func_72432_b();
            float angle = (float)Math.PI * 2 * projectile.field_70170_p.func_201674_k().nextFloat();
            float gaussian = Math.abs((float)projectile.field_70170_p.func_201674_k().nextGaussian());
            if (gaussian > 4.0f) {
                gaussian = 4.0f;
            }
            double stdDev = (Double)Config.INSTANCE.bulletStdDev.get() / 3.0;
            front = front.func_178789_a((float)stdDev * gaussian * MathHelper.func_76126_a((float)angle)).func_178785_b((float)stdDev * gaussian * MathHelper.func_76134_b((float)angle));
            Vector3d motion = front.func_186678_a((Double)Config.INSTANCE.bulletSpeed.get() / 10.0);
            ((BulletEntity)projectile).func_213317_d(motion);
            ((BulletEntity)projectile).doFireParticles = true;
        }
        return projectile;
    }

    @Override
    public SoundEvent getShootSound() {
        return MusketItem.SOUND_MUSKET_FIRE;
    }

    @Override
    public boolean isGun() {
        return true;
    }
}

