/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.wandering_trapper.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import lilypuree.wandering_trapper.entity.WanderingTrapperEntity;
import lilypuree.wandering_trapper.setup.Registration;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrapperDogEntity
extends WolfEntity {
    private int despawnDelay = 47999;

    public TrapperDogEntity(EntityType<? extends TrapperDogEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_98038_p = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTrapperDog() {
        return true;
    }

    protected WolfEntity createChild() {
        return (WolfEntity)((EntityType)Registration.TRAPPER_DOG.get()).func_200721_a(this.field_70170_p);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, (Goal)new FollowTrapperGoal(this));
    }

    private void handleDespawn() {
        if (this.canDespawn()) {
            int n = this.despawnDelay = this.isLeashedToTrapper() ? ((WanderingTrapperEntity)this.func_110166_bE()).getDespawnDelay() - 1 : this.despawnDelay - 1;
            if (this.despawnDelay <= 0) {
                this.func_110160_i(true, false);
                this.func_70106_y();
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.handleDespawn();
        }
    }

    private boolean canDespawn() {
        return !this.isLeashedToStranger();
    }

    private boolean isLeashedToTrapper() {
        return this.func_110166_bE() instanceof WanderingTrapperEntity;
    }

    private boolean isLeashedToStranger() {
        return this.func_110167_bD() && !this.isLeashedToTrapper();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData ilivingentitydata = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (reason == SpawnReason.EVENT) {
            this.func_70873_a(0);
        }
        return ilivingentitydata;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("DespawnDelay", this.despawnDelay);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("DespawnDelay", 99)) {
            this.despawnDelay = compound.func_74762_e("DespawnDelay");
        }
    }

    public class FollowTrapperGoal
    extends TargetGoal {
        private final WolfEntity wolfEntity;
        private LivingEntity targetEntity;
        private int revengeTime;

        public FollowTrapperGoal(WolfEntity wolfEntityIn) {
            super((MobEntity)wolfEntityIn, false);
            this.wolfEntity = wolfEntityIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean func_75250_a() {
            if (!this.wolfEntity.func_110167_bD()) {
                return false;
            }
            Entity entity = this.wolfEntity.func_110166_bE();
            if (!(entity instanceof WanderingTrapperEntity)) {
                return false;
            }
            WanderingTrapperEntity wanderingTrapperEntity = (WanderingTrapperEntity)entity;
            this.targetEntity = wanderingTrapperEntity.func_70643_av();
            int i = wanderingTrapperEntity.func_142015_aE();
            return i != this.revengeTime && this.func_220777_a(this.targetEntity, EntityPredicate.field_221016_a);
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.targetEntity);
            Entity entity = this.wolfEntity.func_110166_bE();
            if (entity instanceof WanderingTrapperEntity) {
                this.wolfEntity.func_110160_i(true, false);
                this.revengeTime = ((WanderingTrapperEntity)entity).func_142015_aE();
            }
            super.func_75249_e();
        }
    }
}

