/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.wandering_trapper.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import lilypuree.wandering_trapper.compat.IWeaponSelector;
import lilypuree.wandering_trapper.entity.TrapperTrades;
import lilypuree.wandering_trapper.entity.ai.CustomMeleeAttackGoal;
import lilypuree.wandering_trapper.entity.ai.CustomRangedAttackGoal;
import lilypuree.wandering_trapper.entity.ai.NotInvisibleTargetGoal;
import lilypuree.wandering_trapper.entity.ai.UseOffhandItemGoal;
import lilypuree.wandering_trapper.setup.Registration;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WanderingTrapperEntity
extends AbstractVillagerEntity
implements IRangedAttackMob {
    @Nullable
    private BlockPos wanderTarget;
    private int despawnDelay;
    public static IWeaponSelector weaponSelector;

    public WanderingTrapperEntity(World worldIn) {
        super((EntityType)Registration.WANDERING_TRAPPER.get(), worldIn);
    }

    public WanderingTrapperEntity(EntityType<? extends AbstractVillagerEntity> type, World world) {
        super(type, world);
        this.field_98038_p = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, new UseOffhandItemGoal<WanderingTrapperEntity>(this, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185251_w), SoundEvents.field_187664_bz, p_213733_1_ -> this.field_70170_p.field_73012_v.nextFloat() < 0.0052f && this.func_110143_aJ() < this.func_110138_aP()));
        this.field_70714_bg.func_75776_a(2, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new CustomMeleeAttackGoal((CreatureEntity)this, 0.5, true, weaponSelector));
        this.field_70714_bg.func_75776_a(3, new CustomRangedAttackGoal<WanderingTrapperEntity>(this, weaponSelector));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveToGoal(this, 2.5, 0.4));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.55));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.55));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){});
        this.field_70715_bh.func_75776_a(2, new NotInvisibleTargetGoal<AbstractIllagerEntity>((MobEntity)this, AbstractIllagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NotInvisibleTargetGoal<VexEntity>((MobEntity)this, VexEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NotInvisibleTargetGoal<ZombieEntity>((MobEntity)this, ZombieEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NotInvisibleTargetGoal<FoxEntity>((MobEntity)this, FoxEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NotInvisibleTargetGoal<PolarBearEntity>((MobEntity)this, PolarBearEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute prepareAttributes() {
        AttributeModifierMap.MutableAttribute attribute = LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 28.0).func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233826_i_, 1.2);
        attribute.func_233815_a_(Attributes.field_233823_f_, 2.0);
        return attribute;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return null;
    }

    public boolean func_213705_dZ() {
        return false;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (hand == Hand.MAIN_HAND) {
                player.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] trades = (VillagerTrades.ITrade[])TrapperTrades.trades.get(1);
        VillagerTrades.ITrade[] trades1 = (VillagerTrades.ITrade[])TrapperTrades.trades.get(2);
        if (trades != null && trades1 != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, trades, 3);
            this.func_213717_a(merchantoffers, trades1, 2);
        }
    }

    protected float func_205712_c(EquipmentSlotType slotIn) {
        return 0.3f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("DespawnDelay", this.despawnDelay);
        if (this.wanderTarget != null) {
            compound.func_218657_a("WanderTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.wanderTarget));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("DespawnDelay", 3)) {
            this.despawnDelay = compound.func_74762_e("DespawnDelay");
        }
        if (compound.func_74764_b("WanderTarget")) {
            this.wanderTarget = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("WanderTarget"));
        }
        this.func_70873_a(Math.max(0, this.func_70874_b()));
    }

    public void setDespawnDelay(int delay) {
        this.despawnDelay = delay;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void setWanderTarget(@Nullable BlockPos wanderTarget) {
        this.wanderTarget = wanderTarget;
    }

    @Nullable
    public BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    protected SoundEvent func_184639_G() {
        return this.func_213716_dX() ? SoundEvents.field_219723_nb : SoundEvents.field_219708_mT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219713_mY;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219709_mU;
    }

    protected SoundEvent func_213351_c(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151117_aB ? SoundEvents.field_219711_mW : SoundEvents.field_219712_mX;
    }

    protected SoundEvent func_213721_r(boolean getYesSound) {
        return getYesSound ? SoundEvents.field_219724_nc : SoundEvents.field_219714_mZ;
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_219724_nc;
    }

    private void handleDespawn() {
        if (this.despawnDelay > 0 && !this.func_213716_dX() && --this.despawnDelay == 0) {
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70643_av() != null) {
            this.func_70604_c(this.func_70643_av());
        }
        if (!this.field_70170_p.field_72995_K) {
            this.handleDespawn();
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        Entity projectileEntity = weaponSelector.getProjectile((LivingEntity)this, distanceFactor);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() * 0.9f) - projectileEntity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        projectileEntity = weaponSelector.shoot(projectileEntity, d0, d1, d2, this.field_70170_p.func_175659_aa().func_151525_a());
        this.func_184185_a(weaponSelector.getShootSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c(projectileEntity);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)weaponSelector.getWeapon()));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_213713_b(MerchantOffer offer) {
        if (offer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    class MoveToGoal
    extends Goal {
        final WanderingTrapperEntity trapperEntity;
        final double maxDistance;
        final double speed;

        MoveToGoal(WanderingTrapperEntity traderEntityIn, double distanceIn, double speedIn) {
            this.trapperEntity = traderEntityIn;
            this.maxDistance = distanceIn;
            this.speed = speedIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            this.trapperEntity.setWanderTarget(null);
            WanderingTrapperEntity.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.trapperEntity.getWanderTarget();
            return blockpos != null && this.isWithinDistance(blockpos, this.maxDistance);
        }

        public void func_75246_d() {
            BlockPos blockpos = this.trapperEntity.getWanderTarget();
            if (blockpos != null && WanderingTrapperEntity.this.field_70699_by.func_75500_f()) {
                if (this.isWithinDistance(blockpos, 10.0)) {
                    Vector3d vec3d = new Vector3d((double)blockpos.func_177958_n() - this.trapperEntity.func_226277_ct_(), (double)blockpos.func_177956_o() - this.trapperEntity.func_226278_cu_(), (double)blockpos.func_177952_p() - this.trapperEntity.func_226281_cx_()).func_72432_b();
                    Vector3d vec3d1 = vec3d.func_186678_a(10.0).func_72441_c(this.trapperEntity.func_226277_ct_(), this.trapperEntity.func_226278_cu_(), this.trapperEntity.func_226281_cx_());
                    WanderingTrapperEntity.this.field_70699_by.func_75492_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, this.speed);
                } else {
                    WanderingTrapperEntity.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speed);
                }
            }
        }

        private boolean isWithinDistance(BlockPos pos, double distance) {
            return !pos.func_218137_a((IPosition)this.trapperEntity.func_213303_ch(), distance);
        }
    }
}

