/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.wandering_trapper.server;

import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import lilypuree.wandering_trapper.entity.TrapperDogEntity;
import lilypuree.wandering_trapper.entity.WanderingTrapperEntity;
import lilypuree.wandering_trapper.setup.Registration;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class WanderingTrapperSpawner {
    private final Random random = new Random();
    private final ServerWorld world;
    private int field_221248_c;
    private int spawnDelay;
    private int spawnChance;

    public WanderingTrapperSpawner(ServerWorld world) {
        this.world = world;
        this.field_221248_c = 1200;
        this.spawnDelay = 24000;
        this.spawnChance = 25;
    }

    public int tick() {
        if (!this.world.func_82736_K().func_223586_b(GameRules.field_230128_E_)) {
            return 0;
        }
        if (--this.field_221248_c > 0) {
            return 0;
        }
        this.field_221248_c = 1200;
        this.spawnDelay -= 1200;
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = 24000;
        if (!this.world.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
            return 0;
        }
        int chance = this.spawnChance;
        this.spawnChance = MathHelper.func_76125_a((int)(this.spawnChance + 25), (int)25, (int)75);
        if (this.random.nextInt(100) > chance) {
            return 0;
        }
        if (this.spawnTrapper(this.world)) {
            this.spawnChance = 25;
            return 1;
        }
        return 0;
    }

    private boolean spawnTrapper(ServerWorld world) {
        ServerPlayerEntity playerentity = world.func_217472_l_();
        if (playerentity == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        BlockPos blockpos = playerentity.func_233580_cy_();
        int i = 48;
        PointOfInterestManager pointofinterestmanager = world.func_217443_B();
        Optional optional = pointofinterestmanager.func_219127_a(PointOfInterestType.field_221070_r.func_221045_c(), p_221241_0_ -> true, blockpos, 48, PointOfInterestManager.Status.ANY);
        BlockPos blockpos1 = optional.orElse(blockpos);
        BlockPos blockpos2 = this.func_221244_a((IWorldReader)world, blockpos1, 48);
        if (blockpos2 != null) {
            if (world.func_226691_t_(blockpos2).func_225486_c(blockpos2) > 0.0f) {
                return false;
            }
            WanderingTrapperEntity wanderingTrapperEntity = (WanderingTrapperEntity)((EntityType)Registration.WANDERING_TRAPPER.get()).func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, blockpos2, SpawnReason.EVENT, false, false);
            if (wanderingTrapperEntity != null) {
                this.spawnDogs(wanderingTrapperEntity, 4);
                wanderingTrapperEntity.setDespawnDelay(48000);
                wanderingTrapperEntity.setWanderTarget(blockpos1);
                wanderingTrapperEntity.func_213390_a(blockpos1, 16);
                return true;
            }
        }
        return false;
    }

    private void spawnDogs(WanderingTrapperEntity trapper, int radius) {
        TrapperDogEntity trapperDogEntity;
        BlockPos blockpos = this.func_221244_a((IWorldReader)trapper.func_190670_t_(), new BlockPos((Vector3i)trapper.func_233580_cy_()), radius);
        if (blockpos != null && (trapperDogEntity = (TrapperDogEntity)((EntityType)Registration.TRAPPER_DOG.get()).func_220342_a((ServerWorld)trapper.func_190670_t_(), (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, blockpos, SpawnReason.EVENT, false, false)) != null) {
            trapperDogEntity.func_110162_b((Entity)trapper, true);
            trapperDogEntity.func_184754_b(trapper.func_110124_au());
        }
    }

    @Nullable
    private BlockPos func_221244_a(IWorldReader world, BlockPos pos, int radius) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.func_177958_n() + this.random.nextInt(radius * 2) - radius;
            BlockPos blockpos1 = new BlockPos(j, l = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, j, k = pos.func_177952_p() + this.random.nextInt(radius * 2) - radius), k);
            if (!WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (IWorldReader)world, (BlockPos)blockpos1, (EntityType)((EntityType)Registration.WANDERING_TRAPPER.get()))) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean func_234560_a_(IBlockReader world, BlockPos pos) {
        BlockPos pos1;
        Iterator var3 = BlockPos.func_218278_a((BlockPos)pos, (BlockPos)pos.func_177982_a(1, 2, 1)).iterator();
        do {
            if (var3.hasNext()) continue;
            return true;
        } while (world.func_180495_p(pos1 = (BlockPos)var3.next()).func_196952_d(world, pos1).func_197766_b());
        return false;
    }
}

