/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.wandering_trapper.setup;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import lilypuree.wandering_trapper.capability.HuntingExperience;
import lilypuree.wandering_trapper.capability.HuntingExperienceProvider;
import lilypuree.wandering_trapper.capability.HuntingExperienceStorage;
import lilypuree.wandering_trapper.capability.IHuntingExperience;
import lilypuree.wandering_trapper.entity.TrapperDogEntity;
import lilypuree.wandering_trapper.entity.WanderingTrapperEntity;
import lilypuree.wandering_trapper.server.WanderingTrapperSpawner;
import lilypuree.wandering_trapper.setup.Registration;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

@Mod.EventBusSubscriber(modid="wandering_trapper", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModSetup {
    @CapabilityInject(value=IHuntingExperience.class)
    public static final Capability<IHuntingExperience> HUNTING_EXP_CAP = null;
    @Nullable
    private static WanderingTrapperSpawner wanderingTrapperSpawner = null;

    public void init(FMLCommonSetupEvent e) {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)Registration.WANDERING_TRAPPER.get()), (AttributeModifierMap)WanderingTrapperEntity.prepareAttributes().func_233813_a_());
        CapabilityManager.INSTANCE.register(IHuntingExperience.class, (Capability.IStorage)new HuntingExperienceStorage(), HuntingExperience::new);
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)Registration.TRAPPER_DOG.get()), (AttributeModifierMap)TrapperDogEntity.func_234233_eS_().func_233813_a_());
    }

    @SubscribeEvent
    public static void onServerSetUp(FMLServerStartingEvent event) {
        ServerWorld world = event.getServer().func_241755_D_();
        wanderingTrapperSpawner = new WanderingTrapperSpawner(world);
    }

    @SubscribeEvent
    public static void onAttatchCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("wandering_trapper", "hunting_experience"), (ICapabilityProvider)new HuntingExperienceProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        LazyOptional oldHuntingExperience = event.getOriginal().getCapability(HUNTING_EXP_CAP);
        oldHuntingExperience.ifPresent(oldXP -> {
            LazyOptional newhuntingExperience = event.getPlayer().getCapability(HUNTING_EXP_CAP);
            newhuntingExperience.ifPresent(newXP -> newXP.copyFrom((IHuntingExperience)oldXP));
        });
    }

    @SubscribeEvent
    public static void onSetVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == Registration.FURRIER.get()) {
            ArrayList<BasicTrade> noviceTrades = new ArrayList<BasicTrade>();
            ArrayList<BasicTrade> apprenticeTrades = new ArrayList<BasicTrade>();
            ArrayList<BasicTrade> journeymanTrades = new ArrayList<BasicTrade>();
            ArrayList<BasicTrade> expertTrades = new ArrayList<BasicTrade>();
            noviceTrades.add(new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 3), new ItemStack((IItemProvider)Registration.POLARBEAR_PELT.get(), 1), new ItemStack((IItemProvider)Items.field_151116_aA, 5), 12, 10, 0.05f));
            noviceTrades.add(new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 3), new ItemStack((IItemProvider)Registration.BEAVER_PELT.get(), 3), new ItemStack((IItemProvider)Items.field_151116_aA, 1), 16, 10, 0.05f));
            apprenticeTrades.add(new BasicTrade(new ItemStack((IItemProvider)Registration.BEAVER_PELT.get(), 10), new ItemStack((IItemProvider)Items.field_151166_bC, 50), 5, 10, 0.05f));
            apprenticeTrades.add(new BasicTrade(new ItemStack((IItemProvider)Registration.MARTEN_PELT.get(), 15), new ItemStack((IItemProvider)Items.field_151166_bC, 56), 5, 10, 0.05f));
            journeymanTrades.add(new BasicTrade(new ItemStack((IItemProvider)Registration.FOX_PELT.get(), 6), new ItemStack((IItemProvider)Items.field_151166_bC, 60), 5, 10, 0.05f));
            journeymanTrades.add(new BasicTrade(new ItemStack((IItemProvider)Registration.SNOW_FOX_PELT.get(), 3), new ItemStack((IItemProvider)Items.field_151166_bC, 64), 5, 10, 0.05f));
            journeymanTrades.add(new BasicTrade(new ItemStack((IItemProvider)Registration.POLARBEAR_PELT.get(), 1), new ItemStack((IItemProvider)Items.field_151166_bC, 32), 5, 10, 0.05f));
            expertTrades.add(new BasicTrade(new ItemStack((IItemProvider)Registration.MINK_PELT.get(), 6), new ItemStack((IItemProvider)Items.field_151166_bC, 64), 5, 10, 0.05f));
            event.getTrades().put(1, noviceTrades);
            event.getTrades().put(2, apprenticeTrades);
            event.getTrades().put(3, journeymanTrades);
            event.getTrades().put(4, expertTrades);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (wanderingTrapperSpawner != null) {
            wanderingTrapperSpawner.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void onLivingDrop(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Entity killer = event.getSource().func_76346_g();
        Random random = new Random();
        float baseDropChance = 0.001f;
        if (!(killer instanceof PlayerEntity)) {
            return;
        }
        if (entity instanceof PolarBearEntity) {
            killer.getCapability(HUNTING_EXP_CAP).ifPresent(experience -> {
                experience.add(5);
                if ((double)0.001f + MathHelper.func_151237_a((double)((float)experience.getExperience() * 0.001f), (double)0.0, (double)0.1) > (double)random.nextFloat()) {
                    entity.func_199701_a_(new ItemStack((IItemProvider)Registration.POLARBEAR_PELT.get()));
                }
            });
        } else if (entity instanceof FoxEntity) {
            if (((FoxEntity)entity).func_213471_dV() == FoxEntity.Type.RED) {
                killer.getCapability(HUNTING_EXP_CAP).ifPresent(experience -> {
                    experience.add(2);
                    if ((double)0.001f + MathHelper.func_151237_a((double)((float)experience.getExperience() * 0.001f), (double)0.0, (double)0.1) > (double)random.nextFloat()) {
                        entity.func_199701_a_(new ItemStack((IItemProvider)Registration.FOX_PELT.get()));
                    }
                });
            } else {
                killer.getCapability(HUNTING_EXP_CAP).ifPresent(experience -> {
                    experience.add(4);
                    if ((double)0.001f + MathHelper.func_151237_a((double)((float)experience.getExperience() * 0.001f), (double)0.0, (double)0.1) > (double)random.nextFloat()) {
                        entity.func_199701_a_(new ItemStack((IItemProvider)Registration.SNOW_FOX_PELT.get()));
                    }
                });
            }
        }
    }
}

