/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.spawn;

import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.settings.Spawns;
import com.earth2me.essentials.storage.AsyncStorageObjectHolder;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.ess3.api.IEssentials;
import org.bukkit.Location;
import org.bukkit.World;

public class SpawnStorage
extends AsyncStorageObjectHolder<Spawns>
implements IEssentialsModule {
    SpawnStorage(IEssentials ess) {
        super(ess, Spawns.class);
        this.reloadConfig();
    }

    public File getStorageFile() {
        return new File(this.ess.getDataFolder(), "spawn.yml");
    }

    public void finishRead() {
    }

    public void finishWrite() {
    }

    void setSpawn(Location loc, String group) {
        this.acquireWriteLock();
        try {
            if (((Spawns)this.getData()).getSpawns() == null) {
                ((Spawns)this.getData()).setSpawns(new HashMap());
            }
            ((Spawns)this.getData()).getSpawns().put(group.toLowerCase(Locale.ENGLISH), loc);
        }
        finally {
            this.unlock();
        }
        if ("default".equalsIgnoreCase(group)) {
            loc.getWorld().setSpawnLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Location getSpawn(String group) {
        this.acquireReadLock();
        try {
            String groupName;
            if (((Spawns)this.getData()).getSpawns() == null || group == null) {
                Location location = this.getWorldSpawn();
                return location;
            }
            Map spawnMap = ((Spawns)this.getData()).getSpawns();
            if (!spawnMap.containsKey(groupName = group.toLowerCase(Locale.ENGLISH))) {
                groupName = "default";
            }
            if (!spawnMap.containsKey(groupName)) {
                Location location = this.getWorldSpawn();
                return location;
            }
            Location location = (Location)spawnMap.get(groupName);
            return location;
        }
        finally {
            this.unlock();
        }
    }

    private Location getWorldSpawn() {
        for (World world : this.ess.getServer().getWorlds()) {
            if (world.getEnvironment() != World.Environment.NORMAL) continue;
            return world.getSpawnLocation();
        }
        return ((World)this.ess.getServer().getWorlds().get(0)).getSpawnLocation();
    }
}

