/*
 * Decompiled with CFR 0.152.
 */
package com.Rolfmao.upgradednetherite.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.MOD)
public class UpgradedNetheriteConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ArmorOptions ARMOR_OPTIONS = new ArmorOptions(BUILDER);
    public static ForgeConfigSpec spec = BUILDER.build();

    public static class Helper {
        private static final FileConfig CONFIG_FILE = FileConfig.of((File)new File(FMLPaths.CONFIGDIR.get().toFile(), "upgradednetherite-common.toml"));

        public static <T> T get(String category, String subCategory, String value) {
            return Helper.get(category + "." + subCategory, value);
        }

        public static <T> T get(String category, String value) {
            CONFIG_FILE.load();
            return (T)CONFIG_FILE.get(category + "." + value);
        }

        public static String getSubConfig(String category, String subCategory) {
            return category + "." + subCategory;
        }
    }

    public static class ArmorOptions {
        public ForgeConfigSpec.BooleanValue DisableTooltips;
        public ForgeConfigSpec.IntValue UpgradedPlayerGoldArmorRequireSet;
        public ForgeConfigSpec.IntValue UpgradedPlayerFireArmorRequireSet;
        public ForgeConfigSpec.IntValue UpgradedPlayerEnderArmorRequireSet;
        public ForgeConfigSpec.IntValue UpgradedPlayerWaterArmorRequireSet;
        public ForgeConfigSpec.IntValue UpgradedPlayerWitherArmorRequireSet;
        public ForgeConfigSpec.IntValue UpgradedPlayerPoisonArmorRequireSet;
        public ForgeConfigSpec.IntValue UpgradedPlayerPhantomArmorRequireSet;
        public ForgeConfigSpec.IntValue UpgradedPlayerFeatherArmorRequireSet;
        public ForgeConfigSpec.IntValue UpgradedPlayerUltimateArmorRequireSet;
        public ForgeConfigSpec.BooleanValue EnableFireImmune;
        public ForgeConfigSpec.BooleanValue EnableBreakEnderArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityFireArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityFireArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityFireArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityWaterArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityWaterArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityWaterArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityWitherArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityWitherArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityWitherArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityPoisonArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityPoisonArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityPoisonArmor;
        public ForgeConfigSpec.BooleanValue EnableDamageDurabilityPhantomArmor;
        public ForgeConfigSpec.IntValue MultiplierDamageDurabilityPhantomArmor;
        public ForgeConfigSpec.BooleanValue EnableWaterDamageDurabilityFeatherArmor;
        public ForgeConfigSpec.BooleanValue EnableLavaDamageDurabilityFeatherArmor;
        public ForgeConfigSpec.BooleanValue EnableFallDamageDurabilityFeatherArmor;
        public ForgeConfigSpec.IntValue DelayDamageDurabilityFeatherArmor;
        public ForgeConfigSpec.IntValue DamageDurabilityFeatherArmor;
        public ForgeConfigSpec.BooleanValue EnableAutoSmeltFortune;
        public ForgeConfigSpec.BooleanValue EnableUltimateGoldArmorEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateFireArmorEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateEnderArmorEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateWaterArmorEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateWitherArmorEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimatePoisonArmorEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimatePhantomArmorEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateFeatherArmorEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateFlying;
        public ForgeConfigSpec.BooleanValue EnableUltimateNoDamage;
        public ForgeConfigSpec.BooleanValue EnableUltimateUnbreakable;
        public ForgeConfigSpec.BooleanValue EnableUltimateGoldToolEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateFireToolEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateEnderToolEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateWaterToolEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateWitherToolEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimatePoisonToolEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimatePhantomToolEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateFeatherToolEffect;
        public ForgeConfigSpec.BooleanValue EnableUltimateInstaKill;

        ArmorOptions(ForgeConfigSpec.Builder builder) {
            builder.push("General Options");
            this.DisableTooltips = builder.comment("Disable Tooltips ?(Client Only)").define("DisableTooltips", false);
            builder.pop();
            builder.push("Armor Options");
            this.UpgradedPlayerGoldArmorRequireSet = builder.comment("How many pieces of Gold Upgraded armor are needed to activate the effects?").defineInRange("UpgradedPlayerGoldArmorRequireSet", 4, 1, 4);
            this.UpgradedPlayerFireArmorRequireSet = builder.comment("How many pieces of Fire Upgraded armor are needed to activate the effects?").defineInRange("UpgradedPlayerFireArmorRequireSet", 4, 1, 4);
            this.UpgradedPlayerEnderArmorRequireSet = builder.comment("How many pieces of Ender Upgraded armor are needed to activate the effects?").defineInRange("UpgradedPlayerEnderArmorRequireSet", 4, 1, 4);
            this.UpgradedPlayerWaterArmorRequireSet = builder.comment("How many pieces of Water Upgraded armor are needed to activate the effects?").defineInRange("UpgradedPlayerWaterArmorRequireSet", 4, 1, 4);
            this.UpgradedPlayerWitherArmorRequireSet = builder.comment("How many pieces of Wither Upgraded armor are needed to activate the effects?").defineInRange("UpgradedPlayerWitherArmorRequireSet", 4, 1, 4);
            this.UpgradedPlayerPoisonArmorRequireSet = builder.comment("How many pieces of Poison Upgraded armor are needed to activate the effects?").defineInRange("UpgradedPlayerPoisonArmorRequireSet", 4, 1, 4);
            this.UpgradedPlayerPhantomArmorRequireSet = builder.comment("How many pieces of Phantom Upgraded armor are needed to activate the effects?").defineInRange("UpgradedPlayerPhantomArmorRequireSet", 4, 1, 4);
            this.UpgradedPlayerFeatherArmorRequireSet = builder.comment("How many pieces of Feather Upgraded armor are needed to activate the effects?").defineInRange("UpgradedPlayerFeatherArmorRequireSet", 4, 1, 4);
            this.UpgradedPlayerUltimateArmorRequireSet = builder.comment("How many pieces of Ultimate Upgraded armor are needed to activate the effects?").defineInRange("UpgradedPlayerUltimateArmorRequireSet", 4, 1, 4);
            builder.pop();
            builder.push("Fire Armor Effect Options");
            this.EnableFireImmune = builder.comment("Enable Fire Upgraded Armor Effect : Fire damage immune. ?").define("EnableFireImmune", true);
            this.EnableDamageDurabilityFireArmor = builder.comment("Fire Upgraded Armor loose durability when protect the player ? (Require EnableFireImmune = True)").define("EnableDamageDurabilityFireArmor", false);
            this.DelayDamageDurabilityFireArmor = builder.comment("How many tick between durability damage for the Fire Upgraded Armor when it protect the player ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityFireArmor", 20, 1, 1000);
            this.DamageDurabilityFireArmor = builder.comment("How many durability damage take the Fire Upgraded Armor when protect the player ? ").defineInRange("DamageDurabilityFireArmor", 1, 1, 100);
            builder.pop();
            builder.push("Ender Armor Effect Options");
            this.EnableBreakEnderArmor = builder.comment("Ender Upgraded Armor Break when save the player ? ").define("EnableBreakEnderArmor", false);
            builder.pop();
            builder.push("Water Armor Effect Options");
            this.EnableDamageDurabilityWaterArmor = builder.comment("Water Upgraded Armor loose durability when protect the player ? ").define("EnableDamageDurabilityWaterArmor", false);
            this.DelayDamageDurabilityWaterArmor = builder.comment("How many tick between durability damage for the Water Upgraded Armor when it protect the player ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityWaterArmor", 20, 1, 1000);
            this.DamageDurabilityWaterArmor = builder.comment("How many durability damage take the Water Upgraded Armor when protect the player ? ").defineInRange("DamageDurabilityWaterArmor", 1, 1, 100);
            builder.pop();
            builder.push("Wither Armor Effect Options");
            this.EnableDamageDurabilityWitherArmor = builder.comment("Wither Upgraded Armor loose durability when protect the player ? ").define("EnableDamageDurabilityWitherArmor", false);
            this.DelayDamageDurabilityWitherArmor = builder.comment("How many tick between durability damage for the Wither Upgraded Armor when it protect the player ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityWitherArmor", 20, 1, 1000);
            this.DamageDurabilityWitherArmor = builder.comment("How many durability damage take the Wither Upgraded Armor when protect the player ? ").defineInRange("DamageDurabilityWitherArmor", 5, 1, 100);
            builder.pop();
            builder.push("Poison Armor Effect Options");
            this.EnableDamageDurabilityPoisonArmor = builder.comment("Poison Upgraded Armor loose durability when protect the player ? ").define("EnableDamageDurabilityPoisonArmor", false);
            this.DelayDamageDurabilityPoisonArmor = builder.comment("How many tick between durability damage for the Poison Upgraded Armor when it protect the player ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityPoisonArmor", 20, 1, 1000);
            this.DamageDurabilityPoisonArmor = builder.comment("How many durability damage take the Poison Upgraded Armor when protect the player ? ").defineInRange("DamageDurabilityPoisonArmor", 5, 1, 100);
            builder.pop();
            builder.push("Phantom Armor Effect Options");
            this.EnableDamageDurabilityPhantomArmor = builder.comment("Phantom Upgraded Armor loose durability when protect the player ? (Depend on fall distance)").define("EnableDamageDurabilityPhantomArmor", false);
            this.MultiplierDamageDurabilityPhantomArmor = builder.comment("How many durability damage take the Phantom Upgraded Armor when protect the player ? (Fall distance * Value)").defineInRange("MultiplierDamageDurabilityPhantomArmor", 1, 1, 100);
            builder.pop();
            builder.push("Feather Armor Effect Options");
            this.EnableWaterDamageDurabilityFeatherArmor = builder.comment("Feather Upgraded Armor loose durability when the player walk on water ? ").define("EnableWaterDamageDurabilityFeatherArmor", false);
            this.EnableLavaDamageDurabilityFeatherArmor = builder.comment("Feather Upgraded Armor loose durability when the player walk on lava ? ").define("EnableLavaDamageDurabilityFeatherArmor", false);
            this.EnableFallDamageDurabilityFeatherArmor = builder.comment("Feather Upgraded Armor loose durability when reducing fall damage ? ").define("EnableFallDamageDurabilityFeatherArmor", false);
            this.DelayDamageDurabilityFeatherArmor = builder.comment("How many tick between durability damage for the Feather Upgraded Armor when the player walk on water/lava or slow falling ? (20ticks = 1sec)").defineInRange("DelayDamageDurabilityFeatherArmor", 20, 1, 1000);
            this.DamageDurabilityFeatherArmor = builder.comment("How many durability damage take the Feather Upgraded Armor when the player walk on water/lava or slow falling ? ").defineInRange("DamageDurabilityFeatherArmor", 1, 1, 100);
            builder.pop();
            builder.push("Ultimate Armor Effect Options");
            this.EnableUltimateGoldArmorEffect = builder.comment("Ultimate Upgraded Armor have Gold Upgraded Netherite Effect ?").define("EnableUltimateGoldArmorEffect", true);
            this.EnableUltimateFireArmorEffect = builder.comment("Ultimate Upgraded Armor have Fire Upgraded Netherite Effect ?").define("EnableUltimateFireArmorEffect", true);
            this.EnableUltimateEnderArmorEffect = builder.comment("Ultimate Upgraded Armor have Ender Upgraded Netherite Effect ?").define("EnableUltimateEnderArmorEffect", true);
            this.EnableUltimateWaterArmorEffect = builder.comment("Ultimate Upgraded Armor have Water Upgraded Netherite Effect ?").define("EnableUltimateWaterArmorEffect", true);
            this.EnableUltimateWitherArmorEffect = builder.comment("Ultimate Upgraded Armor have Wither Upgraded Netherite Effect ?").define("EnableUltimateWitherArmorEffect", true);
            this.EnableUltimatePoisonArmorEffect = builder.comment("Ultimate Upgraded Armor have Poison Upgraded Netherite Effect ?").define("EnableUltimatePoisonArmorEffect", true);
            this.EnableUltimatePhantomArmorEffect = builder.comment("Ultimate Upgraded Armor have Phantom Upgraded Netherite Effect ?").define("EnableUltimatePhantomArmorEffect", true);
            this.EnableUltimateFeatherArmorEffect = builder.comment("Ultimate Upgraded Armor have Feather Upgraded Netherite Effect ?").define("EnableUltimateFeatherArmorEffect", true);
            this.EnableUltimateFlying = builder.comment("Ultimate Upgraded Armor allow you to fly ?").define("EnableUltimateFlying", false);
            this.EnableUltimateNoDamage = builder.comment("Ultimate Upgraded Armor remove all damage ? (Excludes Void Damage)").define("EnableUltimateNoDamage", false);
            this.EnableUltimateUnbreakable = builder.comment("Ultimate Upgraded Armor, Tool and Weapon don't loose durability ?").define("EnableUltimateUnbreakable", false);
            builder.pop();
            builder.push("Tool Options");
            this.EnableAutoSmeltFortune = builder.comment("Auto-Smelt is affected by Fortune ? (Only Ingot & Charcoal)").define("EnableAutoSmeltFortune", false);
            builder.pop();
            builder.push("Ultimate Tool&Weapon Effect Options");
            this.EnableUltimateGoldToolEffect = builder.comment("Ultimate Upgraded Tool and Weapon have Gold Upgraded Netherite Effect ?").define("EnableUltimateGoldToolEffect", true);
            this.EnableUltimateFireToolEffect = builder.comment("Ultimate Upgraded Tool and Weapon have Fire Upgraded Netherite Effect ?").define("EnableUltimateFireToolEffect", true);
            this.EnableUltimateEnderToolEffect = builder.comment("Ultimate Upgraded Tool and Weapon have Ender Upgraded Netherite Effect ?").define("EnableUltimateEnderToolEffect", true);
            this.EnableUltimateWaterToolEffect = builder.comment("Ultimate Upgraded Tool and Weapon have Water Upgraded Netherite Effect ?").define("EnableUltimateWaterToolEffect", true);
            this.EnableUltimateWitherToolEffect = builder.comment("Ultimate Upgraded Tool and Weapon have Wither Upgraded Netherite Effect ?").define("EnableUltimateWitherToolEffect", true);
            this.EnableUltimatePoisonToolEffect = builder.comment("Ultimate Upgraded Tool and Weapon have Poison Upgraded Netherite Effect ?").define("EnableUltimatePoisonToolEffect", true);
            this.EnableUltimatePhantomToolEffect = builder.comment("Ultimate Upgraded Tool and Weapon have Phantom Upgraded Netherite Effect ?").define("EnableUltimatePhantomToolEffect", true);
            this.EnableUltimateFeatherToolEffect = builder.comment("Ultimate Upgraded Tool and Weapon have Feather Upgraded Netherite Effect ?").define("EnableUltimateFeatherToolEffect", true);
            this.EnableUltimateInstaKill = builder.comment("Ultimate Upgraded Weapon insta kill target ?").define("EnableUltimateIntaKill", false);
            builder.pop();
        }
    }
}

