/*
 * Decompiled with CFR 0.152.
 */
package com.Rolfmao.upgradednetherite.content;

import com.Rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.Rolfmao.upgradednetherite.config.UpgradedNetheriteServerConfig;
import com.Rolfmao.upgradednetherite.utils.StuffChecker;
import com.Rolfmao.upgradednetherite.utils.enums.ModArmorMaterial;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UpgradedNetheriteArmor
extends ArmorItem {
    public UpgradedNetheriteArmor(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
    }

    public boolean isDamageable(ItemStack stack) {
        if (((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateUnbreakable.get()).booleanValue() && ((ArmorItem)this.getItem()).func_200880_d() == ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE) {
            return false;
        }
        return this.getItem().func_77645_m();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (((ArmorItem)stack.func_77973_b()).func_200880_d() == ModArmorMaterial.CORRUPT_UPGRADED_NETHERITE && enchantment == Enchantments.field_185296_A) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return StuffChecker.isWearingGoldArmor((PlayerEntity)wearer);
    }

    public boolean isEnderMask(ItemStack stack, PlayerEntity player, EndermanEntity endermanEntity) {
        return StuffChecker.isWearingEnderArmor(player);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (StuffChecker.isWearingWitherArmor(player) && player.func_70644_a(Effects.field_82731_v)) {
            player.func_195063_d(Effects.field_82731_v);
            StuffChecker.WitherDurabilityLoss(player);
        }
        if (StuffChecker.isWearingPoisonArmor(player) && player.func_70644_a(Effects.field_76436_u)) {
            player.func_195063_d(Effects.field_76436_u);
            StuffChecker.PoisonDurabilityLoss(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.DisableTooltips.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
            Item armor = stack.func_77973_b();
            if (Screen.func_231173_s_()) {
                ArmorItem stuff = (ArmorItem)stack.func_77973_b();
                if (stuff.func_200880_d() == ModArmorMaterial.GOLD_UPGRADED_NETHERITE) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonus" + StuffChecker.CheckGoldSet() + ".TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Gold_Bonus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Gold_Bonus2.TT"));
                }
                if (stuff.func_200880_d() == ModArmorMaterial.FIRE_UPGRADED_NETHERITE) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonus" + StuffChecker.CheckFireSet() + ".TT"));
                    if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend && UpgradedNetheriteServerConfig.ServerEnableFireImmune) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Fire_Bonus.TT"));
                    } else if (!UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend && ((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableFireImmune.get()).booleanValue()) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Fire_Bonus.TT"));
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Fire_Bonus2.TT"));
                }
                if (stuff.func_200880_d() == ModArmorMaterial.ENDER_UPGRADED_NETHERITE) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonus" + StuffChecker.CheckEnderSet() + ".TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Bonus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Bonus2.TT"));
                    if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend && UpgradedNetheriteServerConfig.ServerEnableBreakEnderArmor) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Bonus3.TT"));
                    } else if (!UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend && ((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableBreakEnderArmor.get()).booleanValue()) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ender_Bonus3.TT"));
                    }
                }
                if (stuff.func_200880_d() == ModArmorMaterial.WATER_UPGRADED_NETHERITE) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonus" + StuffChecker.CheckWaterSet() + ".TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Water_Bonus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Water_Bonus2.TT"));
                }
                if (stuff.func_200880_d() == ModArmorMaterial.WITHER_UPGRADED_NETHERITE) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonus" + StuffChecker.CheckWitherSet() + ".TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Wither_Bonus.TT"));
                }
                if (stuff.func_200880_d() == ModArmorMaterial.POISON_UPGRADED_NETHERITE) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonus" + StuffChecker.CheckPoisonSet() + ".TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Poison_Bonus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Poison_Bonus2.TT"));
                }
                if (stuff.func_200880_d() == ModArmorMaterial.PHANTOM_UPGRADED_NETHERITE) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonus" + StuffChecker.CheckPhantomSet() + ".TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Phantom_Bonus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Phantom_Bonus2.TT"));
                }
                if (stuff.func_200880_d() == ModArmorMaterial.FEATHER_UPGRADED_NETHERITE) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonus" + StuffChecker.CheckFeatherSet() + ".TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Feather_Bonus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Feather_Bonus2.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Feather_Bonus3.TT"));
                }
                if (stuff.func_200880_d() == ModArmorMaterial.CORRUPT_UPGRADED_NETHERITE) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Malus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Corrupt_Bonus.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Corrupt_Bonus2.TT"));
                    tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Corrupt_Enchant.TT"));
                }
                if (stuff.func_200880_d() == ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE) {
                    if (StuffChecker.CheckUltimateFlyingEffect().booleanValue() || StuffChecker.CheckUltimateNoDamageEffect().booleanValue()) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonus" + StuffChecker.CheckUltimateSet() + ".TT"));
                        if (StuffChecker.CheckUltimateFlyingEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ultimate_Bonus.TT"));
                        }
                        if (StuffChecker.CheckUltimateNoDamageEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Ultimate_Bonus2.TT"));
                        }
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blank.TT"));
                    }
                    if (StuffChecker.CheckUltimateGoldArmorEffect().booleanValue() || StuffChecker.CheckUltimateFireArmorEffect().booleanValue() || StuffChecker.CheckUltimateEnderArmorEffect().booleanValue() || StuffChecker.CheckUltimateWaterArmorEffect().booleanValue() || StuffChecker.CheckUltimateWitherArmorEffect().booleanValue() || StuffChecker.CheckUltimatePoisonArmorEffect().booleanValue() || StuffChecker.CheckUltimatePhantomArmorEffect().booleanValue() || StuffChecker.CheckUltimateFeatherArmorEffect().booleanValue()) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.SetBonusFrom.TT"));
                        if (StuffChecker.CheckUltimateGoldArmorEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Golderite.TT"));
                        }
                        if (StuffChecker.CheckUltimateFireArmorEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Blazerite.TT"));
                        }
                        if (StuffChecker.CheckUltimateEnderArmorEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Enderite.TT"));
                        }
                        if (StuffChecker.CheckUltimateWaterArmorEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Prismarite.TT"));
                        }
                        if (StuffChecker.CheckUltimateWitherArmorEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Witherite.TT"));
                        }
                        if (StuffChecker.CheckUltimatePoisonArmorEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Spiderite.TT"));
                        }
                        if (StuffChecker.CheckUltimatePhantomArmorEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Phanterite.TT"));
                        }
                        if (StuffChecker.CheckUltimateFeatherArmorEffect().booleanValue()) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.Featherite.TT"));
                        }
                    }
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("upgradednetherite.HoldShift.TT"));
            }
        }
    }
}

