/*
 * Decompiled with CFR 0.152.
 */
package com.Rolfmao.upgradednetherite.handlers;

import com.Rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.Rolfmao.upgradednetherite.content.UpgradedNetheriteShield;
import com.Rolfmao.upgradednetherite.handlers.EntityFallDistanceUpdateHandler;
import com.Rolfmao.upgradednetherite.handlers.PlayerFallDistanceUpdateHandler;
import com.Rolfmao.upgradednetherite.init.ModItems;
import com.Rolfmao.upgradednetherite.init.UpgradedNetheriteEffects;
import com.Rolfmao.upgradednetherite.utils.ReachEntity;
import com.Rolfmao.upgradednetherite.utils.StuffChecker;
import com.Rolfmao.upgradednetherite.utils.enums.ModArmorMaterial;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    private Multimap<Attribute, AttributeModifier> SwimAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(UUID.fromString("fbfd69fe-3369-11eb-adc1-0242ac120002"), "upgradednetherite:swim_bonus", 1.1, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    private Multimap<Attribute, AttributeModifier> SwimHorseAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(UUID.fromString("fbfd69fe-3369-11eb-adc1-0242ac120002"), "upgradednetherite:swim_bonus", 1.5, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    private Multimap<Attribute, AttributeModifier> ReachAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(UUID.fromString("ca095c88-32c8-11eb-adc1-0242ac120002"), "upgradednetherite:reach_bonus", 2.0, AttributeModifier.Operation.ADDITION));
        return attributesDefault;
    }

    private Multimap<Attribute, AttributeModifier> HealthAttributeMap(Integer mult) {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(UUID.fromString("7d87fb9e-d0ca-4bdd-8d00-384044b3417b"), "upgradednetherite:health_malus", -0.1 * (double)mult.intValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        return attributesDefault;
    }

    private Multimap<Attribute, AttributeModifier> LuckAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)Attributes.field_233828_k_, (Object)new AttributeModifier(UUID.fromString("33ca3756-9ea8-41d0-898c-d93352065fbb"), "upgradednetherite:luck_bonus", 2.0, AttributeModifier.Operation.ADDITION));
        return attributesDefault;
    }

    @SubscribeEvent
    public void onUnmount(EntityMountEvent event) {
        HorseEntity horse;
        if (event.isDismounting() && event.getEntity() instanceof PlayerEntity && !event.getEntity().func_226274_bn_() && event.getEntity().func_184187_bx() instanceof HorseEntity && (horse = (HorseEntity)event.getEntity().func_184187_bx()).func_110248_bS() && horse.func_208600_a((ITag)FluidTags.field_206959_a) && StuffChecker.isHorseWearing(horse, (Item)ModItems.WATER_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        PlayerEntity player = event.getPlayer();
        if (StuffChecker.isUsingPhantomTool(player) && !(player instanceof ServerPlayerEntity)) {
            ReachEntity.handleExtendedReach(player);
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onLooting(LootingLevelEvent event) {
        if (event.getDamageSource() != null && event.getDamageSource().func_76346_g() instanceof ServerPlayerEntity) {
            HorseEntity horse;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getDamageSource().func_76346_g();
            ItemStack heldItem = player.func_184614_ca();
            if (event.getDamageSource().func_76364_f() instanceof ArrowEntity || event.getDamageSource().func_76364_f() instanceof SpectralArrowEntity) {
                if (event.getDamageSource().func_76364_f().func_184216_O().contains("GoldUpgradedNetheriteBow")) {
                    int EnchantBonus = event.getDamageSource().func_76364_f().getPersistentData().func_74762_e("LootingGoldUpgradedNetheriteBow");
                    if ((float)EnchantBonus >= 3.0f) {
                        event.setLootingLevel(event.getLootingLevel() + 2);
                    } else {
                        event.setLootingLevel(event.getLootingLevel() + 1);
                    }
                }
                if (event.getDamageSource().func_76364_f().func_184216_O().contains("CorruptUpgradedNetheriteBow")) {
                    event.setLootingLevel(event.getLootingLevel() + event.getDamageSource().func_76364_f().getPersistentData().func_74762_e("LootingCorruptUpgradedNetheriteBow") * 2);
                }
            } else if (StuffChecker.isUsingGoldWeapon((PlayerEntity)player)) {
                float EnchantBonus = 0.0f;
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)heldItem);
                if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.field_185304_p)) {
                    int EnchantLevel = (Integer)enchantments.get(Enchantments.field_185304_p);
                    EnchantBonus = EnchantLevel;
                }
                if (EnchantBonus >= 3.0f) {
                    event.setLootingLevel(event.getLootingLevel() + 2);
                } else {
                    event.setLootingLevel(event.getLootingLevel() + 1);
                }
            } else if (StuffChecker.isUsingCorruptWeapon((PlayerEntity)player)) {
                event.setLootingLevel(event.getLootingLevel() + StuffChecker.intWearingCorrupt((PlayerEntity)player) * 2);
            }
            if (player.func_184187_bx() instanceof HorseEntity && StuffChecker.isHorseWearing(horse = (HorseEntity)player.func_184187_bx().getEntity(), (Item)ModItems.GOLD_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                event.setLootingLevel(event.getLootingLevel() + 1);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        Entity target = event.getTarget();
        ItemStack heldItem = player.func_184614_ca();
        if (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_PEARL.get())) && !player.func_184811_cZ().func_185141_a((Item)ModItems.ENDER_UPGRADED_NETHERITE_PEARL.get()) && target instanceof LivingEntity && !(target instanceof PlayerEntity) && !(target instanceof WitherEntity) && !(target instanceof EnderDragonEntity)) {
            heldItem.func_196082_o().func_74768_a("EnderUpgradedNetheritePearlTarget", target.getEntity().func_145782_y());
            heldItem.func_196082_o().func_74778_a("EnderUpgradedNetheritePearlTargetName", player.field_70170_p.func_73045_a(target.getEntity().func_145782_y()).func_200200_C_().getString());
            player.func_184811_cZ().func_185145_a((Item)ModItems.ENDER_UPGRADED_NETHERITE_PEARL.get(), 20);
        }
        if (target instanceof EndermanEntity && StuffChecker.isUsingEnderWeapon(player) || !target.func_230279_az_() && StuffChecker.isUsingFireWeapon(player) || (target.func_230279_az_() && !(target instanceof WitherEntity) && !(target instanceof EnderDragonEntity) || target instanceof EndermanEntity) && StuffChecker.isUsingWaterWeapon(player) || target instanceof PhantomEntity && StuffChecker.isUsingPhantomWeapon(player) || target instanceof PiglinBruteEntity && StuffChecker.isUsingGoldWeapon(player) || StuffChecker.intWearingCorrupt(player) > 0 && StuffChecker.isUsingCorruptWeapon(player)) {
            player.getPersistentData().func_74776_a("upgraded_netherite_bonus_damage", player.func_184825_o(0.0f));
        }
        if ((double)player.func_184825_o(0.0f) >= 1.0 && (StuffChecker.isUsingEnderWeapon(player) || StuffChecker.isUsingWitherWeapon(player) || StuffChecker.isUsingPoisonWeapon(player))) {
            player.getPersistentData().func_74757_a("upgraded_netherite_fullcharged_attack", true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onPlayerDamageEntity(LivingHurtEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof ServerPlayerEntity)) {
            if (event.getEntityLiving() instanceof PlayerEntity && StuffChecker.isWearingUltimateArmor((PlayerEntity)event.getEntityLiving()) && ((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateNoDamage.get()).booleanValue() && event.getSource() != DamageSource.field_76380_i) {
                event.setAmount(0.0f);
                Iterable armorList = event.getEntityLiving().func_184193_aE();
                for (ItemStack stuff : armorList) {
                    ArmorItem piece;
                    IArmorMaterial pieceMaterial;
                    if (stuff.func_190926_b() || !(stuff.func_77973_b() instanceof ArmorItem) || (pieceMaterial = (piece = (ArmorItem)stuff.func_77973_b()).func_200880_d()) != ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE) continue;
                    stuff.func_222118_a(1, (LivingEntity)((PlayerEntity)event.getEntityLiving()), livingEntity -> livingEntity.func_213361_c(((ArmorItem)stuff.func_77973_b()).func_185083_B_()));
                }
                return;
            } else if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_70644_a((Effect)UpgradedNetheriteEffects.NETHERITE_RESISTANCE.get()) && event.getSource() != DamageSource.field_76380_i) {
                if (event.getEntityLiving().func_70660_b((Effect)UpgradedNetheriteEffects.NETHERITE_RESISTANCE.get()).func_76458_c() == 0 && event.getAmount() > 4.0f) {
                    event.setAmount(4.0f);
                    return;
                } else if (event.getEntityLiving().func_70660_b((Effect)UpgradedNetheriteEffects.NETHERITE_RESISTANCE.get()).func_76458_c() == 1 && event.getAmount() > 2.0f) {
                    event.setAmount(2.0f);
                    return;
                } else {
                    if (event.getEntityLiving().func_70660_b((Effect)UpgradedNetheriteEffects.NETHERITE_RESISTANCE.get()).func_76458_c() < 2 || !(event.getAmount() > 1.0f)) return;
                    event.setAmount(1.0f);
                }
                return;
            } else if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_184187_bx() instanceof HorseEntity && StuffChecker.isHorseWearing((HorseEntity)event.getEntityLiving().func_184187_bx(), (Item)ModItems.FEATHER_UPGRADED_NETHERITE_ARMOR_HORSE.get()) && event.getSource() == DamageSource.field_76379_h) {
                event.setAmount(event.getAmount() / 2.0f);
                return;
            } else {
                if (!(event.getEntityLiving() instanceof HorseEntity) || !StuffChecker.isHorseWearing((HorseEntity)event.getEntityLiving(), (Item)ModItems.FEATHER_UPGRADED_NETHERITE_ARMOR_HORSE.get()) || event.getSource() != DamageSource.field_76379_h) return;
                event.setAmount(event.getAmount() / 2.0f);
            }
            return;
        } else if (event.getSource().func_76346_g() instanceof ServerPlayerEntity && ItemStack.func_185132_d((ItemStack)((ServerPlayerEntity)event.getSource().func_76346_g()).func_184614_ca(), (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_PEARL.get()))) {
            event.setAmount(0.0f);
            return;
        } else {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getSource().func_76346_g();
            ItemStack heldItem = player.func_184614_ca();
            LivingEntity entity = (LivingEntity)event.getEntity();
            LivingEntity target = event.getEntityLiving();
            if (event.getSource().func_76364_f() instanceof ArrowEntity || event.getSource().func_76364_f() instanceof SpectralArrowEntity) {
                Double rand;
                if (!target.func_230279_az_() && event.getSource().func_76364_f().func_184216_O().contains("FireUpgradedNetheriteBow")) {
                    if (event.getSource().func_76364_f().func_184216_O().contains("FlameFireUpgradedNetheriteBow")) {
                        event.setAmount(event.getAmount() + 2.0f);
                    } else {
                        event.setAmount(event.getAmount() + 1.0f);
                    }
                }
                if (target.func_230279_az_() && !(target instanceof WitherEntity) && !(target instanceof EnderDragonEntity) && event.getSource().func_76364_f().func_184216_O().contains("WaterUpgradedNetheriteBow")) {
                    event.setAmount(event.getAmount() + 2.0f);
                }
                if (event.getSource().func_76364_f().func_184216_O().contains("WitherUpgradedNetheriteBow") && (rand = Double.valueOf(Math.random())) <= 0.5) {
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_82731_v, 120, 0, false, true));
                    if (entity.func_70644_a(Effects.field_82731_v) && (rand = Double.valueOf(Math.random())) <= 0.15) {
                        event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_82731_v, 120, 1, false, true));
                    }
                }
                if (event.getSource().func_76364_f().func_184216_O().contains("PoisonUpgradedNetheriteBow") && (rand = Math.random()) <= 0.5) {
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76436_u, 120, 0, false, true));
                }
                if (target instanceof PhantomEntity && event.getSource().func_76364_f().func_184216_O().contains("PhantomUpgradedNetheriteBow")) {
                    event.setAmount(event.getAmount() + 2.0f);
                }
                if (event.getSource().func_76364_f().func_184216_O().contains("FeatherUpgradedNetheriteBow")) {
                    event.getEntityLiving().func_195064_c(new EffectInstance((Effect)UpgradedNetheriteEffects.ATTRACTION.get(), 200, 0, false, true));
                }
                if (event.getSource().func_76364_f().func_184216_O().contains("CorruptUpgradedNetheriteBow") && event.getSource().func_76364_f().func_184216_O().contains("LootingCorruptUpgradedNetheriteBow") && event.getSource().func_76364_f().getPersistentData().func_74762_e("LootingCorruptUpgradedNetheriteBow") > 0) {
                    event.setAmount(event.getAmount() + (float)event.getSource().func_76364_f().getPersistentData().func_74762_e("LootingCorruptUpgradedNetheriteBow"));
                }
                if (!StuffChecker.CheckUltimateInstaKillEffect().booleanValue() || !event.getSource().func_76364_f().func_184216_O().contains("UltimateUpgradedNetheriteBow")) return;
                event.setAmount(target.func_110139_bj() + target.func_110143_aJ() + 1.0f);
                return;
            } else {
                Double rand;
                if (StuffChecker.CheckUltimateInstaKillEffect().booleanValue() && StuffChecker.isUsingUltimateWeapon((PlayerEntity)player)) {
                    event.setAmount(target.func_110139_bj() + target.func_110143_aJ() + 1.0f);
                }
                if (StuffChecker.isUsingEnderWeapon((PlayerEntity)player) && !(target instanceof WitherEntity) && !(target instanceof EnderDragonEntity)) {
                    if (player.getPersistentData().func_74764_b("upgraded_netherite_fullcharged_attack") && player.getPersistentData().func_74767_n("upgraded_netherite_fullcharged_attack")) {
                        event.getEntityLiving().func_195064_c(new EffectInstance((Effect)UpgradedNetheriteEffects.ENDER_ANCHOR.get(), 200, 0, false, false));
                    }
                    if (target instanceof EndermanEntity) {
                        if (player.getPersistentData().func_74764_b("upgraded_netherite_bonus_damage") && player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") < 1.0f) {
                            event.setAmount(event.getAmount() + 1.0f * player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") / 2.0f);
                        } else {
                            event.setAmount(event.getAmount() + 1.0f);
                        }
                    }
                }
                if (StuffChecker.isUsingWitherWeapon((PlayerEntity)player) && player.getPersistentData().func_74764_b("upgraded_netherite_fullcharged_attack") && player.getPersistentData().func_74767_n("upgraded_netherite_fullcharged_attack") && (rand = Double.valueOf(Math.random())) <= 0.5) {
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_82731_v, 120, 0, false, true));
                    if (entity.func_70644_a(Effects.field_82731_v) && (rand = Double.valueOf(Math.random())) <= 0.15) {
                        event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_82731_v, 120, 1, false, true));
                    }
                }
                if (StuffChecker.isUsingPoisonWeapon((PlayerEntity)player) && player.getPersistentData().func_74764_b("upgraded_netherite_fullcharged_attack") && player.getPersistentData().func_74767_n("upgraded_netherite_fullcharged_attack") && (rand = Math.random()) <= 0.5) {
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76436_u, 120, 0, false, true));
                }
                if (!target.func_230279_az_() && StuffChecker.isUsingFireWeapon((PlayerEntity)player)) {
                    float EnchantBonus = 0.0f;
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)heldItem);
                    if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.field_77334_n)) {
                        int EnchantLevel = (Integer)enchantments.get(Enchantments.field_77334_n);
                        EnchantBonus = EnchantLevel;
                    }
                    if (EnchantBonus >= 2.0f) {
                        if (player.getPersistentData().func_74764_b("upgraded_netherite_bonus_damage") && player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") < 1.0f) {
                            event.setAmount(event.getAmount() + 2.0f * player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") / 2.0f);
                        } else {
                            event.setAmount(event.getAmount() + 2.0f);
                        }
                    } else if (player.getPersistentData().func_74764_b("upgraded_netherite_bonus_damage") && player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") < 1.0f) {
                        event.setAmount(event.getAmount() + 1.0f * player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") / 2.0f);
                    } else {
                        event.setAmount(event.getAmount() + 1.0f);
                    }
                }
                if (target.func_230279_az_() && !(target instanceof WitherEntity) && !(target instanceof EnderDragonEntity) && StuffChecker.isUsingWaterWeapon((PlayerEntity)player)) {
                    if (player.getPersistentData().func_74764_b("upgraded_netherite_bonus_damage") && player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") < 1.0f) {
                        event.setAmount(event.getAmount() + 2.0f * player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") / 2.0f);
                    } else {
                        event.setAmount(event.getAmount() + 2.0f);
                    }
                }
                if (target instanceof EndermanEntity && StuffChecker.isUsingWaterWeapon((PlayerEntity)player)) {
                    if (player.getPersistentData().func_74764_b("upgraded_netherite_bonus_damage") && player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") < 1.0f) {
                        event.setAmount(event.getAmount() + 2.0f * player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") / 2.0f);
                    } else {
                        event.setAmount(event.getAmount() + 2.0f);
                    }
                }
                if (target instanceof PhantomEntity && StuffChecker.isUsingPhantomWeapon((PlayerEntity)player) && !ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.PHANTOM_UPGRADED_NETHERITE_BOW.get()))) {
                    if (player.getPersistentData().func_74764_b("upgraded_netherite_bonus_damage") && player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") < 1.0f) {
                        event.setAmount(event.getAmount() + 2.0f * player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") / 2.0f);
                    } else {
                        event.setAmount(event.getAmount() + 2.0f);
                    }
                }
                if (target instanceof PiglinBruteEntity && StuffChecker.isUsingGoldWeapon((PlayerEntity)player)) {
                    if (player.getPersistentData().func_74764_b("upgraded_netherite_bonus_damage") && player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") < 1.0f) {
                        event.setAmount(event.getAmount() + 2.0f * player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") / 2.0f);
                    } else {
                        event.setAmount(event.getAmount() + 2.0f);
                    }
                }
                if (StuffChecker.intWearingCorrupt((PlayerEntity)player) > 0 && StuffChecker.isUsingCorruptWeapon((PlayerEntity)player)) {
                    if (player.getPersistentData().func_74764_b("upgraded_netherite_bonus_damage") && player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") < 1.0f) {
                        event.setAmount(event.getAmount() + (float)StuffChecker.intWearingCorrupt((PlayerEntity)player).intValue() * player.getPersistentData().func_74760_g("upgraded_netherite_bonus_damage") / 2.0f);
                    } else {
                        event.setAmount(event.getAmount() + (float)StuffChecker.intWearingCorrupt((PlayerEntity)player).intValue());
                    }
                }
                if (player.getPersistentData().func_74764_b("upgraded_netherite_fullcharged_attack")) {
                    player.getPersistentData().func_82580_o("upgraded_netherite_fullcharged_attack");
                }
                if (!player.getPersistentData().func_74764_b("upgraded_netherite_bonus_damage")) return;
                player.getPersistentData().func_82580_o("upgraded_netherite_bonus_damage");
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_70644_a((Effect)UpgradedNetheriteEffects.ENDER_ANCHOR.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        Integer IRNG;
        BlockPos blockpos;
        SoundEvent soundevent;
        Boolean validtp;
        World world;
        if (event.getEntityLiving() instanceof PlayerEntity) {
            HorseEntity horse;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (event.getSource().func_76347_k() && StuffChecker.isWearingFireArmor(player)) {
                if (((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableFireImmune.get()).booleanValue()) {
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    }
                    player.func_70066_B();
                    StuffChecker.FireDurabilityLoss(player);
                }
            } else if (event.getSource() == DamageSource.field_76380_i && StuffChecker.isWearingEnderArmor(player) && player.func_226278_cu_() < -63.0 && !player.func_70644_a((Effect)UpgradedNetheriteEffects.ENDER_ANCHOR.get())) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                world = player.field_70170_p;
                player.func_184210_p();
                player.field_70143_R = 0.0f;
                if (!player.field_70170_p.field_72995_K) {
                    validtp = false;
                    if (player.getPersistentData().func_74764_b("UpgradedNetherite_EnderPosition")) {
                        if (player.func_213373_a((double)player.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[0] + 0.5, (double)player.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[1], (double)player.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[2] + 0.5, true)) {
                            soundevent = SoundEvents.field_187534_aX;
                            player.field_70170_p.func_184148_a(null, (double)player.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[0] + 0.5, (double)player.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[1], (double)player.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[2] + 0.5, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            player.func_184185_a(soundevent, 1.0f, 1.0f);
                            validtp = true;
                        } else {
                            blockpos = new BlockPos(player.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[0], player.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[1], player.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[2]);
                            ArrayList validtpList = new ArrayList();
                            for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-5, -5, -5), (BlockPos)blockpos.func_177982_a(5, 5, 5))) {
                                if (!world.func_180495_p(blockpos1.func_177977_b()).func_185904_a().func_76230_c() || !player.field_70170_p.func_204610_c(blockpos1).func_206888_e() && !player.field_70170_p.func_180495_p(blockpos1).func_203425_a(Blocks.field_203203_C) || !player.field_70170_p.func_180495_p(blockpos1).func_196957_g((IBlockReader)player.field_70170_p, blockpos1, PathType.LAND) || !player.field_70170_p.func_204610_c(blockpos1.func_177984_a()).func_206888_e() && !player.field_70170_p.func_180495_p(blockpos1.func_177984_a()).func_203425_a(Blocks.field_203203_C) || !player.field_70170_p.func_180495_p(blockpos1.func_177984_a()).func_196957_g((IBlockReader)player.field_70170_p, blockpos1.func_177984_a(), PathType.LAND)) continue;
                                validtpList.add(blockpos1.func_185334_h());
                            }
                            if (validtpList.size() > 0) {
                                IRNG = player.func_70681_au().nextInt(validtpList.size());
                                player.func_70634_a((double)((BlockPos)validtpList.get(IRNG)).func_177958_n() + 0.5, (double)((BlockPos)validtpList.get(IRNG)).func_177956_o(), (double)((BlockPos)validtpList.get(IRNG)).func_177952_p() + 0.5);
                                SoundEvent soundevent2 = SoundEvents.field_187534_aX;
                                player.field_70170_p.func_184148_a(null, (double)((BlockPos)validtpList.get(IRNG)).func_177958_n() + 0.5, (double)((BlockPos)validtpList.get(IRNG)).func_177956_o(), (double)((BlockPos)validtpList.get(IRNG)).func_177952_p() + 0.5, soundevent2, SoundCategory.PLAYERS, 1.0f, 1.0f);
                                player.func_184185_a(soundevent2, 1.0f, 1.0f);
                                validtp = true;
                            }
                        }
                    }
                    if (!validtp.booleanValue()) {
                        if (!world.func_180495_p(new BlockPos(100, 48, 0)).func_185904_a().func_76230_c()) {
                            world.func_175656_a(new BlockPos(100, 48, 0), Blocks.field_150343_Z.func_176223_P());
                        }
                        if (world.func_180495_p(new BlockPos(100, 49, 0)) != Blocks.field_150350_a.func_176223_P()) {
                            world.func_175656_a(new BlockPos(100, 49, 0), Blocks.field_150350_a.func_176223_P());
                        }
                        if (world.func_180495_p(new BlockPos(100, 50, 0)) != Blocks.field_150350_a.func_176223_P()) {
                            world.func_175656_a(new BlockPos(100, 50, 0), Blocks.field_150350_a.func_176223_P());
                        }
                        player.func_70634_a(100.5, 49.0, 0.5);
                        soundevent = SoundEvents.field_187534_aX;
                        player.field_70170_p.func_184148_a(null, 100.5, 49.0, 0.5, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        player.func_184185_a(soundevent, 1.0f, 1.0f);
                    }
                    Iterable armorList = player.func_184193_aE();
                    if (((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableBreakEnderArmor.get()).booleanValue()) {
                        for (Object stack : armorList) {
                            ArmorItem piece;
                            IArmorMaterial pieceMaterial;
                            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (pieceMaterial = (piece = (ArmorItem)stack.func_77973_b()).func_200880_d()) != ModArmorMaterial.ENDER_UPGRADED_NETHERITE) continue;
                            stack.func_222118_a(stack.func_77958_k() - stack.func_77952_i(), (LivingEntity)player, arg_0 -> EventHandler.lambda$onLivingAttackEvent$1((ItemStack)stack, arg_0));
                        }
                    }
                }
            } else if (event.getSource() == DamageSource.field_76379_h && player.func_184187_bx() instanceof HorseEntity && StuffChecker.isHorseWearing(horse = (HorseEntity)player.func_184187_bx().getEntity(), (Item)ModItems.PHANTOM_UPGRADED_NETHERITE_ARMOR_HORSE.get()) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof LivingEntity) {
                Double rand;
                Entity attacker = event.getSource().func_76346_g();
                Item shield = player.func_184607_cu().func_77973_b();
                if (shield instanceof UpgradedNetheriteShield && (shield == ModItems.GOLD_UPGRADED_NETHERITE_SHIELD.get() || shield == ModItems.ULTIMATE_UPGRADED_NETHERITE_SHIELD.get() && StuffChecker.CheckUltimateGoldToolEffect().booleanValue()) && (attacker instanceof PiglinEntity || attacker instanceof PiglinBruteEntity) && player.func_184585_cz() && (rand = Double.valueOf(Math.random())) <= 0.5) {
                    attacker.func_70097_a(DamageSource.field_76377_j, 1.0f);
                }
                if (shield instanceof UpgradedNetheriteShield && (shield == ModItems.FIRE_UPGRADED_NETHERITE_SHIELD.get() || shield == ModItems.ULTIMATE_UPGRADED_NETHERITE_SHIELD.get() && StuffChecker.CheckUltimateFireToolEffect().booleanValue()) && !attacker.func_230279_az_() && player.func_184585_cz() && (rand = Double.valueOf(Math.random())) <= 0.5) {
                    attacker.func_70097_a(DamageSource.field_76377_j, 1.0f);
                }
                if (shield instanceof UpgradedNetheriteShield && (shield == ModItems.ENDER_UPGRADED_NETHERITE_SHIELD.get() || shield == ModItems.ULTIMATE_UPGRADED_NETHERITE_SHIELD.get() && StuffChecker.CheckUltimateEnderToolEffect().booleanValue()) && attacker instanceof EndermanEntity && player.func_184585_cz() && (rand = Double.valueOf(Math.random())) <= 0.5) {
                    attacker.func_70097_a(DamageSource.field_76377_j, 1.0f);
                    ((LivingEntity)attacker).func_195064_c(new EffectInstance((Effect)UpgradedNetheriteEffects.ENDER_ANCHOR.get(), 200, 0, false, false));
                }
                if (shield instanceof UpgradedNetheriteShield && (shield == ModItems.WATER_UPGRADED_NETHERITE_SHIELD.get() || shield == ModItems.ULTIMATE_UPGRADED_NETHERITE_SHIELD.get() && StuffChecker.CheckUltimateEnderToolEffect().booleanValue()) && attacker.func_230279_az_() && player.func_184585_cz() && (rand = Double.valueOf(Math.random())) <= 0.5) {
                    attacker.func_70097_a(DamageSource.field_76377_j, 1.0f);
                }
                if (shield instanceof UpgradedNetheriteShield && (shield == ModItems.WATER_UPGRADED_NETHERITE_SHIELD.get() || shield == ModItems.ULTIMATE_UPGRADED_NETHERITE_SHIELD.get() && StuffChecker.CheckUltimateWaterToolEffect().booleanValue()) && attacker instanceof EndermanEntity && player.func_184585_cz() && (rand = Double.valueOf(Math.random())) <= 0.5) {
                    attacker.func_70097_a(DamageSource.field_76377_j, 2.0f);
                }
                if (shield instanceof UpgradedNetheriteShield && (shield == ModItems.WITHER_UPGRADED_NETHERITE_SHIELD.get() || shield == ModItems.ULTIMATE_UPGRADED_NETHERITE_SHIELD.get() && StuffChecker.CheckUltimateWitherToolEffect().booleanValue()) && player.func_184585_cz() && (rand = Double.valueOf(Math.random())) <= 0.25) {
                    ((LivingEntity)attacker).func_195064_c(new EffectInstance(Effects.field_82731_v, 120, 0, false, true));
                    if (((LivingEntity)attacker).func_70644_a(Effects.field_82731_v) && (rand = Double.valueOf(Math.random())) <= 0.15) {
                        ((LivingEntity)attacker).func_195064_c(new EffectInstance(Effects.field_82731_v, 120, 1, false, true));
                    }
                }
                if (shield instanceof UpgradedNetheriteShield && (shield == ModItems.POISON_UPGRADED_NETHERITE_SHIELD.get() || shield == ModItems.ULTIMATE_UPGRADED_NETHERITE_SHIELD.get() && StuffChecker.CheckUltimatePoisonToolEffect().booleanValue()) && player.func_184585_cz() && (rand = Double.valueOf(Math.random())) <= 0.25) {
                    ((LivingEntity)attacker).func_195064_c(new EffectInstance(Effects.field_76436_u, 120, 0, false, true));
                }
                if (shield instanceof UpgradedNetheriteShield && (shield == ModItems.PHANTOM_UPGRADED_NETHERITE_SHIELD.get() || shield == ModItems.ULTIMATE_UPGRADED_NETHERITE_SHIELD.get() && StuffChecker.CheckUltimatePhantomToolEffect().booleanValue()) && attacker instanceof PhantomEntity && player.func_184585_cz() && (rand = Double.valueOf(Math.random())) <= 0.5) {
                    attacker.func_70097_a(DamageSource.field_76377_j, 1.0f);
                }
                if (shield instanceof UpgradedNetheriteShield && (shield == ModItems.FEATHER_UPGRADED_NETHERITE_SHIELD.get() || shield == ModItems.ULTIMATE_UPGRADED_NETHERITE_SHIELD.get() && StuffChecker.CheckUltimateFeatherToolEffect().booleanValue()) && player.func_184585_cz() && (rand = Double.valueOf(Math.random())) <= 0.5) {
                    double px = player.func_226277_ct_();
                    double py = player.func_226278_cu_();
                    double pz = player.func_226281_cx_();
                    List entitys = player.field_70170_p.func_217357_a(Entity.class, new AxisAlignedBB(px - 1.0, py - 1.0, pz - 1.0, px + 1.0, py + 1.0, pz + 1.0));
                    int bumped = 0;
                    for (Entity entity : entitys) {
                        if (!entity.func_70089_S() || entity instanceof WitherEntity || entity instanceof EnderDragonEntity || entity instanceof PlayerEntity && !(attacker instanceof PlayerEntity)) continue;
                        if (bumped > 32) break;
                        Vector3d entityVector = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                        Vector3d finalVector = new Vector3d(px, py + 0.5, pz).func_178788_d(entityVector);
                        Double distance = Math.sqrt(finalVector.field_72450_a * finalVector.field_72450_a + finalVector.field_72448_b * finalVector.field_72448_b + finalVector.field_72449_c * finalVector.field_72449_c);
                        if (distance > 1.0) {
                            finalVector = finalVector.func_72432_b();
                        }
                        entity.func_213293_j(-finalVector.field_72450_a * 1.25, 0.25, -finalVector.field_72449_c * 1.25);
                        ++bumped;
                    }
                }
            }
        }
        if (event.getEntityLiving() instanceof HorseEntity && ((HorseEntity)event.getEntityLiving()).func_110248_bS()) {
            HorseEntity horse = (HorseEntity)event.getEntityLiving();
            if (event.getSource().func_76347_k() && StuffChecker.isHorseWearing(horse, (Item)ModItems.FIRE_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                horse.func_70066_B();
            } else if (event.getSource() == DamageSource.field_76379_h && StuffChecker.isHorseWearing(horse, (Item)ModItems.PHANTOM_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            } else if (event.getSource() == DamageSource.field_76369_e && StuffChecker.isHorseWearing(horse, (Item)ModItems.WATER_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                horse.func_70050_g(horse.func_205010_bg());
            } else if (event.getSource() == DamageSource.field_76380_i && StuffChecker.isHorseWearing(horse, (Item)ModItems.ENDER_UPGRADED_NETHERITE_ARMOR_HORSE.get()) && horse.func_226278_cu_() < -63.0) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                world = horse.field_70170_p;
                if (!horse.func_184188_bt().isEmpty()) {
                    horse.func_184226_ay();
                }
                horse.field_70143_R = 0.0f;
                validtp = false;
                if (horse.getPersistentData().func_74764_b("UpgradedNetherite_EnderPosition")) {
                    if (horse.func_213373_a((double)horse.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[0] + 0.5, (double)horse.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[1], (double)horse.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[2] + 0.5, true)) {
                        soundevent = SoundEvents.field_187534_aX;
                        horse.field_70170_p.func_184148_a(null, (double)horse.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[0] + 0.5, (double)horse.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[1], (double)horse.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[2] + 0.5, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        horse.func_184185_a(soundevent, 1.0f, 1.0f);
                        validtp = true;
                    } else {
                        blockpos = new BlockPos(horse.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[0], horse.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[1], horse.getPersistentData().func_74759_k("UpgradedNetherite_EnderPosition")[2]);
                        ArrayList<BlockPos> validtpList = new ArrayList<BlockPos>();
                        for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-10, -10, -10), (BlockPos)blockpos.func_177982_a(10, 10, 10))) {
                            if (!world.func_180495_p(blockpos1.func_177977_b()).func_185904_a().func_76230_c() || !horse.field_70170_p.func_204610_c(blockpos1).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1, PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(-1, 1, 0)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, 0)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, 0)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(-1, 1, 0), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(-1, 1, -1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, -1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, -1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(-1, 1, -1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(-1, 1, 1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, 1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(-1, 1, 1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(-1, 1, 1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(0, 1, 0)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, 0)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, 0)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(0, 1, 0), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(0, 1, -1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, -1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, -1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(0, 1, -1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(0, 1, 1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, 1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(0, 1, 1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(0, 1, 1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(1, 1, 0)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, 0)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, 0)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(1, 1, 0), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(1, 1, -1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, -1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, -1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(1, 1, -1), PathType.LAND) || !horse.field_70170_p.func_204610_c(blockpos1.func_177982_a(1, 1, 1)).func_206888_e() && !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, 1)).func_203425_a(Blocks.field_203203_C) || !horse.field_70170_p.func_180495_p(blockpos1.func_177982_a(1, 1, 1)).func_196957_g((IBlockReader)horse.field_70170_p, blockpos1.func_177982_a(1, 1, 1), PathType.LAND)) continue;
                            validtpList.add(blockpos1.func_185334_h());
                        }
                        if (validtpList.size() > 0) {
                            IRNG = horse.func_70681_au().nextInt(validtpList.size());
                            horse.func_70634_a((double)((BlockPos)validtpList.get(IRNG)).func_177958_n() + 0.5, (double)((BlockPos)validtpList.get(IRNG)).func_177956_o(), (double)((BlockPos)validtpList.get(IRNG)).func_177952_p() + 0.5);
                            SoundEvent soundevent3 = SoundEvents.field_187534_aX;
                            horse.field_70170_p.func_184148_a(null, (double)((BlockPos)validtpList.get(IRNG)).func_177958_n() + 0.5, (double)((BlockPos)validtpList.get(IRNG)).func_177956_o(), (double)((BlockPos)validtpList.get(IRNG)).func_177952_p() + 0.5, soundevent3, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            horse.func_184185_a(soundevent3, 1.0f, 1.0f);
                            validtp = true;
                        }
                    }
                }
                if (!validtp.booleanValue()) {
                    blockpos = new BlockPos(100.5, 49.0, 0.5);
                    for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-1, -1, -1), (BlockPos)blockpos.func_177982_a(1, -1, 1))) {
                        world.func_175656_a(blockpos1, Blocks.field_150343_Z.func_176223_P());
                    }
                    for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-1, 0, -1), (BlockPos)blockpos.func_177982_a(1, 1, 1))) {
                        world.func_175656_a(blockpos1, Blocks.field_150350_a.func_176223_P());
                    }
                    horse.func_70634_a(100.5, 49.0, 0.5);
                    SoundEvent soundevent4 = SoundEvents.field_187534_aX;
                    horse.field_70170_p.func_184148_a(null, 100.5, 49.0, 0.5, soundevent4, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    horse.func_184185_a(soundevent4, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onEntityFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (StuffChecker.isWearingPhantomArmor(player)) {
                event.setResult(Event.Result.DENY);
                if (((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableDamageDurabilityPhantomArmor.get()).booleanValue()) {
                    Iterable armorList = player.func_184193_aE();
                    for (ItemStack stack : armorList) {
                        ArmorItem piece;
                        IArmorMaterial pieceMaterial;
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (pieceMaterial = (piece = (ArmorItem)stack.func_77973_b()).func_200880_d()) != ModArmorMaterial.PHANTOM_UPGRADED_NETHERITE || !((double)player.field_70143_R >= 3.5)) continue;
                        stack.func_222118_a((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.MultiplierDamageDurabilityPhantomArmor.get() * (Math.round(player.field_70143_R) - 3), (LivingEntity)player, livingEntity -> livingEntity.func_213361_c(((ArmorItem)stack.func_77973_b()).func_185083_B_()));
                    }
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
            if (StuffChecker.isWearingFeatherArmor(player)) {
                event.setDamageMultiplier(0.5f);
                if (((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableFallDamageDurabilityFeatherArmor.get()).booleanValue() && (double)event.getDistance() > 3.0) {
                    StuffChecker.FeatherDurabilityLoss(player);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    @OnlyIn(value=Dist.CLIENT)
    public void onOverlayRender(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && StuffChecker.isWearingWaterArmor((PlayerEntity)mc.field_71439_g) && (double)mc.field_71439_g.func_70086_ai() >= (double)mc.field_71439_g.func_205010_bg() * 0.966) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (StuffChecker.isWearingFireArmor((PlayerEntity)player) && event.getInfo().func_216771_k().func_206884_a((ITag)FluidTags.field_206960_b)) {
            event.setDensity(0.25f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && StuffChecker.isUsingWaterTool(player = (PlayerEntity)event.getEntityLiving()) && player.func_208600_a((ITag)FluidTags.field_206959_a)) {
            event.setNewSpeed(event.getOriginalSpeed() * 2.0f);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        IInventory iinventory;
        if (event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        World world = player.field_70170_p;
        ItemStack heldItem = player.func_184614_ca();
        int x = event.getPos().func_177958_n();
        int y = event.getPos().func_177956_o();
        int z = event.getPos().func_177952_p();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.func_213453_ef() && StuffChecker.isUsingEnderTool(player) && (iinventory = HopperTileEntity.func_195484_a((World)world, (BlockPos)new BlockPos(x, y, z))) != null) {
            String dim = world.func_234923_W_().func_240901_a_().func_110623_a();
            if (heldItem.func_77978_p() != null && heldItem.func_77978_p().func_74764_b("UpgradedNetherite_Tagged") && heldItem.func_77978_p().func_74767_n("UpgradedNetherite_Tagged") && dim.equals(heldItem.func_77978_p().func_74779_i("UpgradedNetherite_Dimension")) && event.getPos().func_177958_n() == heldItem.func_77978_p().func_74759_k("UpgradedNetherite_Position")[0] && event.getPos().func_177956_o() == heldItem.func_77978_p().func_74759_k("UpgradedNetherite_Position")[1] && event.getPos().func_177952_p() == heldItem.func_77978_p().func_74759_k("UpgradedNetherite_Position")[2]) {
                heldItem.func_196082_o().func_82580_o("UpgradedNetherite_Position");
                heldItem.func_196082_o().func_82580_o("UpgradedNetherite_Dimension");
                heldItem.func_196082_o().func_82580_o("UpgradedNetherite_Tagged");
            } else {
                heldItem.func_196082_o().func_74783_a("UpgradedNetherite_Position", new int[]{x, y, z});
                heldItem.func_196082_o().func_74778_a("UpgradedNetherite_Dimension", player.field_70170_p.func_234923_W_().func_240901_a_().func_110623_a());
                heldItem.func_196082_o().func_74757_a("UpgradedNetherite_Tagged", true);
            }
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        HorseEntity horse;
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntityLiving()).getPersistentData().func_74764_b("upgraded_netherite_climbstick")) {
            player.getPersistentData().func_82580_o("upgraded_netherite_climbstick");
        }
        if (event.getEntityLiving() instanceof HorseEntity && ((HorseEntity)event.getEntityLiving()).func_110248_bS() && (horse = (HorseEntity)event.getEntityLiving()).getPersistentData().func_74764_b("upgraded_netherite_climbstick")) {
            horse.getPersistentData().func_82580_o("upgraded_netherite_climbstick");
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            HorseEntity horse;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack heldItem = player.func_184614_ca();
            if (player.func_184187_bx() instanceof HorseEntity && player.field_70170_p.field_72995_K && (StuffChecker.isHorseWearing(horse = (HorseEntity)player.func_184187_bx().getEntity(), (Item)ModItems.WATER_UPGRADED_NETHERITE_ARMOR_HORSE.get()) && horse.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a) || StuffChecker.isHorseWearing(horse, (Item)ModItems.FIRE_UPGRADED_NETHERITE_ARMOR_HORSE.get()) && horse.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b)) && player.field_70170_p.field_72995_K && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_192832_b != 0.0f) {
                double d3 = player.func_70040_Z().field_72448_b;
                double d4 = d3 < -0.2 ? 0.085 : 0.06;
                double d5 = player.field_70170_p.field_72995_K && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_192832_b > 0.0f ? (d3 - horse.func_213322_ci().field_72448_b) * d4 : -((d3 - horse.func_213322_ci().field_72448_b) * d4) / 4.0;
                horse.func_213317_d(horse.func_213322_ci().func_72441_c(0.0, d5, 0.0));
            }
            if (StuffChecker.isWearingGoldArmor(player)) {
                player.func_233645_dx_().func_233793_b_(this.LuckAttributeMap());
            } else if (!StuffChecker.isWearingGoldArmor(player)) {
                player.func_233645_dx_().func_233785_a_(this.LuckAttributeMap());
            }
            if (StuffChecker.isWearingFeatherArmor(player) && (player.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b) || player.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a)) && !player.func_213453_ef() && !player.func_203007_ba() && !player.func_184613_cA()) {
                if (player.func_70090_H() || player.func_180799_ab()) {
                    if (player.func_213322_ci().field_72448_b < 0.3 && (player.func_208600_a((ITag)FluidTags.field_206960_b) || player.func_208600_a((ITag)FluidTags.field_206959_a))) {
                        player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.3 - player.func_213322_ci().field_72448_b, 0.0));
                    } else if (player.func_213322_ci().field_72448_b < 0.15 && !player.func_208600_a((ITag)FluidTags.field_206960_b) && !player.func_208600_a((ITag)FluidTags.field_206959_a)) {
                        player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.15 - player.func_213322_ci().field_72448_b, 0.0));
                    }
                } else {
                    player.field_70143_R = 0.0f;
                    player.func_230245_c_(true);
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, -player.func_213322_ci().func_82617_b(), 0.0));
                    if (player.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b) && ((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableLavaDamageDurabilityFeatherArmor.get()).booleanValue()) {
                        StuffChecker.FeatherDurabilityLoss(player);
                    }
                    if (player.field_70170_p.func_204610_c(player.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a) && ((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableWaterDamageDurabilityFeatherArmor.get()).booleanValue()) {
                        StuffChecker.FeatherDurabilityLoss(player);
                    }
                }
            }
            if (player.field_70170_p.field_72995_K && StuffChecker.isWearingFeatherArmor(player) && (player.func_233570_aj_() || player.getPersistentData().func_74764_b("upgraded_netherite_climbstick")) && !player.getPersistentData().func_74764_b("upgraded_netherite_double_jump")) {
                player.getPersistentData().func_74757_a("upgraded_netherite_double_jump", true);
            } else if (player.field_70170_p.field_72995_K && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_78901_c && StuffChecker.isWearingFeatherArmor(player) && !player.field_71075_bZ.field_75101_c && !player.func_70090_H() && !player.func_180799_ab() && !player.func_70617_f_() && player.func_213322_ci().field_72448_b < 0.0 && player.getPersistentData().func_74764_b("upgraded_netherite_double_jump")) {
                player.field_70143_R = 0.0f;
                PlayerFallDistanceUpdateHandler.PlayerFallDistanceUpdate(player.func_110124_au(), Float.valueOf(player.field_70143_R));
                player.func_70664_aZ();
                player.getPersistentData().func_82580_o("upgraded_netherite_double_jump");
            } else if (!StuffChecker.isWearingFeatherArmor(player) && player.getPersistentData().func_74764_b("upgraded_netherite_double_jump")) {
                player.getPersistentData().func_82580_o("upgraded_netherite_double_jump");
            }
            if (StuffChecker.intWearingCorrupt(player) < 1) {
                player.func_233645_dx_().func_233785_a_(this.HealthAttributeMap(0));
            } else if (StuffChecker.intWearingCorrupt(player) >= 1) {
                player.func_233645_dx_().func_233793_b_(this.HealthAttributeMap(StuffChecker.intWearingCorrupt(player)));
            }
            if (StuffChecker.isWearingEnderArmor(player)) {
                BlockPos blockpos1 = player.getEntity().func_233580_cy_().func_177977_b();
                BlockState blockstate = player.field_70170_p.func_180495_p(blockpos1);
                if (blockstate.func_185904_a().func_76230_c()) {
                    player.getPersistentData().func_74783_a("UpgradedNetherite_EnderPosition", new int[]{player.getEntity().func_233580_cy_().func_177958_n(), player.getEntity().func_233580_cy_().func_177956_o(), player.getEntity().func_233580_cy_().func_177952_p()});
                }
            } else if (!StuffChecker.isWearingEnderArmor(player) && player.getPersistentData().func_74764_b("UpgradedNetherite_EnderPosition")) {
                player.getPersistentData().func_82580_o("UpgradedNetherite_EnderPosition");
            }
            if (StuffChecker.isWearingWaterArmor(player) && player.func_70086_ai() < player.func_205010_bg()) {
                player.func_70050_g(player.func_70086_ai() + 4);
                StuffChecker.WaterDurabilityLoss(player);
            }
            if (StuffChecker.isWearingPhantomArmor(player)) {
                if (player.field_70138_W < 1.0f) {
                    player.getPersistentData().func_74757_a("upgraded_netherite_stepheight", true);
                    player.field_70138_W = 1.0f;
                }
            } else if (player.getPersistentData().func_74764_b("upgraded_netherite_stepheight") && player.getPersistentData().func_74767_n("upgraded_netherite_stepheight") && player.field_70138_W > 0.6f) {
                player.field_70138_W = 0.6f;
                player.getPersistentData().func_82580_o("upgraded_netherite_stepheight");
            }
            if (StuffChecker.isWearingUltimateArmor(player) && StuffChecker.CheckUltimateFlyingEffect().booleanValue()) {
                if (!player.field_71075_bZ.field_75101_c) {
                    player.getPersistentData().func_74757_a("upgraded_netherite_ultimateflying", true);
                    player.field_71075_bZ.field_75101_c = true;
                }
            } else if (player.getPersistentData().func_74764_b("upgraded_netherite_ultimateflying") && player.getPersistentData().func_74767_n("upgraded_netherite_ultimateflying") && player.field_71075_bZ.field_75101_c) {
                player.getPersistentData().func_82580_o("upgraded_netherite_ultimateflying");
                if (!player.func_184812_l_()) {
                    player.field_71075_bZ.field_75101_c = false;
                    if (player.field_71075_bZ.field_75100_b) {
                        player.field_71075_bZ.field_75100_b = false;
                    }
                }
            }
            if (StuffChecker.intWearingCorrupt(player) > 0) {
                StuffChecker.CorruptDurabilityGain(player);
            }
            if (StuffChecker.isWearingFireArmor(player) && player.func_180799_ab() && !player.field_71075_bZ.field_75100_b) {
                player.func_213317_d(player.func_213322_ci().func_216372_d((double)1.66f, 1.0, (double)1.66f));
            }
            if (!player.field_70170_p.field_72995_K && StuffChecker.isUsingPhantomTool(player)) {
                List list = player.field_70170_p.func_175674_a((Entity)player, player.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0), entity -> entity instanceof LivingEntity);
                list.forEach(entity -> {
                    if (!(!(entity instanceof LivingEntity) || entity instanceof PlayerEntity && entity.func_213453_ef())) {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_188423_x, 5, 0, false, false));
                    }
                });
            }
            if (StuffChecker.isUsingPhantomTool(player)) {
                player.func_233645_dx_().func_233793_b_(this.ReachAttributeMap());
            } else if (!StuffChecker.isUsingPhantomTool(player)) {
                player.func_233645_dx_().func_233785_a_(this.ReachAttributeMap());
            }
            if (StuffChecker.intWearingCorrupt(player) > 0 || StuffChecker.isUsingCorruptTool(player) || StuffChecker.isUsingCorruptWeapon(player) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.CORRUPT_UPGRADED_NETHERITE_BOW.get()))) {
                StuffChecker.CorruptDurabilityGain(player);
            }
            if (StuffChecker.isWearingWaterArmor(player)) {
                player.func_233645_dx_().func_233793_b_(this.SwimAttributeMap());
            } else if (!StuffChecker.isWearingWaterArmor(player)) {
                player.func_233645_dx_().func_233785_a_(this.SwimAttributeMap());
            }
            if (StuffChecker.isUsingFeatherTool(player) && !player.func_213453_ef()) {
                double px = player.func_226277_ct_();
                double py = player.func_226278_cu_();
                double pz = player.func_226281_cx_();
                List items = player.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(px - 5.0, py - 5.0, pz - 5.0, px + 5.0, py + 5.0, pz + 5.0));
                int pulled = 0;
                for (ItemEntity item : items) {
                    if (!item.func_70089_S() || item.func_92059_d().func_190926_b() || item.getPersistentData().func_74767_n("PreventRemoteMovement")) continue;
                    if (pulled > 128) break;
                    Vector3d entityVector = new Vector3d(item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_());
                    Vector3d finalVector = new Vector3d(px, py + 0.5, pz).func_178788_d(entityVector);
                    if (Math.sqrt(finalVector.field_72450_a * finalVector.field_72450_a + finalVector.field_72448_b * finalVector.field_72448_b + finalVector.field_72449_c * finalVector.field_72449_c) > 1.0) {
                        finalVector = finalVector.func_72432_b();
                    }
                    item.func_213293_j(finalVector.field_72450_a * (double)0.3f, finalVector.field_72448_b * (double)0.3f, finalVector.field_72449_c * (double)0.3f);
                    item.func_174868_q();
                    ++pulled;
                }
            }
            if (StuffChecker.isWearingPoisonArmor(player)) {
                if (!player.func_213453_ef() && player.getPersistentData().func_74764_b("upgraded_netherite_climbstick") && player.getPersistentData().func_74767_n("upgraded_netherite_climbstick")) {
                    if (player.func_213322_ci().func_82617_b() < 0.0) {
                        player.func_230245_c_(true);
                        player.func_213317_d(player.func_213322_ci().func_72441_c(-player.func_213322_ci().func_82615_a() / 5.0, -player.func_213322_ci().func_82617_b(), -player.func_213322_ci().func_82616_c() / 5.0));
                        player.field_70143_R = 0.0f;
                    }
                    if (player.func_213322_ci().func_82615_a() != 0.0 && player.func_213322_ci().func_82616_c() != 0.0) {
                        player.getPersistentData().func_82580_o("upgraded_netherite_climbstick");
                    }
                }
                if ((player.func_213453_ef() || player.func_70617_f_()) && player.getPersistentData().func_74764_b("upgraded_netherite_climbstick") && player.getPersistentData().func_74767_n("upgraded_netherite_climbstick")) {
                    player.getPersistentData().func_82580_o("upgraded_netherite_climbstick");
                }
                if (!(player.func_213453_ef() || !player.field_70123_F || player.func_180799_ab() || player.func_70090_H() || player.field_71075_bZ.field_75100_b || player.func_70617_f_() || !(player.func_213322_ci().func_82617_b() < 0.1))) {
                    Double LookAt = player.func_70040_Z().field_72448_b;
                    if (LookAt > 0.1) {
                        LookAt = 0.1;
                    }
                    if (LookAt < -0.1) {
                        LookAt = -0.1;
                    }
                    if (player.field_70170_p.field_72995_K && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_192832_b < 0.0f) {
                        LookAt = LookAt * -1.0;
                    }
                    player.func_213317_d(player.func_213322_ci().func_72441_c(-player.func_213322_ci().func_82615_a() / 5.0, LookAt - player.func_213322_ci().field_72448_b, -player.func_213322_ci().func_82616_c() / 5.0));
                    player.getPersistentData().func_74757_a("upgraded_netherite_climbstick", true);
                    player.field_70143_R = 0.0f;
                    if (player.field_70170_p.field_72995_K) {
                        PlayerFallDistanceUpdateHandler.PlayerFallDistanceUpdate(player.func_110124_au(), Float.valueOf(player.field_70143_R));
                    }
                }
            } else if (!StuffChecker.isWearingPoisonArmor(player) && player.getPersistentData().func_74764_b("upgraded_netherite_climbstick")) {
                player.getPersistentData().func_82580_o("upgraded_netherite_climbstick");
            }
            StuffChecker.tickDurabilityCooldown(player);
        }
        if (event.getEntityLiving() instanceof HorseEntity && ((HorseEntity)event.getEntityLiving()).func_110248_bS()) {
            HorseEntity horse = (HorseEntity)event.getEntityLiving();
            PlayerEntity rider = null;
            if (!horse.func_184188_bt().isEmpty()) {
                for (Entity entity2 : horse.func_184188_bt()) {
                    if (!(entity2 instanceof PlayerEntity)) continue;
                    rider = (PlayerEntity)entity2;
                }
            }
            if (horse.func_180799_ab() && StuffChecker.isHorseWearing(horse, (Item)ModItems.FIRE_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                horse.func_213317_d(horse.func_213322_ci().func_216372_d(1.66, 1.0, 1.66));
            }
            if (StuffChecker.isHorseWearing(horse, (Item)ModItems.ENDER_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                BlockPos blockpos1 = horse.getEntity().func_233580_cy_().func_177977_b();
                BlockState blockstate = horse.field_70170_p.func_180495_p(blockpos1);
                if (blockstate.func_185904_a().func_76230_c()) {
                    horse.getPersistentData().func_74783_a("UpgradedNetherite_EnderPosition", new int[]{horse.getEntity().func_233580_cy_().func_177958_n(), horse.getEntity().func_233580_cy_().func_177956_o(), horse.getEntity().func_233580_cy_().func_177952_p()});
                }
            } else if (!StuffChecker.isHorseWearing(horse, (Item)ModItems.ENDER_UPGRADED_NETHERITE_ARMOR_HORSE.get()) && horse.getPersistentData().func_74764_b("UpgradedNetherite_EnderPosition")) {
                horse.getPersistentData().func_82580_o("UpgradedNetherite_EnderPosition");
            }
            if (StuffChecker.isHorseWearing(horse, (Item)ModItems.WATER_UPGRADED_NETHERITE_ARMOR_HORSE.get()) && horse.func_200601_bK()) {
                horse.canBeRiddenInWater((Entity)new SkeletonHorseEntity(EntityType.field_200742_ah, horse.field_70170_p));
            }
            if (StuffChecker.isHorseWearing(horse, (Item)ModItems.WATER_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                horse.func_233645_dx_().func_233793_b_(this.SwimHorseAttributeMap());
            } else if (!StuffChecker.isHorseWearing(horse, (Item)ModItems.WATER_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                horse.func_233645_dx_().func_233785_a_(this.SwimHorseAttributeMap());
            }
            if (StuffChecker.isHorseWearing(horse, (Item)ModItems.POISON_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                if (rider != null && horse.getPersistentData().func_74764_b("upgraded_netherite_climbstick") && horse.getPersistentData().func_74767_n("upgraded_netherite_climbstick")) {
                    if (horse.func_213322_ci().func_82617_b() < 0.0) {
                        horse.func_230245_c_(true);
                        horse.field_70143_R = 0.0f;
                        horse.func_213317_d(horse.func_213322_ci().func_72441_c(-horse.func_213322_ci().func_82615_a() / 10.0, -horse.func_213322_ci().func_82617_b(), -horse.func_213322_ci().func_82616_c() / 10.0));
                    }
                    if (horse.func_213322_ci().func_82615_a() != 0.0 && horse.func_213322_ci().func_82616_c() != 0.0) {
                        horse.getPersistentData().func_82580_o("upgraded_netherite_climbstick");
                    }
                }
                if (rider != null && horse.field_70123_F && !horse.func_180799_ab() && !horse.func_70090_H()) {
                    Double LookAt = horse.func_70040_Z().field_72448_b;
                    if (LookAt > 0.1) {
                        LookAt = 0.1;
                    }
                    if (LookAt < -0.1) {
                        LookAt = -0.1;
                    }
                    if (rider.field_70170_p.field_72995_K && ((ClientPlayerEntity)rider).field_71158_b.field_192832_b < 0.0f) {
                        LookAt = LookAt * -1.0;
                    }
                    horse.field_70143_R = 0.0f;
                    horse.func_213317_d(horse.func_213322_ci().func_72441_c(-horse.func_213322_ci().func_82615_a() / 10.0, LookAt - horse.func_213322_ci().field_72448_b, -horse.func_213322_ci().func_82616_c() / 10.0));
                    if (horse.field_70170_p.field_72995_K) {
                        EntityFallDistanceUpdateHandler.EntityFallDistanceUpdate(horse.func_145782_y(), Float.valueOf(horse.field_70143_R));
                    }
                    horse.getPersistentData().func_74757_a("upgraded_netherite_climbstick", true);
                }
            } else if (horse.getPersistentData().func_74764_b("upgraded_netherite_climbstick") && !StuffChecker.isHorseWearing(horse, (Item)ModItems.POISON_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                horse.getPersistentData().func_82580_o("upgraded_netherite_climbstick");
            }
            if (horse.func_70086_ai() < horse.func_205010_bg() && StuffChecker.isHorseWearing(horse, (Item)ModItems.WATER_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                horse.func_70050_g(horse.func_70086_ai() + 1);
            }
            if (horse.func_70644_a(Effects.field_82731_v) && StuffChecker.isHorseWearing(horse, (Item)ModItems.WITHER_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                horse.func_195063_d(Effects.field_82731_v);
            }
            if (horse.func_70644_a(Effects.field_76436_u) && StuffChecker.isHorseWearing(horse, (Item)ModItems.POISON_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                horse.func_195063_d(Effects.field_76436_u);
            }
            if ((horse.field_70170_p.func_204610_c(horse.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b) || horse.field_70170_p.func_204610_c(horse.getEntity().func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a)) && StuffChecker.isHorseWearing(horse, (Item)ModItems.FEATHER_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                if (horse.func_70090_H() || horse.func_180799_ab()) {
                    if (horse.func_213322_ci().field_72448_b < 0.3 && (horse.func_208600_a((ITag)FluidTags.field_206960_b) || horse.func_208600_a((ITag)FluidTags.field_206959_a))) {
                        horse.func_213317_d(horse.func_213322_ci().func_72441_c(0.0, 0.3 - horse.func_213322_ci().field_72448_b, 0.0));
                    } else if (horse.func_213322_ci().field_72448_b < 0.15 && !horse.func_208600_a((ITag)FluidTags.field_206960_b) && !horse.func_208600_a((ITag)FluidTags.field_206959_a)) {
                        horse.func_213317_d(horse.func_213322_ci().func_72441_c(0.0, 0.15 - horse.func_213322_ci().field_72448_b, 0.0));
                    }
                } else {
                    horse.func_230245_c_(true);
                    horse.func_70637_d(false);
                    horse.func_213317_d(horse.func_213322_ci().func_72441_c(0.0, -horse.func_213322_ci().func_82617_b(), 0.0));
                }
            }
        }
        if (event.getEntityLiving().func_70644_a((Effect)UpgradedNetheriteEffects.ATTRACTION.get())) {
            LivingEntity target = event.getEntityLiving();
            double tx = target.func_226277_ct_();
            double ty = target.func_226278_cu_();
            double tz = target.func_226281_cx_();
            List entities = target.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(tx - 5.0, ty - 5.0, tz - 5.0, tx + 5.0, ty + 5.0, tz + 5.0));
            int pulled = 0;
            for (LivingEntity entity3 : entities) {
                if (!entity3.func_70089_S() || entity3 == event.getEntityLiving() || target instanceof WitherEntity || target instanceof EnderDragonEntity || entity3 instanceof PlayerEntity && !(target instanceof PlayerEntity)) continue;
                if (pulled > 32) break;
                Vector3d entityVector = new Vector3d(entity3.func_226277_ct_(), entity3.func_226278_cu_(), entity3.func_226281_cx_());
                Vector3d finalVector = new Vector3d(tx, ty, tz).func_178788_d(entityVector);
                if (entity3.func_226278_cu_() < ty && target.func_233570_aj_()) {
                    finalVector = new Vector3d(tx, ty + 0.1, tz).func_178788_d(entityVector);
                    entity3.field_70143_R = 0.0f;
                }
                if (!(Math.sqrt(finalVector.field_72450_a * finalVector.field_72450_a + finalVector.field_72448_b * finalVector.field_72448_b + finalVector.field_72449_c * finalVector.field_72449_c) > 1.8)) continue;
                finalVector = finalVector.func_72432_b();
                entity3.func_213293_j(finalVector.field_72450_a * (double)0.15f, finalVector.field_72448_b * (double)0.15f, finalVector.field_72449_c * (double)0.15f);
                ++pulled;
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onApplyEffect(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            if (event.getPotionEffect().func_188419_a() == Effects.field_82731_v && StuffChecker.isWearingWitherArmor((PlayerEntity)player)) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                StuffChecker.WitherDurabilityLoss((PlayerEntity)player);
            } else if (event.getPotionEffect().func_188419_a() == Effects.field_76436_u && StuffChecker.isWearingPoisonArmor((PlayerEntity)player)) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                StuffChecker.PoisonDurabilityLoss((PlayerEntity)player);
            }
        }
        if (event.getEntityLiving() instanceof HorseEntity && ((HorseEntity)event.getEntityLiving()).func_110248_bS()) {
            HorseEntity horse = (HorseEntity)event.getEntityLiving();
            if (event.getPotionEffect().func_188419_a() == Effects.field_82731_v && StuffChecker.isHorseWearing(horse, (Item)ModItems.WITHER_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            } else if (event.getPotionEffect().func_188419_a() == Effects.field_76436_u && StuffChecker.isHorseWearing(horse, (Item)ModItems.POISON_UPGRADED_NETHERITE_ARMOR_HORSE.get())) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private static /* synthetic */ void lambda$onLivingAttackEvent$1(ItemStack stack, PlayerEntity e) {
        e.func_213361_c(((ArmorItem)stack.func_77973_b()).func_185083_B_());
    }
}

