/*
 * Decompiled with CFR 0.152.
 */
package com.Rolfmao.upgradednetherite.helpers;

import com.Rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.Rolfmao.upgradednetherite.init.ModItems;
import com.Rolfmao.upgradednetherite.utils.StuffChecker;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class UpgradedNetheriteModifiers {

    public static class EnderTeleportModifier
    extends LootModifier {
        protected EnderTeleportModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            Entity killer = (Entity)context.func_216031_c(LootParameters.field_216285_e);
            Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
            BlockState blockState = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
            Entity arrow = null;
            PlayerEntity player = null;
            if (blockState != null && entity instanceof PlayerEntity) {
                player = (PlayerEntity)entity;
            } else if (blockState == null && killer instanceof PlayerEntity) {
                player = (PlayerEntity)killer;
            } else if (blockState == null && (killer instanceof ArrowEntity || killer instanceof SpectralArrowEntity)) {
                arrow = killer;
            }
            if (player != null) {
                ItemStack heldItem = player.func_184614_ca();
                if (StuffChecker.isUsingEnderTool(player) && heldItem.func_77978_p() != null && heldItem.func_77978_p().func_74764_b("UpgradedNetherite_Tagged") && heldItem.func_77978_p().func_74767_n("UpgradedNetherite_Tagged")) {
                    World world = player.getEntity().field_70170_p;
                    String Iworld = world.func_234923_W_().func_240901_a_().func_110623_a();
                    if (!Iworld.equals(heldItem.func_77978_p().func_74779_i("UpgradedNetherite_Dimension"))) {
                        return generatedLoot;
                    }
                    BlockPos pos = new BlockPos(heldItem.func_77978_p().func_74759_k("UpgradedNetherite_Position")[0], heldItem.func_77978_p().func_74759_k("UpgradedNetherite_Position")[1], heldItem.func_77978_p().func_74759_k("UpgradedNetherite_Position")[2]);
                    IInventory iinventory = HopperTileEntity.func_195484_a((World)world, (BlockPos)pos);
                    if (iinventory != null) {
                        ArrayList<ItemStack> alis = new ArrayList<ItemStack>();
                        generatedLoot.forEach(stack -> alis.add(HopperTileEntity.func_174918_a(null, (IInventory)iinventory, (ItemStack)stack, null)));
                        return alis;
                    }
                }
            } else if (arrow != null && arrow.func_184216_O().contains("EnderUpgradedNetheriteBow") && arrow.getPersistentData().func_74767_n("UpgradedNetherite_Tagged")) {
                World world = arrow.field_70170_p;
                String Iworld = world.func_234923_W_().func_240901_a_().func_110623_a();
                if (!Iworld.equals(arrow.getPersistentData().func_74779_i("UpgradedNetherite_Dimension"))) {
                    return generatedLoot;
                }
                BlockPos pos = new BlockPos(arrow.getPersistentData().func_74759_k("UpgradedNetherite_Position")[0], arrow.getPersistentData().func_74759_k("UpgradedNetherite_Position")[1], arrow.getPersistentData().func_74759_k("UpgradedNetherite_Position")[2]);
                IInventory iinventory = HopperTileEntity.func_195484_a((World)world, (BlockPos)pos);
                if (iinventory != null) {
                    ArrayList<ItemStack> alis = new ArrayList<ItemStack>();
                    generatedLoot.forEach(stack -> alis.add(HopperTileEntity.func_174918_a(null, (IInventory)iinventory, (ItemStack)stack, null)));
                    return alis;
                }
            }
            return generatedLoot;
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<EnderTeleportModifier> {
            public EnderTeleportModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
                return new EnderTeleportModifier(conditions);
            }

            public JsonObject write(EnderTeleportModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    public static class FortuneBonusModifier
    extends LootModifier {
        public FortuneBonusModifier(ILootCondition[] conditions) {
            super(conditions);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (tool == null || tool.func_77942_o() && tool.func_77978_p() != null && tool.func_77978_p().func_74767_n("UpgradedNetherite_Fortune")) {
                return generatedLoot;
            }
            Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
            BlockState blockState = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
            PlayerEntity player = null;
            if (entity instanceof PlayerEntity) {
                player = (PlayerEntity)entity;
            }
            if (blockState == null || !(entity instanceof LivingEntity)) {
                return generatedLoot;
            }
            int FortuneBonus = 0;
            float FortuneLevel = 0.0f;
            ItemStack fakeTool = tool.func_190926_b() ? new ItemStack((IItemProvider)Items.field_234759_km_) : tool.func_77946_l();
            fakeTool.func_196082_o().func_74757_a("UpgradedNetherite_Fortune", true);
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)fakeTool);
            if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.field_185308_t)) {
                FortuneLevel = ((Integer)enchantments.get(Enchantments.field_185308_t)).intValue();
            }
            if (player != null && StuffChecker.isUsingGoldTool(player)) {
                FortuneBonus = FortuneLevel >= 3.0f ? 2 : 1;
            } else if (player != null && StuffChecker.isUsingCorruptTool(player)) {
                FortuneBonus = StuffChecker.intWearingCorrupt(player) * 2;
            }
            enchantments.put(Enchantments.field_185308_t, EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185308_t, (LivingEntity)player) + FortuneBonus);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)fakeTool);
            LootContext.Builder builder = new LootContext.Builder(context);
            builder.func_216015_a(LootParameters.field_216289_i, (Object)fakeTool);
            LootContext newContext = builder.func_216022_a(LootParameterSets.field_216267_h);
            LootTable lootTable = context.func_202879_g().func_73046_m().func_200249_aQ().func_186521_a(blockState.func_177230_c().func_220068_i());
            return lootTable.func_216113_a(newContext);
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<FortuneBonusModifier> {
            public FortuneBonusModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
                return new FortuneBonusModifier(conditions);
            }

            public JsonObject write(FortuneBonusModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    public static class AutoSmeltLootModifier
    extends LootModifier {
        protected AutoSmeltLootModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            ArrayList<ItemStack> alis = new ArrayList<ItemStack>();
            if (!(tool == null || tool.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_PICKAXE.get() && tool.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get() && tool.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_SHOVEL.get() && tool.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get() && tool.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_BOW.get() || ((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateFireToolEffect.get()).booleanValue())) {
                return generatedLoot;
            }
            if (!(tool == null || tool.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_PICKAXE.get() && tool.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get() && tool.func_77973_b() != ModItems.ULTIMATE_UPGRADED_NETHERITE_SHOVEL.get() || !((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateGoldToolEffect.get()).booleanValue() || tool.func_77978_p() != null && (tool.func_77978_p().func_74764_b("UpgradedNetherite_Fortune") || tool.func_77978_p().func_74767_n("UpgradedNetherite_Fortune")))) {
                return alis;
            }
            generatedLoot.forEach(stack -> alis.add(this.autosmelt((ItemStack)stack, (World)context.func_202879_g())));
            if (tool != null && ((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableAutoSmeltFortune.get()).booleanValue() && (((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c().getRegistryName().toString().contains("ore") && alis.toString().contains("ingot") || ((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c().getRegistryName().toString().contains("log") && alis.toString().contains("charcoal"))) {
                Double rand;
                ItemStack fakeTool = tool.func_190926_b() ? new ItemStack((IItemProvider)Items.field_234759_km_) : tool.func_77946_l();
                float FortuneLevel = 0.0f;
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)fakeTool);
                if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.field_185308_t)) {
                    FortuneLevel = ((Integer)enchantments.get(Enchantments.field_185308_t)).intValue();
                }
                if (FortuneLevel > 0.0f && (rand = Double.valueOf(Math.random())) >= (double)(2.0f / (FortuneLevel + 2.0f))) {
                    Integer randI = (int)(Math.random() * (double)FortuneLevel + 1.0);
                    for (int i = 0; i < randI; ++i) {
                        generatedLoot.forEach(stack -> alis.add(this.autosmelt((ItemStack)stack, (World)context.func_202879_g())));
                    }
                }
            }
            return alis;
        }

        protected ItemStack autosmelt(ItemStack stack, World world) {
            return world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), world).map(AbstractCookingRecipe::func_77571_b).filter(itemStack -> !itemStack.func_190926_b()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.func_190916_E() * itemStack.func_190916_E()))).orElse(stack);
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<AutoSmeltLootModifier> {
            public AutoSmeltLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
                return new AutoSmeltLootModifier(ailootcondition);
            }

            public JsonObject write(AutoSmeltLootModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }
}

