/*
 * Decompiled with CFR 0.152.
 */
package com.Rolfmao.upgradednetherite.packets;

import com.Rolfmao.upgradednetherite.handlers.PlayerFallDistanceUpdateHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPlayerFallDistanceUpdate {
    private UUID player;
    private Float fallDistance;

    public PacketPlayerFallDistanceUpdate(UUID player, Float fallDistance) {
        this.player = player;
        this.fallDistance = fallDistance;
    }

    public static void encode(PacketPlayerFallDistanceUpdate msg, PacketBuffer buf) {
        buf.func_179252_a(msg.player);
        buf.writeFloat(msg.fallDistance.floatValue());
    }

    public static PacketPlayerFallDistanceUpdate decode(PacketBuffer buf) {
        UUID player = buf.func_179253_g();
        Float fallDistance = Float.valueOf(buf.readFloat());
        return new PacketPlayerFallDistanceUpdate(player, fallDistance);
    }

    public static void handle(PacketPlayerFallDistanceUpdate msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            Float fallDistance = msg.fallDistance;
            PlayerFallDistanceUpdateHandler.handlePlayerFallDistanceUpdate(player, fallDistance);
        });
        ctx.get().setPacketHandled(true);
    }
}

