/*
 * Decompiled with CFR 0.152.
 */
package com.Rolfmao.upgradednetherite.utils;

import com.Rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.Rolfmao.upgradednetherite.config.UpgradedNetheriteServerConfig;
import com.Rolfmao.upgradednetherite.init.ModItems;
import com.Rolfmao.upgradednetherite.utils.enums.ModArmorMaterial;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class StuffChecker {
    public static Integer CheckGoldSet() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerUpgradedPlayerGoldArmorRequireSet;
        }
        return (Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.UpgradedPlayerGoldArmorRequireSet.get();
    }

    public static Integer CheckFireSet() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerUpgradedPlayerFireArmorRequireSet;
        }
        return (Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.UpgradedPlayerFireArmorRequireSet.get();
    }

    public static Integer CheckEnderSet() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerUpgradedPlayerEnderArmorRequireSet;
        }
        return (Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.UpgradedPlayerEnderArmorRequireSet.get();
    }

    public static Integer CheckWaterSet() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerUpgradedPlayerWaterArmorRequireSet;
        }
        return (Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.UpgradedPlayerWaterArmorRequireSet.get();
    }

    public static Integer CheckWitherSet() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerUpgradedPlayerWitherArmorRequireSet;
        }
        return (Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.UpgradedPlayerWitherArmorRequireSet.get();
    }

    public static Integer CheckPoisonSet() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerUpgradedPlayerPoisonArmorRequireSet;
        }
        return (Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.UpgradedPlayerPoisonArmorRequireSet.get();
    }

    public static Integer CheckPhantomSet() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerUpgradedPlayerPhantomArmorRequireSet;
        }
        return (Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.UpgradedPlayerPhantomArmorRequireSet.get();
    }

    public static Integer CheckFeatherSet() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerUpgradedPlayerFeatherArmorRequireSet;
        }
        return (Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.UpgradedPlayerFeatherArmorRequireSet.get();
    }

    public static Integer CheckUltimateSet() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerUpgradedPlayerUltimateArmorRequireSet;
        }
        return (Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.UpgradedPlayerUltimateArmorRequireSet.get();
    }

    public static Boolean CheckUltimateFlyingEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableFlyingEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateFlying.get();
    }

    public static Boolean CheckUltimateNoDamageEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableNoDamageEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateNoDamage.get();
    }

    public static Boolean CheckUltimateGoldArmorEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateGoldArmorEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateGoldArmorEffect.get();
    }

    public static Boolean CheckUltimateFireArmorEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateFireArmorEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateFireArmorEffect.get();
    }

    public static Boolean CheckUltimateEnderArmorEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateEnderArmorEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateEnderArmorEffect.get();
    }

    public static Boolean CheckUltimateWaterArmorEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateWaterArmorEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateWaterArmorEffect.get();
    }

    public static Boolean CheckUltimateWitherArmorEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateWitherArmorEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateWitherArmorEffect.get();
    }

    public static Boolean CheckUltimatePoisonArmorEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimatePoisonArmorEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimatePoisonArmorEffect.get();
    }

    public static Boolean CheckUltimatePhantomArmorEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimatePhantomArmorEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimatePhantomArmorEffect.get();
    }

    public static Boolean CheckUltimateFeatherArmorEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateFeatherArmorEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateFeatherArmorEffect.get();
    }

    public static boolean isWearingArmor(PlayerEntity player, @Nonnull IArmorMaterial material, Integer ArmorSet, Boolean enableUltimate) {
        Iterable wearedList = player.func_184193_aE();
        Integer count = 0;
        for (ItemStack stack : wearedList) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem)) continue;
            ArmorItem stuff = (ArmorItem)stack.func_77973_b();
            IArmorMaterial compareMaterial = stuff.func_200880_d();
            if (enableUltimate.booleanValue()) {
                if (compareMaterial != material && compareMaterial != ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE) continue;
                count = count + 1;
                continue;
            }
            if (compareMaterial != material) continue;
            count = count + 1;
        }
        return count >= ArmorSet;
    }

    public static Integer intWearingCorrupt(PlayerEntity player) {
        Iterable wearedList = player.func_184193_aE();
        Integer count = 0;
        for (ItemStack stack : wearedList) {
            ArmorItem stuff;
            IArmorMaterial compareMaterial;
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (compareMaterial = (stuff = (ArmorItem)stack.func_77973_b()).func_200880_d()) != ModArmorMaterial.CORRUPT_UPGRADED_NETHERITE) continue;
            count = count + 1;
        }
        return count;
    }

    public static boolean isWearingGoldArmor(PlayerEntity player) {
        return StuffChecker.isWearingArmor(player, ModArmorMaterial.GOLD_UPGRADED_NETHERITE, StuffChecker.CheckGoldSet(), (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateGoldArmorEffect.get());
    }

    public static boolean isWearingFireArmor(PlayerEntity player) {
        return StuffChecker.isWearingArmor(player, ModArmorMaterial.FIRE_UPGRADED_NETHERITE, StuffChecker.CheckFireSet(), (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateFireArmorEffect.get());
    }

    public static boolean isWearingEnderArmor(PlayerEntity player) {
        return StuffChecker.isWearingArmor(player, ModArmorMaterial.ENDER_UPGRADED_NETHERITE, StuffChecker.CheckEnderSet(), (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateEnderArmorEffect.get());
    }

    public static boolean isWearingWaterArmor(PlayerEntity player) {
        return StuffChecker.isWearingArmor(player, ModArmorMaterial.WATER_UPGRADED_NETHERITE, StuffChecker.CheckWaterSet(), (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateWaterArmorEffect.get());
    }

    public static boolean isWearingWitherArmor(PlayerEntity player) {
        return StuffChecker.isWearingArmor(player, ModArmorMaterial.WITHER_UPGRADED_NETHERITE, StuffChecker.CheckWitherSet(), (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateWitherArmorEffect.get());
    }

    public static boolean isWearingPoisonArmor(PlayerEntity player) {
        return StuffChecker.isWearingArmor(player, ModArmorMaterial.POISON_UPGRADED_NETHERITE, StuffChecker.CheckPoisonSet(), (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimatePoisonArmorEffect.get());
    }

    public static boolean isWearingPhantomArmor(PlayerEntity player) {
        return StuffChecker.isWearingArmor(player, ModArmorMaterial.PHANTOM_UPGRADED_NETHERITE, StuffChecker.CheckPhantomSet(), (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimatePhantomArmorEffect.get());
    }

    public static boolean isWearingFeatherArmor(PlayerEntity player) {
        return StuffChecker.isWearingArmor(player, ModArmorMaterial.FEATHER_UPGRADED_NETHERITE, StuffChecker.CheckFeatherSet(), (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateFeatherArmorEffect.get());
    }

    public static boolean isWearingUltimateArmor(PlayerEntity player) {
        return StuffChecker.isWearingArmor(player, ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE, StuffChecker.CheckUltimateSet(), false);
    }

    public static boolean isHorseWearing(HorseEntity horse, @Nonnull Item item) {
        Iterable armorList = horse.func_184193_aE();
        for (ItemStack stack : armorList) {
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static Boolean CheckUltimateInstaKillEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableInstaKillEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateInstaKill.get();
    }

    public static Boolean CheckUltimateGoldToolEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateGoldToolEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateGoldToolEffect.get();
    }

    public static Boolean CheckUltimateFireToolEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateFireToolEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateFireToolEffect.get();
    }

    public static Boolean CheckUltimateEnderToolEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateEnderToolEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateEnderToolEffect.get();
    }

    public static Boolean CheckUltimateWaterToolEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateWaterToolEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateWaterToolEffect.get();
    }

    public static Boolean CheckUltimateWitherToolEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateWitherToolEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateWitherToolEffect.get();
    }

    public static Boolean CheckUltimatePoisonToolEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimatePoisonToolEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimatePoisonToolEffect.get();
    }

    public static Boolean CheckUltimatePhantomToolEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimatePhantomToolEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimatePhantomToolEffect.get();
    }

    public static Boolean CheckUltimateFeatherToolEffect() {
        if (UpgradedNetheriteServerConfig.ServerUpgradedRequireSetSend) {
            return UpgradedNetheriteServerConfig.ServerEnableUltimateFeatherToolEffect;
        }
        return (Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableUltimateFeatherToolEffect.get();
    }

    public static boolean isUsingGoldWeapon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.GOLD_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.GOLD_UPGRADED_NETHERITE_AXE.get())) || StuffChecker.CheckUltimateGoldToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())));
    }

    public static boolean isUsingGoldTool(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.GOLD_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.GOLD_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.GOLD_UPGRADED_NETHERITE_AXE.get())) || StuffChecker.CheckUltimateGoldToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())));
    }

    public static boolean isUsingFireWeapon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.FIRE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.FIRE_UPGRADED_NETHERITE_AXE.get())) || StuffChecker.CheckUltimateFireToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())));
    }

    public static boolean isUsingEnderWeapon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_AXE.get())) || StuffChecker.CheckUltimateEnderToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())));
    }

    public static boolean isUsingEnderTool(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_AXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_BOW.get())) || StuffChecker.CheckUltimateEnderToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_BOW.get())));
    }

    public static boolean isUsingWaterWeapon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.WATER_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.WATER_UPGRADED_NETHERITE_AXE.get())) || StuffChecker.CheckUltimateWaterToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())));
    }

    public static boolean isUsingWaterTool(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.WATER_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.WATER_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.WATER_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.WATER_UPGRADED_NETHERITE_AXE.get())) || StuffChecker.CheckUltimateWaterToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_BOW.get())));
    }

    public static boolean isUsingWitherWeapon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.WITHER_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.WITHER_UPGRADED_NETHERITE_AXE.get())) || StuffChecker.CheckUltimateWitherToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())));
    }

    public static boolean isUsingPoisonWeapon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.POISON_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.POISON_UPGRADED_NETHERITE_AXE.get())) || StuffChecker.CheckUltimatePoisonToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())));
    }

    public static boolean isUsingPhantomWeapon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.PHANTOM_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.PHANTOM_UPGRADED_NETHERITE_AXE.get())) || StuffChecker.CheckUltimatePhantomToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())));
    }

    public static boolean isUsingPhantomTool(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.PHANTOM_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.PHANTOM_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.PHANTOM_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.PHANTOM_UPGRADED_NETHERITE_AXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.PHANTOM_UPGRADED_NETHERITE_BOW.get())) || StuffChecker.CheckUltimatePhantomToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_BOW.get())));
    }

    public static boolean isUsingFeatherTool(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.FEATHER_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.FEATHER_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.FEATHER_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.FEATHER_UPGRADED_NETHERITE_AXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.FEATHER_UPGRADED_NETHERITE_BOW.get())) || StuffChecker.CheckUltimateFeatherToolEffect() != false && (ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_BOW.get())));
    }

    public static boolean isUsingUltimateWeapon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_AXE.get()));
    }

    public static boolean isUsingCorruptWeapon(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.CORRUPT_UPGRADED_NETHERITE_SWORD.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.CORRUPT_UPGRADED_NETHERITE_AXE.get()));
    }

    public static boolean isUsingCorruptTool(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        return ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.CORRUPT_UPGRADED_NETHERITE_PICKAXE.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.CORRUPT_UPGRADED_NETHERITE_SHOVEL.get())) || ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)new ItemStack((IItemProvider)ModItems.CORRUPT_UPGRADED_NETHERITE_AXE.get()));
    }

    public static void FireDurabilityLoss(PlayerEntity player) {
        if (((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableDamageDurabilityFireArmor.get()).booleanValue() && !StuffChecker.hasFireDurabilityCooldown(player)) {
            player.getPersistentData().func_74768_a("upgraded_netherite_fire_durability_loss", ((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DelayDamageDurabilityFireArmor.get()).intValue());
            Iterable armorList = player.func_184193_aE();
            for (ItemStack stack : armorList) {
                ArmorItem stuff;
                IArmorMaterial compareMaterial;
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (compareMaterial = (stuff = (ArmorItem)stack.func_77973_b()).func_200880_d()) != ModArmorMaterial.FIRE_UPGRADED_NETHERITE && (!StuffChecker.CheckUltimateFireArmorEffect().booleanValue() || compareMaterial != ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE)) continue;
                stack.func_222118_a(((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DamageDurabilityFireArmor.get()).intValue(), (LivingEntity)player, e -> e.func_213361_c(((ArmorItem)stack.func_77973_b()).func_185083_B_()));
            }
        }
    }

    public static void WaterDurabilityLoss(PlayerEntity player) {
        if (((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableDamageDurabilityWaterArmor.get()).booleanValue() && !StuffChecker.hasWaterDurabilityCooldown(player)) {
            player.getPersistentData().func_74768_a("upgraded_netherite_water_durability_loss", ((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DelayDamageDurabilityWaterArmor.get()).intValue());
            Iterable armorList = player.func_184193_aE();
            for (ItemStack stack : armorList) {
                ArmorItem stuff;
                IArmorMaterial compareMaterial;
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (compareMaterial = (stuff = (ArmorItem)stack.func_77973_b()).func_200880_d()) != ModArmorMaterial.WATER_UPGRADED_NETHERITE && (!StuffChecker.CheckUltimateWaterArmorEffect().booleanValue() || compareMaterial != ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE)) continue;
                stack.func_222118_a(((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DamageDurabilityWaterArmor.get()).intValue(), (LivingEntity)player, livingEntity -> livingEntity.func_213361_c(((ArmorItem)stack.func_77973_b()).func_185083_B_()));
            }
        }
    }

    public static void WitherDurabilityLoss(PlayerEntity player) {
        if (((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableDamageDurabilityWitherArmor.get()).booleanValue() && !StuffChecker.hasWitherDurabilityCooldown(player)) {
            player.getPersistentData().func_74768_a("upgraded_netherite_wither_durability_loss", ((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DelayDamageDurabilityWitherArmor.get()).intValue());
            Iterable armorList = player.func_184193_aE();
            for (ItemStack stack : armorList) {
                ArmorItem stuff;
                IArmorMaterial compareMaterial;
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (compareMaterial = (stuff = (ArmorItem)stack.func_77973_b()).func_200880_d()) != ModArmorMaterial.WITHER_UPGRADED_NETHERITE && (!StuffChecker.CheckUltimateWitherArmorEffect().booleanValue() || compareMaterial != ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE)) continue;
                stack.func_222118_a(((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DamageDurabilityWitherArmor.get()).intValue(), (LivingEntity)player, livingEntity -> livingEntity.func_213361_c(((ArmorItem)stack.func_77973_b()).func_185083_B_()));
            }
        }
    }

    public static void PoisonDurabilityLoss(PlayerEntity player) {
        if (((Boolean)UpgradedNetheriteConfig.ARMOR_OPTIONS.EnableDamageDurabilityPoisonArmor.get()).booleanValue() && !StuffChecker.hasPoisonDurabilityCooldown(player)) {
            player.getPersistentData().func_74768_a("upgraded_netherite_poison_durability_loss", ((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DelayDamageDurabilityPoisonArmor.get()).intValue());
            Iterable armorList = player.func_184193_aE();
            for (ItemStack stack : armorList) {
                ArmorItem stuff;
                IArmorMaterial compareMaterial;
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (compareMaterial = (stuff = (ArmorItem)stack.func_77973_b()).func_200880_d()) != ModArmorMaterial.POISON_UPGRADED_NETHERITE && (!StuffChecker.CheckUltimatePoisonArmorEffect().booleanValue() || compareMaterial != ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE)) continue;
                stack.func_222118_a(((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DamageDurabilityPoisonArmor.get()).intValue(), (LivingEntity)player, livingEntity -> livingEntity.func_213361_c(((ArmorItem)stack.func_77973_b()).func_185083_B_()));
            }
        }
    }

    public static void FeatherDurabilityLoss(PlayerEntity player) {
        if (!StuffChecker.hasFeatherDurabilityCooldown(player)) {
            player.getPersistentData().func_74768_a("upgraded_netherite_feather_durability_loss", ((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DelayDamageDurabilityFeatherArmor.get()).intValue());
            Iterable armorList = player.func_184193_aE();
            for (ItemStack stack : armorList) {
                ArmorItem stuff;
                IArmorMaterial compareMaterial;
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (compareMaterial = (stuff = (ArmorItem)stack.func_77973_b()).func_200880_d()) != ModArmorMaterial.FEATHER_UPGRADED_NETHERITE && (!StuffChecker.CheckUltimateFeatherArmorEffect().booleanValue() || compareMaterial != ModArmorMaterial.ULTIMATE_UPGRADED_NETHERITE)) continue;
                stack.func_222118_a(((Integer)UpgradedNetheriteConfig.ARMOR_OPTIONS.DamageDurabilityFeatherArmor.get()).intValue(), (LivingEntity)player, livingEntity -> livingEntity.func_213361_c(((ArmorItem)stack.func_77973_b()).func_185083_B_()));
            }
        }
    }

    public static void CorruptDurabilityGain(PlayerEntity player) {
        if (!StuffChecker.hasCorruptDurabilityCooldown(player) && !player.field_70170_p.field_72995_K && player.func_71024_bL().func_75116_a() >= 1) {
            ArrayList<ItemStack> CorruptList = new ArrayList<ItemStack>();
            Iterable wearedList = player.func_184193_aE();
            for (ItemStack stack : wearedList) {
                ArmorItem stuff;
                IArmorMaterial compareMaterial;
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (compareMaterial = (stuff = (ArmorItem)stack.func_77973_b()).func_200880_d()) != ModArmorMaterial.CORRUPT_UPGRADED_NETHERITE || stack.func_77952_i() <= 0) continue;
                CorruptList.add(stack);
            }
            if ((StuffChecker.isUsingCorruptTool(player) || StuffChecker.isUsingCorruptWeapon(player) || ItemStack.func_185132_d((ItemStack)player.func_184614_ca(), (ItemStack)new ItemStack((IItemProvider)ModItems.CORRUPT_UPGRADED_NETHERITE_BOW.get()))) && player.func_184614_ca().func_77952_i() > 0) {
                CorruptList.add(player.func_184614_ca());
            }
            if (CorruptList.size() <= 0) {
                return;
            }
            int durability = 40;
            do {
                int IRNG;
                ItemStack stack;
                if ((stack = (ItemStack)CorruptList.get(IRNG = player.func_70681_au().nextInt(CorruptList.size()))).func_77952_i() < 1) continue;
                player.func_71020_j(0.1f);
                stack.func_196085_b(stack.func_77952_i() - 1);
                if (stack.func_77952_i() == 0) {
                    CorruptList.remove(stack);
                }
                --durability;
            } while (durability > 0 && !CorruptList.isEmpty());
            player.getPersistentData().func_74768_a("upgraded_netherite_corrupt_durability_gain", 100);
        }
    }

    public static void tickDurabilityCooldown(PlayerEntity player) {
        if (player.getPersistentData().func_74764_b("upgraded_netherite_fire_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_fire_durability_loss") > 0) {
            player.getPersistentData().func_74776_a("upgraded_netherite_fire_durability_loss", (float)(player.getPersistentData().func_74762_e("upgraded_netherite_fire_durability_loss") - 1));
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_fire_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_fire_durability_loss") <= 0) {
            player.getPersistentData().func_82580_o("upgraded_netherite_fire_durability_loss");
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_water_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_water_durability_loss") > 0) {
            player.getPersistentData().func_74776_a("upgraded_netherite_water_durability_loss", (float)(player.getPersistentData().func_74762_e("upgraded_netherite_water_durability_loss") - 1));
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_water_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_water_durability_loss") <= 0) {
            player.getPersistentData().func_82580_o("upgraded_netherite_water_durability_loss");
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_wither_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_wither_durability_loss") > 0) {
            player.getPersistentData().func_74776_a("upgraded_netherite_wither_durability_loss", (float)(player.getPersistentData().func_74762_e("upgraded_netherite_wither_durability_loss") - 1));
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_wither_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_wither_durability_loss") <= 0) {
            player.getPersistentData().func_82580_o("upgraded_netherite_wither_durability_loss");
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_poison_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_poison_durability_loss") > 0) {
            player.getPersistentData().func_74776_a("upgraded_netherite_poison_durability_loss", (float)(player.getPersistentData().func_74762_e("upgraded_netherite_poison_durability_loss") - 1));
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_poison_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_poison_durability_loss") <= 0) {
            player.getPersistentData().func_82580_o("upgraded_netherite_poison_durability_loss");
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_feather_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_feather_durability_loss") > 0) {
            player.getPersistentData().func_74776_a("upgraded_netherite_feather_durability_loss", (float)(player.getPersistentData().func_74762_e("upgraded_netherite_feather_durability_loss") - 1));
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_feather_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_feather_durability_loss") <= 0) {
            player.getPersistentData().func_82580_o("upgraded_netherite_feather_durability_loss");
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_corrupt_durability_gain") && player.getPersistentData().func_74762_e("upgraded_netherite_corrupt_durability_gain") > 0) {
            player.getPersistentData().func_74776_a("upgraded_netherite_corrupt_durability_gain", (float)(player.getPersistentData().func_74762_e("upgraded_netherite_corrupt_durability_gain") - 1));
        }
        if (player.getPersistentData().func_74764_b("upgraded_netherite_corrupt_durability_gain") && player.getPersistentData().func_74762_e("upgraded_netherite_corrupt_durability_gain") <= 0) {
            player.getPersistentData().func_82580_o("upgraded_netherite_corrupt_durability_gain");
        }
    }

    public static boolean hasFireDurabilityCooldown(PlayerEntity player) {
        return player.getPersistentData().func_74764_b("upgraded_netherite_fire_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_fire_durability_loss") > 0;
    }

    public static boolean hasWaterDurabilityCooldown(PlayerEntity player) {
        return player.getPersistentData().func_74764_b("upgraded_netherite_water_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_water_durability_loss") > 0;
    }

    public static boolean hasWitherDurabilityCooldown(PlayerEntity player) {
        return player.getPersistentData().func_74764_b("upgraded_netherite_wither_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_wither_durability_loss") > 0;
    }

    public static boolean hasPoisonDurabilityCooldown(PlayerEntity player) {
        return player.getPersistentData().func_74764_b("upgraded_netherite_poison_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_poison_durability_loss") > 0;
    }

    public static boolean hasFeatherDurabilityCooldown(PlayerEntity player) {
        return player.getPersistentData().func_74764_b("upgraded_netherite_feather_durability_loss") && player.getPersistentData().func_74762_e("upgraded_netherite_feather_durability_loss") > 0;
    }

    public static boolean hasCorruptDurabilityCooldown(PlayerEntity player) {
        return player.getPersistentData().func_74764_b("upgraded_netherite_corrupt_durability_gain") && player.getPersistentData().func_74762_e("upgraded_netherite_corrupt_durability_gain") > 0;
    }
}

