/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.proxy.block.network;

import com.buuz135.refinedstoragerequestify.proxy.block.tile.TileRequester;
import com.buuz135.refinedstoragerequestify.proxy.config.RequestifyConfig;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeRequester
extends NetworkNode
implements IType {
    public static final ResourceLocation ID = new ResourceLocation("rsrequestify", "requester");
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilter";
    private static final String NBT_AMOUNT = "Amount";
    private static final String NBT_MISSING = "MissingItems";
    private BaseItemHandler itemFilter = new BaseItemHandler(1).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private FluidInventory fluidFilter = new FluidInventory(1).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private int type = 0;
    private int amount = 0;
    private boolean isMissingItems = false;
    private ICraftingTask craftingTask = null;

    public NetworkNodeRequester(World world, BlockPos pos) {
        super(world, pos);
    }

    public void update() {
        super.update();
        if (this.network == null) {
            return;
        }
        if (this.canUpdate() && this.ticks % 10 == 0 && (this.craftingTask == null || !this.network.getCraftingManager().getTasks().contains(this.craftingTask))) {
            int count;
            ItemStack current;
            ItemStack filter;
            if (this.type == 0 && !(filter = this.itemFilter.getStackInSlot(0)).func_190926_b()) {
                current = this.network.extractItem(filter, this.amount, Action.SIMULATE);
                if (current == null || current.func_190926_b() || current.func_190916_E() < this.amount) {
                    int n = count = current == null || current.func_190926_b() ? this.amount : this.amount - current.func_190916_E();
                    if (count > 0) {
                        this.craftingTask = this.network.getCraftingManager().request((Object)this, filter, Math.min(RequestifyConfig.MAX_CRAFT_AMOUNT, count));
                        this.isMissingItems = true;
                    }
                } else {
                    this.isMissingItems = false;
                }
            }
            if (this.type == 1 && !(filter = this.fluidFilter.getFluid(0)).isEmpty()) {
                current = this.network.extractFluid((FluidStack)filter, this.amount, Action.SIMULATE);
                if (current.isEmpty() || current.getAmount() < this.amount) {
                    int n = count = current.isEmpty() ? this.amount : this.amount - current.getAmount();
                    if (count > 0) {
                        this.craftingTask = this.network.getCraftingManager().request((Object)this, (FluidStack)filter, count);
                        this.isMissingItems = true;
                    }
                } else {
                    this.isMissingItems = false;
                }
            }
        }
    }

    public int getEnergyUsage() {
        return 10;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)TileRequester.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.markDirty();
    }

    public boolean isMissingItems() {
        return this.isMissingItems && this.craftingTask == null;
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilter;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilter;
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.itemFilter, (int)0, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_AMOUNT)) {
            this.amount = tag.func_74762_e(NBT_AMOUNT);
        }
        if (tag.func_74764_b(NBT_MISSING)) {
            this.isMissingItems = tag.func_74767_n(NBT_MISSING);
        }
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilter, (int)0, (CompoundNBT)tag);
        tag.func_74768_a(NBT_AMOUNT, this.amount);
        tag.func_74757_a(NBT_MISSING, this.isMissingItems);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilter, (int)0, (CompoundNBT)tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilter.writeToNbt());
        tag.func_74768_a(NBT_AMOUNT, this.amount);
        tag.func_74757_a(NBT_MISSING, this.isMissingItems);
        return tag;
    }

    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilter, (int)0, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilter.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
        if (tag.func_74764_b(NBT_AMOUNT)) {
            this.amount = tag.func_74762_e(NBT_AMOUNT);
        }
        if (tag.func_74764_b(NBT_MISSING)) {
            this.isMissingItems = tag.func_74767_n(NBT_MISSING);
        }
    }
}

