/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.bgcore.common.world;

import com.blackgear.bgcore.common.world.features.carver.BGConfiguredCarvers;
import com.blackgear.bgcore.core.BGConfig;
import com.blackgear.bgcore.core.api.FeaturePlacement;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;

public class VanillaBiomeFeatures {
    public static void addNoiseCarvers(BiomeGenerationSettings.Builder builder) {
        if (((Boolean)BGConfig.noiseCaveSpawning.get()).booleanValue()) {
            FeaturePlacement.addCarver(builder, GenerationStage.Carving.AIR, BGConfiguredCarvers.NOISE_CARVER);
        }
    }

    public static void addUnderwaterNoiseCarvers(BiomeGenerationSettings.Builder builder) {
        if (((Boolean)BGConfig.noiseCaveSpawning.get()).booleanValue()) {
            FeaturePlacement.addCarver(builder, GenerationStage.Carving.LIQUID, BGConfiguredCarvers.UNDERWATER_NOISE_CARVER);
        }
    }

    public static void addCaveSpawns(MobSpawnInfo.Builder builder) {
        FeaturePlacement.addSpawn(builder, EntityClassification.AMBIENT, EntityType.field_200791_e, 10, 8, 8);
    }

    public static void addCommonSpawns(MobSpawnInfo.Builder builder) {
        VanillaBiomeFeatures.addCaveSpawns(builder);
        VanillaBiomeFeatures.addMonsters(builder, 95, 5, 100);
    }

    public static void addMonsters(MobSpawnInfo.Builder builder, int zombieWeight, int zombieVillagerWeight, int skeletonWeight) {
        FeaturePlacement.addSpawn(builder, EntityClassification.MONSTER, EntityType.field_200748_an, 100, 4, 4);
        FeaturePlacement.addSpawn(builder, EntityClassification.MONSTER, EntityType.field_200725_aD, zombieWeight, 4, 4);
        FeaturePlacement.addSpawn(builder, EntityClassification.MONSTER, EntityType.field_200727_aF, zombieVillagerWeight, 1, 1);
        FeaturePlacement.addSpawn(builder, EntityClassification.MONSTER, EntityType.field_200741_ag, skeletonWeight, 4, 4);
        FeaturePlacement.addSpawn(builder, EntityClassification.MONSTER, EntityType.field_200797_k, 100, 4, 4);
        FeaturePlacement.addSpawn(builder, EntityClassification.MONSTER, EntityType.field_200743_ai, 100, 4, 4);
        FeaturePlacement.addSpawn(builder, EntityClassification.MONSTER, EntityType.field_200803_q, 100, 1, 4);
        FeaturePlacement.addSpawn(builder, EntityClassification.MONSTER, EntityType.field_200759_ay, 5, 1, 1);
    }
}

