/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.bgcore.common.world.biome.provider;

import com.blackgear.bgcore.common.world.biome.provider.AddBiomeLayer;
import com.blackgear.bgcore.core.BGConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;

public class CaveLayerUtil {
    public static final List<Biome> defaultCaveBiomes = new ArrayList<Biome>();
    public static final List<Biome> desertCaveBiomes = new ArrayList<Biome>();
    public static final List<Biome> icyCaveBiomes = new ArrayList<Biome>();
    public static final List<Biome> jungleCaveBiomes = new ArrayList<Biome>();
    public static final List<Biome> oceanCaveBiomes = new ArrayList<Biome>();

    public static Layer stackDefaultCaveLayers(long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory biomeFactory = new AddBiomeLayer(defaultCaveBiomes).func_202823_a(randomProvider.apply(485868686L));
        for (int caveBiomeSize = 0; caveBiomeSize <= (Integer)BGConfig.caveBiomeSize.get(); ++caveBiomeSize) {
            biomeFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(28585L + (long)caveBiomeSize), biomeFactory);
        }
        biomeFactory = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(958687L), biomeFactory);
        return new Layer(biomeFactory);
    }

    public static Layer stackDesertCaveLayers(long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory biomeFactory = new AddBiomeLayer(desertCaveBiomes).func_202823_a(randomProvider.apply(485868686L));
        for (int caveBiomeSize = 0; caveBiomeSize <= (Integer)BGConfig.caveBiomeSize.get(); ++caveBiomeSize) {
            biomeFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(28585L + (long)caveBiomeSize), biomeFactory);
        }
        biomeFactory = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(958687L), biomeFactory);
        return new Layer(biomeFactory);
    }

    public static Layer stackIcyCaveLayers(long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory biomeFactory = new AddBiomeLayer(icyCaveBiomes).func_202823_a(randomProvider.apply(485868686L));
        for (int caveBiomeSize = 0; caveBiomeSize <= (Integer)BGConfig.caveBiomeSize.get(); ++caveBiomeSize) {
            biomeFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(28585L + (long)caveBiomeSize), biomeFactory);
        }
        biomeFactory = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(958687L), biomeFactory);
        return new Layer(biomeFactory);
    }

    public static Layer stackJungleCaveLayers(long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory biomeFactory = new AddBiomeLayer(jungleCaveBiomes).func_202823_a(randomProvider.apply(485868686L));
        for (int caveBiomeSize = 0; caveBiomeSize <= (Integer)BGConfig.caveBiomeSize.get(); ++caveBiomeSize) {
            biomeFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(28585L + (long)caveBiomeSize), biomeFactory);
        }
        biomeFactory = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(958687L), biomeFactory);
        return new Layer(biomeFactory);
    }

    public static Layer stackOceanCaveLayers(long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory biomeFactory = new AddBiomeLayer(oceanCaveBiomes).func_202823_a(randomProvider.apply(485868686L));
        for (int caveBiomeSize = 0; caveBiomeSize <= (Integer)BGConfig.caveBiomeSize.get(); ++caveBiomeSize) {
            biomeFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(28585L + (long)caveBiomeSize), biomeFactory);
        }
        biomeFactory = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(958687L), biomeFactory);
        return new Layer(biomeFactory);
    }
}

