/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.bgcore.core.api;

import com.blackgear.bgcore.common.world.biome.provider.CaveLayerUtil;
import com.blackgear.bgcore.core.BGConfig;
import com.blackgear.bgcore.core.registries.BGBiomes;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.Layer;

public class CaveBiomeManager {
    private static Layer defaultCaveLayer;
    private static Layer desertCaveLayer;
    private static Layer icyCaveLayer;
    private static Layer jungleCaveLayer;
    private static Layer oceanCaveLayer;

    public static void initializeCaveBiomes(long seed) {
        defaultCaveLayer = CaveLayerUtil.stackDefaultCaveLayers(seed);
        desertCaveLayer = CaveLayerUtil.stackDesertCaveLayers(seed);
        icyCaveLayer = CaveLayerUtil.stackIcyCaveLayers(seed);
        jungleCaveLayer = CaveLayerUtil.stackJungleCaveLayers(seed);
        oceanCaveLayer = CaveLayerUtil.stackOceanCaveLayers(seed);
    }

    public static Biome injectCaveBiomes(Biome biome, Registry<Biome> lookupRegistry, int x, int y, int z) {
        if (((Boolean)BGConfig.caveBiomeSpawning.get()).booleanValue()) {
            if (y >= 12 || y <= 1) {
                return biome;
            }
            if (biome.func_201856_r() == Biome.Category.DESERT || biome.func_201856_r() == Biome.Category.MESA) {
                return desertCaveLayer.func_242936_a(lookupRegistry, x, z);
            }
            if (biome.func_201856_r() == Biome.Category.ICY) {
                return icyCaveLayer.func_242936_a(lookupRegistry, x, z);
            }
            if (biome.func_201856_r() == Biome.Category.JUNGLE) {
                return jungleCaveLayer.func_242936_a(lookupRegistry, x, z);
            }
            if (biome.func_201856_r() == Biome.Category.OCEAN) {
                return oceanCaveLayer.func_242936_a(lookupRegistry, x, z);
            }
            return defaultCaveLayer.func_242936_a(lookupRegistry, x, z);
        }
        return biome;
    }

    public static void addCaveBiome(Biome.Category categoryIn, Biome biomeIn) {
        if (categoryIn == Biome.Category.DESERT || categoryIn == Biome.Category.MESA) {
            CaveLayerUtil.desertCaveBiomes.add(biomeIn);
        } else if (categoryIn == Biome.Category.ICY) {
            CaveLayerUtil.icyCaveBiomes.add(biomeIn);
        } else if (categoryIn == Biome.Category.JUNGLE) {
            CaveLayerUtil.jungleCaveBiomes.add(biomeIn);
        } else if (categoryIn == Biome.Category.OCEAN) {
            CaveLayerUtil.oceanCaveBiomes.add(biomeIn);
        } else {
            CaveLayerUtil.defaultCaveBiomes.add(biomeIn);
        }
    }

    public static void addCaveBiome(Biome biomeIn) {
        CaveBiomeManager.addCaveBiome(Biome.Category.NONE, biomeIn);
    }

    public static void addLandOnlyCave(Biome biomeIn) {
        CaveBiomeManager.addCaveBiome(biomeIn);
        CaveBiomeManager.addCaveBiome(Biome.Category.DESERT, biomeIn);
        CaveBiomeManager.addCaveBiome(Biome.Category.ICY, biomeIn);
        CaveBiomeManager.addCaveBiome(Biome.Category.JUNGLE, biomeIn);
    }

    public static void addGlobalCave(Biome biomeIn) {
        CaveBiomeManager.addLandOnlyCave(biomeIn);
        CaveBiomeManager.addCaveBiome(Biome.Category.OCEAN, biomeIn);
    }

    public static void addDefaultCaves() {
        CaveBiomeManager.addGlobalCave((Biome)BGBiomes.DEFAULT_CAVE.get());
    }
}

