/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.bgcore.core.api;

import com.blackgear.bgcore.core.api.Registries;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.fml.RegistryObject;

public class CoreRegistries
extends Registries {
    public CoreRegistries(String modId) {
        super(modId);
    }

    public RegistryObject<SoundEvent> registerSoundEvent(String key) {
        return this.getSoundEvents().register(key, () -> new SoundEvent(new ResourceLocation(this.id, key)));
    }

    public <E extends Effect> RegistryObject<E> registerEffect(String key, Supplier<? extends E> effect) {
        return this.getEffects().register(key, effect);
    }

    public <B extends Block> RegistryObject<B> registerBlock(String key, Supplier<? extends B> block) {
        return this.getBlocks().register(key, block);
    }

    public <B extends Block> RegistryObject<B> registerBlock(String key, Supplier<? extends B> block, ItemGroup group) {
        RegistryObject blocks = this.blocks.register(key, block);
        this.items.register(key, () -> new BlockItem((Block)blocks.get(), new Item.Properties().func_200916_a(group)));
        return blocks;
    }

    public <E extends Enchantment> RegistryObject<E> registerEnchantment(String key, Supplier<? extends E> enchantment) {
        return this.getEnchantments().register(key, enchantment);
    }

    public <E extends Entity> RegistryObject<EntityType<E>> registerEntity(String key, EntityType.Builder<E> builder) {
        return this.getEntityTypes().register(key, () -> builder.func_206830_a(new ResourceLocation(this.id, key).toString()));
    }

    public <I extends Item> RegistryObject<I> registerItem(String key, Supplier<? extends I> item) {
        return this.getItems().register(key, item);
    }

    public <C extends ICarverConfig, W extends WorldCarver<C>> RegistryObject<W> registerCarver(String key, Supplier<? extends W> carver) {
        return this.getCarvers().register(key, carver);
    }

    public <C extends ICarverConfig, CC extends ConfiguredCarver<C>> CC registerConfiguredCarver(String key, CC configuredFeature) {
        ResourceLocation ID = new ResourceLocation(this.id, key);
        if (WorldGenRegistries.field_243652_d.func_148742_b().contains(ID)) {
            throw new IllegalStateException("The Configured Carver " + key + "already exists in the registry");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243652_d, (ResourceLocation)ID, configuredFeature);
        return configuredFeature;
    }

    public <C extends ISurfaceBuilderConfig, S extends SurfaceBuilder<C>> RegistryObject<S> registerSurfaceBuilder(String key, Supplier<? extends S> surfaceBuilder) {
        return this.getSurfaceBuilders().register(key, surfaceBuilder);
    }

    public <C extends IFeatureConfig, F extends Feature<C>> RegistryObject<F> registerFeature(String key, Supplier<? extends F> feature) {
        return this.getFeatures().register(key, feature);
    }

    public <C extends IFeatureConfig, F extends Feature<C>, CF extends ConfiguredFeature<C, F>> CF registerConfiguredFeature(String key, CF configuredFeature) {
        ResourceLocation ID = new ResourceLocation(this.id, key);
        if (WorldGenRegistries.field_243653_e.func_148742_b().contains(ID)) {
            throw new IllegalStateException("The Configured Feature " + key + "already exists in the registry");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ID, configuredFeature);
        return configuredFeature;
    }

    public <C extends IPlacementConfig, P extends Placement<C>> RegistryObject<P> registerPlacement(String key, Supplier<? extends P> placement) {
        return this.getPlacements().register(key, placement);
    }

    public <B extends Biome> RegistryObject<B> registerBiome(String key, Supplier<? extends B> biome) {
        return this.getBiomes().register(key, biome);
    }

    public RegistryObject<BasicParticleType> registerParticle(String key, boolean alwaysShow) {
        return this.getParticleTypes().register(key, () -> new BasicParticleType(alwaysShow));
    }

    public ITag.INamedTag<Block> registerBlockTag(String key) {
        return BlockTags.func_199894_a((String)new ResourceLocation(this.id, key).toString());
    }

    public ITag.INamedTag<Item> registerItemTag(String key) {
        return ItemTags.func_199901_a((String)new ResourceLocation(this.id, key).toString());
    }

    public ITag.INamedTag<Fluid> registerFluidTag(String key) {
        return FluidTags.func_206956_a((String)new ResourceLocation(this.id, key).toString());
    }

    public ITag.INamedTag<EntityType<?>> registerEntityTag(String key) {
        return EntityTypeTags.func_232896_a_((String)new ResourceLocation(this.id, key).toString());
    }
}

