/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.bgcore.core.api;

import com.blackgear.bgcore.common.world.VanillaBiomeFeatures;
import com.blackgear.bgcore.core.registries.BGBiomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class GlobalBiomeFeatures {
    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER || event.getCategory() == Biome.Category.THEEND) {
            return;
        }
        if (event.getName() == null) {
            return;
        }
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (biome == BGBiomes.DEFAULT_CAVE.get()) {
            VanillaBiomeFeatures.addCommonSpawns((MobSpawnInfo.Builder)spawns);
        }
        if (event.getCategory() == Biome.Category.OCEAN) {
            VanillaBiomeFeatures.addUnderwaterNoiseCarvers((BiomeGenerationSettings.Builder)generation);
        } else {
            VanillaBiomeFeatures.addNoiseCarvers((BiomeGenerationSettings.Builder)generation);
        }
    }
}

