/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.init;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.world.carver.BetterCavesCarver;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.EmptyCarverConfig;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class BCCarver {
    public static final WorldCarver<EmptyCarverConfig> BETTERCAVES_CARVER = new BetterCavesCarver();
    public static final ConfiguredCarver<EmptyCarverConfig> CONFIGURED_BETTERCAVES_CARVER = new ConfiguredCarver(BETTERCAVES_CARVER, (ICarverConfig)EmptyCarverConfig.field_236238_c_);

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(WorldCarver.class, BCCarver::registerCarver);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, BCCarver::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(BCCarver::worldUnload);
    }

    public static void registerCarver(RegistryEvent.Register<WorldCarver<?>> event) {
        event.getRegistry().register(BETTERCAVES_CARVER.setRegistryName(new ResourceLocation("bettercaves", "bettercaves")));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243652_d, (ResourceLocation)new ResourceLocation("bettercaves", "bettercaves"), CONFIGURED_BETTERCAVES_CARVER);
    }

    private static void onBiomeLoad(BiomeLoadingEvent event) {
        ArrayList defaultAirCarvers = new ArrayList(event.getGeneration().getCarvers(GenerationStage.Carving.AIR));
        ArrayList defaultLiquidCarvers = new ArrayList(event.getGeneration().getCarvers(GenerationStage.Carving.LIQUID));
        if (event.getName() == null) {
            BetterCaves.LOGGER.error("Found missing name when loading biome. This shouldn't happen! Aborting...");
            return;
        }
        String biomeName = event.getName().toString();
        BetterCaves.defaultBiomeAirCarvers.put(biomeName, defaultAirCarvers);
        BetterCaves.defaultBiomeLiquidCarvers.put(biomeName, defaultLiquidCarvers);
        event.getGeneration().getCarvers(GenerationStage.Carving.AIR).clear();
        event.getGeneration().getCarvers(GenerationStage.Carving.LIQUID).clear();
        event.getGeneration().getCarvers(GenerationStage.Carving.AIR).add(() -> CONFIGURED_BETTERCAVES_CARVER);
    }

    public static void worldUnload(WorldEvent.Unload event) {
        BetterCaves.LOGGER.debug("UNLOADING WORLD");
        try {
            String key = Objects.requireNonNull(((World)event.getWorld()).func_234923_W_().func_240901_a_()).toString();
            BetterCaves.activeCarversMap.remove(key);
        }
        catch (NullPointerException e) {
            BetterCaves.LOGGER.error("ERROR: Unable to unload carver for dimension!");
        }
    }
}

