/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.api.capability;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Perk
extends ForgeRegistryEntry<Perk>
implements Comparable<Perk>,
IStringSerializable {
    protected final String name;
    protected final ResourceLocation icon;
    private ITextComponent translation;

    public Perk(String name, @Nullable ResourceLocation icon) {
        this.name = name;
        this.icon = icon;
    }

    public abstract int getLevelMax();

    public boolean isDisabled(@Nullable PlayerEntity player) {
        return false;
    }

    public abstract ITextComponent getTooltip(int var1, int var2, int var3);

    public abstract int getCost(int var1);

    public boolean isEncrypted() {
        return false;
    }

    public int getLevelBonus(PlayerEntity player) {
        return 0;
    }

    @Nullable
    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getTranslationKey() {
        return "tombstone.perk." + this.name;
    }

    public ITextComponent getTranslation() {
        if (this.translation == null) {
            this.translation = new TranslationTextComponent(this.getTranslationKey());
        }
        return this.translation;
    }

    public ITextComponent getSpecialInfo(int levelWithBonus) {
        return StringTextComponent.field_240750_d_;
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public boolean equals(Object object) {
        ResourceLocation registryName = this.getRegistryName();
        return registryName != null && object instanceof Perk && registryName.equals((Object)((Perk)object).getRegistryName());
    }

    @Override
    public int compareTo(Perk perk) {
        ResourceLocation registryName = this.getRegistryName();
        ResourceLocation otherRegistryName = perk.getRegistryName();
        if (registryName != null && otherRegistryName != null) {
            return registryName.compareTo(otherRegistryName);
        }
        return registryName == otherRegistryName ? 0 : (registryName == null ? -1 : 1);
    }
}

