/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class BlockGrave
extends BlockGraveBase<TileEntityPlayerGrave> {
    public BlockGrave(GraveModel graveModel) {
        super(BlockGrave.getBuilder(), graveModel);
    }

    @Override
    protected TileEntityPlayerGrave createTileGrave(BlockState state, IBlockReader world) {
        return new TileEntityPlayerGrave();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        if (!world.func_201670_d()) {
            return this.activatePlayerGrave(world, pos, state, (ServerPlayerEntity)player) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityPlayerGrave oldTile;
        if (!worldIn.func_201670_d() && !Helper.ALLOWED_REMOVAL && !ModBlocks.graves.containsValue(newState.func_177230_c()) && ModBlocks.graves.containsValue(state.func_177230_c()) && (oldTile = (TileEntityPlayerGrave)((Object)this.getTileEntity(worldIn, pos))) != null) {
            CallbackHandler.addCallback(0, () -> {
                CompoundNBT oldNbt = oldTile.func_189515_b(new CompoundNBT());
                Helper.placeNoEvent(worldIn, pos, state);
                TileEntity newTile = worldIn.func_175625_s(pos);
                if (newTile != null) {
                    newTile.func_230337_a_(state, oldNbt);
                    newTile.func_70296_d();
                    worldIn.func_184138_a(pos, newState, state, 2);
                }
            });
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean isToolEffective(BlockState state, ToolType type) {
        return false;
    }

    private boolean activatePlayerGrave(World world, BlockPos pos, BlockState state, ServerPlayerEntity player) {
        boolean valid;
        if (world.func_201670_d()) {
            return true;
        }
        TileEntityPlayerGrave tile = (TileEntityPlayerGrave)((Object)this.getTileEntity(world, pos));
        if (tile == null || tile.countTicks < 30 || !player.func_70089_S()) {
            return false;
        }
        boolean hasKey = ModItems.grave_key.removeKeyForGraveInInventory((PlayerEntity)player, new Location(pos, world));
        boolean isOwner = tile.isOwner((PlayerEntity)player);
        if (!hasKey && isOwner) {
            ModTriggers.EASY_OPENING.trigger(player);
        }
        boolean bl = valid = hasKey || isOwner || !tile.getNeedAccess();
        if (valid) {
            tile.giveInventory(player);
            if (world.func_72912_H().func_176130_y() != Difficulty.PEACEFUL && (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get() > 0 && Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get()) {
                IntStream.range(0, Helper.getRandom(1, 3)).forEach(i -> Helper.spawnRandomMob((ServerWorld)world, pos));
            }
            if (!isOwner) {
                ModTriggers.TOMB_RAIDING.trigger(player);
            }
        } else if (tile.canPlunder((PlayerEntity)player)) {
            if (!tile.isAbandoned((PlayerEntity)player)) {
                LangKey.MESSAGE_TOMB_RAIDER_NOT_ABANDONED.sendMessage((PlayerEntity)player, new Object[0]);
            } else {
                int cd = CooldownHandler.INSTANCE.getCooldown((PlayerEntity)player, CooldownType.TOMB_RAIDING);
                if (cd > 0) {
                    LangKey.MESSAGE_TOMB_RAIDER_IN_COOLDOWN.sendMessage((PlayerEntity)player, new Object[0]);
                    LangKey.MESSAGE_IN_COOLDOWN.sendMessage((PlayerEntity)player, TimeHelper.getTimeString(cd));
                } else {
                    if (tile.plunder(player)) {
                        LangKey.MESSAGE_TOMB_RAIDER_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
                        ModTriggers.TOMB_RAIDING.trigger(player);
                        return true;
                    }
                    LangKey.MESSAGE_TOMB_RAIDER_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
                }
            }
        } else if (ModItems.grave_key.countKeyInInventory((PlayerEntity)player) > 0) {
            LangKey.MESSAGE_OPEN_GRAVE_WRONG_KEY.sendMessage((PlayerEntity)player, new Object[0]);
        } else {
            LangKey.MESSAGE_OPEN_GRAVE_NEED_KEY.sendMessage((PlayerEntity)player, new Object[0]);
        }
        return valid;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        ServerPlayerEntity player;
        if (!world.func_201670_d() && entity.func_225608_bj_() && entity.func_70089_S() && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && PlayerPreference.get(entity.func_110124_au()).activateGraveBySneaking() && this.activatePlayerGrave(world, pos, state, player = (ServerPlayerEntity)entity)) {
            ModTriggers.SNEAK_GRAVE.trigger(player);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (player.func_184812_l_()) {
            world.func_217378_a(player, 2001, pos, BlockGrave.func_196246_j((BlockState)state));
            if (!world.func_201670_d()) {
                Helper.removeNoEvent(world, pos);
            }
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    private static AbstractBlock.Properties getBuilder() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(-1.0f, 1.8E7f).func_235838_a_(l -> 6).func_200947_a(SoundType.field_185851_d);
    }

    public ItemStack asDecorativeStack() {
        Item item;
        ResourceLocation registryName = this.getRegistryName();
        if (registryName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName.func_110624_b(), "decorative_" + registryName.func_110623_a()))) != null && item != Items.field_190931_a) {
            return new ItemStack((IItemProvider)item);
        }
        return ItemStack.field_190927_a;
    }
}

