/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.registry.ModTriggers;

public class TBCapabilityDefault
implements ITBCapability {
    protected long knowledge = 0L;
    private final Map<Perk, Integer> perks = new HashMap<Perk, Integer>();
    protected int alignment = 0;
    protected int alignmentLevel = 0;

    @Override
    public long getKnowledge() {
        return this.knowledge;
    }

    @Override
    public ITBCapability setKnowledge(long points) {
        this.knowledge = Math.max(0L, points);
        return this;
    }

    @Override
    public ITBCapability addKnowledgeAndSync(ServerPlayerEntity player, long points) {
        if (!player.field_70170_p.func_201670_d() && points > 0L) {
            int newPerkPoints;
            int adjust;
            int oldPerkPoints = this.getTotalPerkPoints();
            this.knowledge += points;
            boolean canDisplay = PlayerPreference.get(player.func_110124_au()).displayKnowledgeMessage();
            if (canDisplay) {
                LangKey.MESSAGE_EARN_KNOWLEDGE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), points});
            }
            if ((adjust = (newPerkPoints = this.getTotalPerkPoints()) - oldPerkPoints) > 0) {
                if (canDisplay) {
                    LangKey.MESSAGE_ACCESS_GUI.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[]{adjust, LangKey.MESSAGE_HERE.createComponentCommand("/tbgui", new Object[0])});
                }
                if (oldPerkPoints == 0) {
                    ModTriggers.FIRST_KNOWLEDGE.trigger(player);
                }
                if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                    ModTriggers.MASTERY_1.trigger(player);
                }
            }
            PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
        }
        return this;
    }

    @Override
    public ITBCapability removeKnowledgeAndSync(ServerPlayerEntity player, long points) {
        if (!player.field_70170_p.func_201670_d()) {
            int oldPerkPoints = this.getTotalPerkPoints();
            this.setKnowledge(this.knowledge - points);
            int lostPerkPoints = oldPerkPoints - this.getTotalPerkPoints();
            if (lostPerkPoints > 0) {
                Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
                while (it.hasNext() && lostPerkPoints > 0) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (Helper.isDisabledPerk(entry.getKey(), (PlayerEntity)player)) {
                        it.remove();
                    }
                    for (int i = entry.getValue().intValue(); i >= 1 && lostPerkPoints > 0; --i) {
                        int cost = entry.getKey().getCost(i);
                        lostPerkPoints -= cost;
                        if (i == 1) {
                            it.remove();
                            continue;
                        }
                        entry.setValue(i - 1);
                    }
                }
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.alignment, this.perks), player);
            } else {
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
            }
            if (PlayerPreference.get(player.func_110124_au()).displayKnowledgeMessage()) {
                LangKey.MESSAGE_LOSE_KNOWLEDGE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), points});
            }
        }
        return this;
    }

    @Override
    public long getKnowledgeForLevel(int level) {
        return level <= 0 ? 0L : (long)(level * level + 1);
    }

    @Override
    public long getKnowledgeToReachNextLevel(int level) {
        return level <= 0 ? 0L : (long)(level * 2 - 1);
    }

    @Override
    public int getUsedPerkPoints(PlayerEntity player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey(), player)) {
                it.remove();
                continue;
            }
            Perk perk = entry.getKey();
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += perk.getCost(i);
            }
        }
        return perkPoints;
    }

    @Override
    public int getTotalPerkPoints() {
        return (int)MathHelper.func_76129_c((float)(this.knowledge - 1L));
    }

    @Override
    public Map<Perk, Integer> getPerks() {
        return this.perks;
    }

    @Override
    public ITBCapability setPerks(Map<Perk, Integer> perks) {
        this.perks.clear();
        for (Map.Entry<Perk, Integer> entry : perks.entrySet()) {
            this.setPerk(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public ITBCapability setPerk(Perk perk, int level) {
        this.perks.put(perk, level);
        return this;
    }

    @Override
    public boolean removePerk(Perk perk) {
        return this.perks.remove(perk) != null;
    }

    @Override
    public int getPerkLevel(PlayerEntity player, Perk perk) {
        return perk.isDisabled(player) ? 0 : this.perks.getOrDefault(perk, 0);
    }

    @Override
    public int getPerkLevelWithBonus(PlayerEntity player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled(player)) {
            return Math.min(this.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax());
        }
        return 0;
    }

    @Override
    public boolean canResetPerks(PlayerEntity player) {
        return CooldownHandler.INSTANCE.noCooldown(player, CooldownType.RESET_PERKS) && this.perks.entrySet().stream().anyMatch(entry -> entry.getKey() != null && (Integer)entry.getValue() > 0 && !((Perk)entry.getKey()).isDisabled(player));
    }

    @Override
    public boolean resetPerks(ServerPlayerEntity player) {
        if (!player.field_70170_p.func_201670_d() && this.canResetPerks((PlayerEntity)player)) {
            this.setPerks(new HashMap<Perk, Integer>());
            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.RESET_PERKS);
            this.syncAll(player);
            return true;
        }
        return false;
    }

    @Override
    public ITBCapability copyCapability(ITBCapability otherTBCapability) {
        this.deserializeNBT((CompoundNBT)otherTBCapability.serializeNBT());
        return this;
    }

    @Override
    public ITBCapability syncAll(ServerPlayerEntity player) {
        PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.alignment, this.perks), player);
        return this;
    }

    @Override
    public ITBCapability increaseAlignment(int amount) {
        if (amount > 0 && this.alignmentLevel < 0 || amount < 0 && this.alignmentLevel > 0) {
            amount *= 2;
        }
        return this.setAlignment(this.alignment + amount);
    }

    @Override
    public ITBCapability decreaseAlignment(int amount) {
        return this.increaseAlignment(-amount);
    }

    @Override
    public int getAlignmentValue() {
        return this.alignment;
    }

    @Override
    public int getAlignmentMinValue() {
        return -500;
    }

    @Override
    public int getAlignmentMaxValue() {
        return 500;
    }

    @Override
    public int getAlignmentLevel() {
        if (this.alignment <= -500) {
            return -4;
        }
        if (this.alignment <= -300) {
            return -3;
        }
        if (this.alignment <= -150) {
            return -2;
        }
        if (this.alignment <= -50) {
            return -1;
        }
        if (this.alignment < 50) {
            return 0;
        }
        if (this.alignment < 150) {
            return 1;
        }
        if (this.alignment < 300) {
            return 2;
        }
        if (this.alignment < 500) {
            return 3;
        }
        return 4;
    }

    @Override
    public ITBCapability setAlignment(int value) {
        this.alignment = MathHelper.func_76125_a((int)value, (int)this.getAlignmentMinValue(), (int)this.getAlignmentMaxValue());
        this.alignmentLevel = this.getAlignmentLevel();
        return this;
    }

    @Override
    public ITBCapability addAlignmentAndSync(ServerPlayerEntity player, int amount) {
        if (!player.field_70170_p.func_201670_d() && amount != 0) {
            int oldAlignment = this.alignmentLevel;
            this.setAlignment(this.alignment + amount);
            if (oldAlignment != this.alignmentLevel) {
                this.onAlignmentLevelChange(oldAlignment, this.alignmentLevel);
            }
            PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALIGNMENT, this.alignment), player);
        }
        return this;
    }

    @Override
    public ITBCapability onAlignmentLevelChange(int oldAlignment, int newAlignment) {
        return this;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("knowledge", this.knowledge);
        nbt.func_74768_a("alignment", this.alignment);
        NBTStackHelper.fillPerksInTag(this.perks, nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("knowledge", 4)) {
            this.knowledge = nbt.func_74763_f("knowledge");
        }
        if (nbt.func_150297_b("alignment", 3)) {
            this.setAlignment(nbt.func_74762_e("alignment"));
        }
        NBTStackHelper.fillPerksInMap(nbt, this.perks);
    }
}

