/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

abstract class TombstoneCommand {
    private final CommandDispatcher<CommandSource> commandDispatcher;
    static final String PLAYER_PARAM = "player";
    static final String SOURCE_PARAM = "source";
    static final String TARGET_PARAM = "target";
    static final String UUID_PARAM = "uuid";
    static final String BIOME_PARAM = "biome";
    static final String STRUCTURE_PARAM = "structure";
    static final String DIM_PARAM = "dim";
    static final String POS_PARAM = "pos";
    static final String AMOUNT_PARAM = "amount";
    static final SuggestionProvider<CommandSource> SUGGESTION_STRUCTURE = (ctx, build) -> ISuggestionProvider.func_197014_a((Iterable)ForgeRegistries.STRUCTURE_FEATURES.getKeys(), (SuggestionsBuilder)build);
    static final SuggestionProvider<CommandSource> SUGGESTION_BIOME = (ctx, build) -> ISuggestionProvider.func_197014_a((Iterable)WorldGenRegistries.field_243657_i.func_148742_b(), (SuggestionsBuilder)build);
    static final SuggestionProvider<CommandSource> AMOUNT_SUGGESTION = (ctx, build) -> build.suggest(1, () -> "[0-MAX]").buildFuture();

    public TombstoneCommand(CommandDispatcher<CommandSource> commandDispatcher) {
        this.commandDispatcher = commandDispatcher;
    }

    abstract String getName();

    protected ITextComponent getUsage() {
        return new TranslationTextComponent("tombstone.command." + this.getName() + ".usage");
    }

    protected Predicate<CommandSource> getInitialRequirement() {
        return p -> p.func_197034_c(2);
    }

    int showUsage(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a(this.getUsage(), false);
        return 1;
    }

    abstract LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> var1);

    public void registerCommand() {
        this.commandDispatcher.register(this.getBuilder((LiteralArgumentBuilder<CommandSource>)((LiteralArgumentBuilder)Commands.func_197057_a((String)this.getName()).requires(this.getInitialRequirement()))));
    }

    static void checkAlive(Entity entity) {
        if (!entity.func_70089_S()) {
            throw LangKey.MESSAGE_DEAD_ENTITY.asCommandException(new Object[0]);
        }
    }

    static void checkNotSpectator(Entity entity) {
        if (entity instanceof PlayerEntity) {
            TombstoneCommand.checkNotSpectator((PlayerEntity)entity);
        }
    }

    static void checkNotSpectator(PlayerEntity player) {
        if (EntityHelper.isValidPlayer(player) && player.func_175149_v()) {
            throw LangKey.MESSAGE_PLAYER_SPECTATOR.asCommandException(new Object[0]);
        }
    }

    static void checkValidPos(@Nullable World world, BlockPos pos) {
        if (world != null && !Helper.isValidPos(world, pos)) {
            throw LangKey.MESSAGE_INVALID_LOCATION.asCommandException(new Object[0]);
        }
    }

    ServerWorld getOrThrowWorld(MinecraftServer server, RegistryKey<World> dim) {
        ServerWorld world = server.func_71218_a(dim);
        if (world == null) {
            throw LangKey.MESSAGE_NO_DIMENSION.asCommandException(new Object[0]);
        }
        return world;
    }

    Biome getOrThrowBiome(CommandContext<CommandSource> context, String name) {
        ResourceLocation rl = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_230516_a_(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)rl));
        if (biome == null) {
            throw LangKey.MESSAGE_INVALID_BIOME.asCommandException(new Object[0]);
        }
        return biome;
    }

    protected void sendMessage(CommandSource source, IFormattableTextComponent message, boolean allowLogging) {
        source.func_197030_a((ITextComponent)message.func_230530_a_(StyleType.TOOLTIP_DESC), allowLogging);
    }

    private static CommandExceptionType createCommandExceptionType(LangKey langKey) {
        return new SimpleCommandExceptionType((Message)langKey.getText(new Object[0]));
    }

    private static CommandExceptionType createDynamicCommandExceptionType(LangKey langKey) {
        return new DynamicCommandExceptionType(xva$0 -> langKey.getText(xva$0));
    }

    static ServerPlayerEntity getPlayerOrCommandSender(CommandContext<CommandSource> ctx, String label) throws CommandSyntaxException {
        try {
            EntityArgument.func_197089_d(ctx, (String)label);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return ((CommandSource)ctx.getSource()).func_197035_h();
    }

    static int getInteger(CommandContext<CommandSource> ctx, String label, int fallback) {
        try {
            return IntegerArgumentType.getInteger(ctx, (String)label);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return fallback;
        }
    }
}

