/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.registry.Registry;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModTriggers;

public class CompatibilityMinecolonies {
    public static final CompatibilityMinecolonies instance = new CompatibilityMinecolonies();
    private static final List<String> RAIDERS = ImmutableList.of((Object)"barbarian", (Object)"archerbarbarian", (Object)"pirate", (Object)"archerpirate", (Object)"amazon", (Object)"shieldmaiden", (Object)"norsemenarcher", (Object)"archermummy", (Object)"pharao", (Object)"mummy", (Object)"chiefbarbarian", (Object)"chiefpirate", (Object[])new String[]{"amazonchief", "norsemenchief"});

    private CompatibilityMinecolonies() {
    }

    public boolean isCitizen(@Nullable Entity entity) {
        return CreatureType.getType(entity) == CreatureType.CITIZEN;
    }

    public Optional<GlobalPos> getHomePos(LivingEntity entity) {
        IColony colony;
        if (SupportMods.MINECOLONIES.isLoaded() && (colony = ((AbstractEntityCitizen)entity).getCitizenColonyHandler().getColony()) != null) {
            return Optional.of(GlobalPos.func_239648_a_((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)colony.getDimension()), (BlockPos)colony.getCenter()));
        }
        return Optional.empty();
    }

    public boolean applyKillResult(ServerPlayerEntity player, EntityType<?> entityType) {
        switch (CreatureType.getType(entityType)) {
            case CITIZEN: {
                EntityHelper.addAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillVillager.get());
                ModTriggers.KILL_ENOUGH_VILLAGER.trigger(player);
                return true;
            }
            case RAIDER: {
                EntityHelper.addAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillRaider.get(), (Integer)ConfigTombstone.alignment.chanceKillRaider.get());
                ModTriggers.KILL_ENOUGH_RAIDER.trigger(player);
                return true;
            }
        }
        return false;
    }

    public static enum CreatureType {
        CITIZEN,
        RAIDER,
        UNKNOWN;


        public static CreatureType getType(@Nullable Entity entity) {
            return Optional.ofNullable(entity).map(Entity::func_200600_R).map(CreatureType::getType).orElse(UNKNOWN);
        }

        public static CreatureType getType(EntityType<?> type) {
            if (SupportMods.MINECOLONIES.isLoaded()) {
                return Optional.ofNullable(type.getRegistryName()).map(rl -> {
                    if ("citizen".equals(rl.func_110623_a())) {
                        return CITIZEN;
                    }
                    if (RAIDERS.contains(rl.func_110623_a())) {
                        return RAIDER;
                    }
                    return UNKNOWN;
                }).orElse(UNKNOWN);
            }
            return UNKNOWN;
        }
    }
}

