/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    private static final ResourceLocation JEI_INTEGRATION_RL = new ResourceLocation("tombstone", "jei_integration");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return JEI_INTEGRATION_RL;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((IItemProvider)ModItems.grave_key)));
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ImmutableList.Builder builder = ImmutableList.builder();
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        builder.add(factory.createAnvilRecipe(new ItemStack((IItemProvider)ModItems.grave_plate), Collections.singletonList(new ItemStack((IItemProvider)Items.field_151042_j)), Collections.singletonList(EngravableHelper.setEngravedName(new ItemStack((IItemProvider)ModItems.grave_plate), Helper.THANK_NAMES.get(Helper.random.nextInt(Helper.THANK_NAMES.size()))))));
        ItemStack tablet = NBTStackHelper.setBoolean(new ItemStack((IItemProvider)ModItems.tablet_of_assistance), "enchant", true);
        builder.add(factory.createAnvilRecipe(tablet, Collections.singletonList(new ItemStack((IItemProvider)ModItems.grave_dust)), Collections.singletonList(EngravableHelper.setEngravedName(tablet.func_77946_l(), Helper.THANK_NAMES.get(Helper.random.nextInt(Helper.THANK_NAMES.size()))))));
        registry.addRecipes((Collection)builder.build(), VanillaRecipeCategoryUid.ANVIL);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Block block : ModBlocks.decorative_graves.values()) {
            registration.registerSubtypeInterpreter(block.func_199767_j(), (stack, ctx) -> String.valueOf(ItemBlockGrave.getModelTexture(stack)));
        }
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_home, (stack, ctx) -> ModItems.tablet_of_home.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_recall, (stack, ctx) -> ModItems.tablet_of_recall.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter((Item)ModItems.grave_key, (stack, ctx) -> ModItems.grave_key.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
    }
}

