/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModBlocks;

public class IntegrationTOP
implements Function<ITheOneProbe, Void> {
    private static final ITextComponent TEXT_MOD_NAME = new StringTextComponent(StringUtils.capitalize((String)"Corail Tombstone")).func_230530_a_(StyleType.MOD_NAME);
    private static final Map<Block, List<IElement>> ELEMENTS = new HashMap<Block, List<IElement>>();
    private static boolean failed = false;

    private void setElements(BlockGrave grave, IProbeInfo probeInfo) {
        List oldElements = probeInfo.getElements();
        List<IElement> cache = ELEMENTS.get((Object)grave);
        if (cache == null) {
            ItemStack stack = grave.asDecorativeStack();
            if (!stack.func_190926_b()) {
                ArrayList toKeep = oldElements.size() == 1 ? new ArrayList() : IntStream.range(1, oldElements.size()).mapToObj(oldElements::get).collect(Collectors.toList());
                oldElements.clear();
                ILayoutStyle layout = ILayoutStyle.createAligned((ElementAlignment)ElementAlignment.ALIGN_TOPLEFT).spacing(2);
                probeInfo.horizontal(layout).item(stack).vertical(layout).itemLabel(stack).text(TEXT_MOD_NAME);
                probeInfo.getElements().addAll(toKeep);
                ELEMENTS.put((Block)grave, probeInfo.getElements());
            }
        } else {
            oldElements.clear();
            oldElements.addAll(cache);
        }
    }

    @Override
    public Void apply(ITheOneProbe probe) {
        ModTombstone.LOGGER.info("Integration TOP");
        probe.registerProvider(new IProbeInfoProvider(){

            public String getID() {
                return "tombstone:top";
            }

            public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
                if (!failed && ModBlocks.graves.containsValue(blockState.func_177230_c())) {
                    try {
                        IntegrationTOP.this.setElements((BlockGrave)blockState.func_177230_c(), iProbeInfo);
                    }
                    catch (Exception ignored) {
                        ModTombstone.LOGGER.warn("Compatibility for TheOneProbe has been disabled. Please update this mod to a recent version.");
                        failed = true;
                    }
                }
            }
        });
        return null;
    }
}

