/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.WeaponEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModTriggers;

public class EnchantmentMagicSiphon
extends WeaponEnchantment {
    public EnchantmentMagicSiphon() {
        super("magic_siphon", Enchantment.Rarity.RARE, EnchantmentType.WEAPON, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentMagicSiphon.get();
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ((Boolean)SharedConfigTombstone.enchantments.allowPlagueBringerCombiningMagicSiphon.get() != false || ench != ModEnchantments.plague_bringer);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.magicSiphonEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public int func_77325_b() {
        return (Integer)SharedConfigTombstone.enchantments.maxLevelMagicSiphon.get();
    }

    @Override
    public void onProc(LivingEntity attacker, LivingEntity target, int level) {
        List effects = target.func_70651_bq().stream().filter(EffectHelper::isAllowedEffect).collect(Collectors.toList());
        if (!effects.isEmpty()) {
            EffectInstance effectInstance = (EffectInstance)effects.get(Helper.random.nextInt(effects.size()));
            int stolenDuration = Math.min(TimeHelper.tickFromMinute((Integer)ConfigTombstone.enchantments.maxDurationMagicSiphon.get()), effectInstance.field_76460_b / (ConfigTombstone.enchantments.magicSiphonOnPlayerRule.get() == ConfigTombstone.Enchantments.MagicSiphonOnPlayerRule.NERFED && EntityHelper.isValidPlayer((Entity)target) ? 10 : 1));
            if (stolenDuration < 1) {
                return;
            }
            EffectInstance effectCopy = new EffectInstance(effectInstance);
            effectCopy.field_76460_b = stolenDuration;
            attacker.func_195064_c(effectCopy);
            EffectHelper.clearEffect(target, effectInstance.func_188419_a());
            if (stolenDuration < effectInstance.field_76460_b) {
                effectInstance.field_76460_b -= stolenDuration;
                target.func_195064_c(effectInstance);
            }
            if (target.func_110143_aJ() > target.func_110138_aP()) {
                target.func_70606_j(target.func_110138_aP());
            }
            if (EntityHelper.isValidServerPlayer((Entity)attacker)) {
                ModTriggers.STEAL_EFFECT.trigger((ServerPlayerEntity)attacker);
            }
        }
    }

    @Override
    protected boolean canAffectTarget(LivingEntity target) {
        return ConfigTombstone.enchantments.magicSiphonOnPlayerRule.get() != ConfigTombstone.Enchantments.MagicSiphonOnPlayerRule.DISALLOW || !EntityHelper.isValidPlayer((Entity)target);
    }
}

