/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import ovh.corail.tombstone.gui.CustomOptionButton;
import ovh.corail.tombstone.helper.StyleType;

@OnlyIn(value=Dist.CLIENT)
public class IntegerConfigOption
extends AbstractOption {
    private final IntSupplier supplier;
    private final IntConsumer consumer;
    private int max;
    private final BooleanConsumer dirty;
    private final List<ITextComponent> info = new ArrayList<ITextComponent>();
    private final Function<Integer, String> optionName;

    public IntegerConfigOption(String title, IntSupplier supplier, IntConsumer consumer, int max, BooleanConsumer dirty, Function<Integer, String> optionName) {
        super("tombstone.config." + title);
        this.info.add((ITextComponent)new TranslationTextComponent("tombstone.config." + title + ".tooltip").func_230530_a_(StyleType.TOOLTIP_DESC));
        this.supplier = supplier;
        this.consumer = consumer;
        this.max = max;
        this.dirty = dirty;
        this.optionName = optionName;
    }

    private void set(int value) {
        this.consumer.accept(value);
    }

    public int get() {
        return this.supplier.getAsInt();
    }

    public Widget func_216586_a(GameSettings options, int x, int y, int width) {
        return new CustomOptionButton(() -> this.info, x, y, width, 14, this, this.getOptionTranslation(), pressable -> {
            this.set(this.supplier.getAsInt() >= this.max ? 0 : this.supplier.getAsInt() + 1);
            pressable.func_238482_a_(this.getOptionTranslation());
            this.dirty.accept(true);
        });
    }

    private ITextComponent getOptionTranslation() {
        return this.func_243220_a().func_230531_f_().func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(StringUtils.capitalize((String)this.getOptionName().toLowerCase(Locale.US))));
    }

    protected String getOptionName() {
        return this.optionName.apply(this.get());
    }
}

