/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    private Predicate<Location> no_grave_locations = l -> false;
    private static final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    private static final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    private static final String LAST_DEATH_LOCATION_NBT_TAG = "tb_last_death_location";
    private static final String GRAVE_LOCATIONS_NBT_LIST = "tb_grave_locations";
    private static final String SOULBOUND_STACKS_NBT_LIST = "tb_soulbound_stacks";
    private static final String KEY_STACKS_NBT_LIST = "tb_key_stacks";

    private DeathHandler() {
    }

    public Location getLastGrave(MinecraftServer server, ServerPlayerEntity player) {
        List<Location> graveLocations = this.getGraveList(player);
        for (Location lastGrave : graveLocations) {
            ServerWorld currentWorld;
            if (lastGrave.isOrigin() || (currentWorld = server.func_71218_a(lastGrave.dim)) == null) continue;
            if (currentWorld.func_175625_s(lastGrave.getPos()) instanceof TileEntityPlayerGrave) {
                return lastGrave;
            }
            INSTANCE.removeGrave(player, lastGrave);
        }
        return Location.ORIGIN;
    }

    public void removeGrave(ServerPlayerEntity player, Location pos) {
        boolean removeAbsentWorld;
        ListNBT list = NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag((PlayerEntity)player), GRAVE_LOCATIONS_NBT_LIST);
        boolean bl = removeAbsentWorld = list.size() > 100;
        assert (player.func_184102_h() != null);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Location loc = NBTStackHelper.getLocation((CompoundNBT)it.next(), "location");
            if (!pos.equals(loc) && (!removeAbsentWorld || player.func_184102_h().func_71218_a(loc.dim) != null)) continue;
            it.remove();
        }
    }

    public void logLastGrave(PlayerEntity player, Location loc) {
        NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag(player), GRAVE_LOCATIONS_NBT_LIST).add((Object)NBTStackHelper.setLocation(new CompoundNBT(), "location", loc));
        if (((Boolean)ConfigTombstone.player_death.logPlayerGrave.get()).booleanValue()) {
            ModTombstone.LOGGER.info("A new grave of the player " + player.func_146103_bH().getName() + " was created at position [x:" + loc.x + ", y:" + loc.y + ", z:" + loc.z + ", dim:" + loc.getDimString() + "]");
        }
    }

    public List<Location> getGraveList(ServerPlayerEntity player) {
        LinkedList<Location> graveLocations = new LinkedList<Location>();
        ListNBT nbtList = NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag((PlayerEntity)player), GRAVE_LOCATIONS_NBT_LIST);
        for (int i = nbtList.size() - 1; i >= 0; --i) {
            graveLocations.add(NBTStackHelper.getLocation(nbtList.func_150305_b(i), "location"));
        }
        return graveLocations;
    }

    public boolean isNoGraveLocation(Location location) {
        return this.no_grave_locations.test(location);
    }

    public void setLastDeathLocation(PlayerEntity player, Location location) {
        NBTStackHelper.setLocation(EntityHelper.getPersistentTag(player), LAST_DEATH_LOCATION_NBT_TAG, location);
    }

    public Location getLastDeathLocation(PlayerEntity player) {
        return NBTStackHelper.getLocation(EntityHelper.getPersistentTag(player), LAST_DEATH_LOCATION_NBT_TAG);
    }

    public void addPlayerDead(ServerPlayerEntity player, DamageSource source) {
        int toRemove;
        ServerPlayerEntity killer;
        int timeSinceDeath = player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188098_h));
        if (timeSinceDeath < TimeHelper.tickFromMinute(1)) {
            ModTriggers.CHAIN_DEATH.trigger(player);
        } else if (timeSinceDeath >= TimeHelper.tickFromHour(1)) {
            ModTriggers.STRONG_OR_CAREFUL.trigger(player);
            if (timeSinceDeath >= TimeHelper.tickFromHour(10)) {
                ModTriggers.ALMOST_UNKILLABLE.trigger(player);
            }
        }
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        persistentTag.func_74757_a(IS_PLAYER_DEAD_NBT_BOOL, true);
        this.setLastDeathLocation((PlayerEntity)player, new Location((Entity)player));
        boolean hasPreservation = EffectHelper.isPotionActive((LivingEntity)player, ModEffects.preservation);
        if (hasPreservation || ((Boolean)ConfigTombstone.player_death.restoreEffectsOnDeath.get()).booleanValue()) {
            NBTStackHelper.setEffectlist(persistentTag, PRESERVED_EFFECTS_NBT_LIST, player.func_70651_bq().stream().filter(EffectHelper::isAllowedEffect));
        }
        int xpTotal = EntityHelper.getPlayerTotalXp((PlayerEntity)player);
        xpTotal = (int)((double)xpTotal * (hasPreservation || (Integer)SharedConfigTombstone.player_death.xpLoss.get() == 0 ? 1.0 : (double)MathHelper.func_76125_a((int)(100 + EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.memento_mori) * 20 - (Integer)SharedConfigTombstone.player_death.xpLoss.get()), (int)0, (int)100) / 100.0));
        if (!hasPreservation && xpTotal > 0 && ((Boolean)ConfigTombstone.player_death.pvpMode.get()).booleanValue() && EntityHelper.isKilledByOtherPlayer((PlayerEntity)player, source) && (killer = (ServerPlayerEntity)source.func_76346_g()) != null && (toRemove = MathHelper.func_76128_c((double)((double)(xpTotal * (Integer)ConfigTombstone.player_death.pvpStolenXp.get()) / 100.0))) > 0) {
            xpTotal -= toRemove;
            killer.func_195068_e(toRemove);
            LangKey.MESSAGE_PVP_STEAL_EXPERIENCE.sendMessage((PlayerEntity)player, toRemove, player.func_200200_C_());
        }
        persistentTag.func_74768_a("tb_experience_total", xpTotal);
        Pair<Integer, Float> pair = EntityHelper.getPlayerXpPair(xpTotal);
        persistentTag.func_74768_a("tb_experience_level", ((Integer)pair.getLeft()).intValue());
        persistentTag.func_74776_a("tb_experience_bar", ((Float)pair.getRight()).floatValue());
        persistentTag.func_74757_a("tb_has_preservation", hasPreservation);
    }

    public void restorePlayerDead(ServerPlayerEntity player) {
        boolean hasPreservation;
        if (!this.isPlayerDead((PlayerEntity)player)) {
            return;
        }
        if (!Helper.isDisabledPerk(ModPerks.ghostly_shape, (PlayerEntity)player)) {
            EffectHelper.addEffect((LivingEntity)player, ModEffects.ghostly_shape, (Integer)SharedConfigTombstone.general.ghostlyShapeDuration.get() * 20, EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.ghostly_shape), new boolean[0]);
        }
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        persistentTag.func_82580_o(IS_PLAYER_DEAD_NBT_BOOL);
        List<EffectInstance> effectInstances = NBTStackHelper.getEffectList(persistentTag, PRESERVED_EFFECTS_NBT_LIST, EffectHelper::isAllowedEffect);
        if (!effectInstances.isEmpty()) {
            effectInstances.forEach(effectInstance -> EffectHelper.addEffect((LivingEntity)player, effectInstance));
            persistentTag.func_82580_o(PRESERVED_EFFECTS_NBT_LIST);
        }
        if ((hasPreservation = persistentTag.func_74767_n("tb_has_preservation")) || ((Boolean)SharedConfigTombstone.player_death.handlePlayerXp.get()).booleanValue()) {
            player.field_71067_cb = persistentTag.func_74762_e("tb_experience_total");
            player.field_71068_ca = persistentTag.func_74762_e("tb_experience_level");
            player.field_71106_cc = persistentTag.func_74760_g("tb_experience_bar");
            persistentTag.func_82580_o("tb_has_preservation");
            player.field_71135_a.func_147359_a((IPacket)new SSetExperiencePacket(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        }
    }

    public boolean isPlayerDead(PlayerEntity player) {
        return EntityHelper.getPersistentTag(player).func_74767_n(IS_PLAYER_DEAD_NBT_BOOL);
    }

    public void updateNoGraveLocations() {
        ArrayList<Predicate<Location>> list = new ArrayList<Predicate<Location>>();
        for (String s : (List)ConfigTombstone.player_death.noGraveLocation.get()) {
            int range;
            int z;
            int y;
            int x;
            if (s.isEmpty()) continue;
            String[] res = s.split(",");
            if (res.length == 1) {
                list.add(l -> l.isSameDimension(res[0].trim()));
                continue;
            }
            if (res.length != 5) continue;
            try {
                x = Integer.valueOf(res[0].trim());
                y = Integer.valueOf(res[1].trim());
                z = Integer.valueOf(res[2].trim());
                range = Integer.valueOf(res[4].trim());
            }
            catch (NumberFormatException e) {
                ModTombstone.LOGGER.warn("invalid number in noGraveLocations with provided string: " + s);
                continue;
            }
            list.add(l -> l.isSameDimension(res[3].trim()) && l.isInRange(x, y, z, range));
        }
        this.no_grave_locations = list.stream().reduce(Predicate::or).orElse(l -> false);
    }

    public void restoreSoulbounds(ServerPlayerEntity player) {
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        ListNBT stackList = persistentTag.func_150295_c(SOULBOUND_STACKS_NBT_LIST, 10);
        for (int i = 0; i < stackList.size(); ++i) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)stackList.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
        }
        persistentTag.func_82580_o(SOULBOUND_STACKS_NBT_LIST);
        ListNBT keyList = persistentTag.func_150295_c(KEY_STACKS_NBT_LIST, 10);
        for (int i = 0; i < keyList.size(); ++i) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)keyList.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
        }
        persistentTag.func_82580_o(KEY_STACKS_NBT_LIST);
    }

    public void storeSoulboundsOnBody(ServerPlayerEntity player, List<ItemStack> keys, List<ItemStack> soulbounds) {
        ListNBT keyStack = NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag((PlayerEntity)player), KEY_STACKS_NBT_LIST);
        keys.forEach(key -> keyStack.add((Object)key.serializeNBT()));
        keys.clear();
        ListNBT stackList = NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag((PlayerEntity)player), SOULBOUND_STACKS_NBT_LIST);
        soulbounds.forEach(soulbound -> stackList.add((Object)soulbound.serializeNBT()));
        soulbounds.clear();
    }
}

