/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;

public class EffectHelper {
    private static final Method methodOnFinishedPotionEffect = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_70688_c", (Class[])new Class[]{EffectInstance.class});
    public static Function<Random, Integer> RANDOM_EFFECT_LEVEL = random -> {
        int roll = random.nextInt(100) + 1;
        return roll < 10 ? 4 : (roll < 25 ? 3 : (roll < 45 ? 2 : (roll < 70 ? 1 : 0)));
    };

    public static int getDuration(@Nullable LivingEntity entity, @Nullable Effect effect) {
        EffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.func_70660_b(effect)) != null ? effectInstance.field_76460_b : 0;
    }

    public static boolean isPotionActive(@Nullable LivingEntity entity, @Nullable Effect effect) {
        return EffectHelper.getDuration(entity, effect) > 0;
    }

    public static boolean isPotionActive(@Nullable LivingEntity entity, @Nullable Effect effect, int amplifier) {
        EffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.func_70660_b(effect)) != null && effectInstance.field_76461_c >= amplifier && effectInstance.field_76460_b > 0;
    }

    public static boolean isUnstableIntangiblenessActive(@Nullable LivingEntity player) {
        return TimeHelper.inIntervalAfter(EffectHelper.getDuration(player, ModEffects.unstable_intangibleness), 100, 79);
    }

    public static void capDuration(LivingEntity entity, Effect effect, int maxDuration) {
        EffectInstance effectInstance = (EffectInstance)entity.func_193076_bZ().get(effect);
        if (EffectHelper.capEffect(effectInstance, maxDuration)) {
            EffectHelper.clearEffect(entity, effect);
            EffectHelper.addEffect(entity, effectInstance);
        }
    }

    private static boolean capEffect(@Nullable EffectInstance effectInstance, int maxDuration) {
        if (effectInstance == null) {
            return false;
        }
        if (effectInstance.field_76460_b < maxDuration) {
            return EffectHelper.capEffect(effectInstance.field_230115_j_, maxDuration);
        }
        effectInstance.field_76460_b = maxDuration;
        effectInstance.field_230115_j_ = null;
        return true;
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable Effect effect, int duration) {
        EffectHelper.addEffect(entity, effect, duration, 0, new boolean[0]);
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable Effect effect, int duration, int amplifier, boolean ... params) {
        if (entity != null && effect != null) {
            entity.func_195064_c(new EffectInstance(effect, duration, amplifier, params.length == 0 || params[0], params.length <= 1 || params[1]));
        }
    }

    public static void addEffect(@Nullable LivingEntity entity, @Nullable EffectInstance effectInstance) {
        if (entity != null && effectInstance != null && effectInstance.func_188419_a() != null) {
            entity.func_195064_c(effectInstance);
        }
    }

    public static boolean isPotionHidden(@Nullable LivingEntity entity, @Nullable Effect effect) {
        EffectInstance effectInstance;
        return entity != null && effect != null && (effectInstance = entity.func_70660_b(effect)) != null && effectInstance.func_82720_e() && !effectInstance.func_188418_e();
    }

    public static EffectInstance copyEffectWithHidden(EffectInstance effectInstance) {
        EffectInstance effectCopy = new EffectInstance(effectInstance);
        if (effectInstance.field_230115_j_ != null) {
            effectCopy.field_230115_j_ = EffectHelper.copyEffectWithHidden(effectInstance.field_230115_j_);
        }
        return effectCopy;
    }

    public static EffectInstance modifyEffectDuration(EffectInstance effectInstance, Function<EffectInstance, Integer> function) {
        effectInstance.field_76460_b = function.apply(effectInstance);
        if (effectInstance.field_230115_j_ != null) {
            EffectHelper.modifyEffectDuration(effectInstance.field_230115_j_, function);
        }
        return effectInstance;
    }

    public static boolean clearEffect(@Nullable LivingEntity entity, Effect effect) {
        EffectInstance effectInstance;
        if (entity != null && !entity.field_70170_p.func_201670_d() && (effectInstance = entity.func_184596_c(effect)) != null) {
            try {
                methodOnFinishedPotionEffect.invoke((Object)entity, effectInstance);
                return true;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void clearEffect(LivingEntity entity, Predicate<Effect> predic) {
        if (!entity.field_70170_p.func_201670_d()) {
            Iterator it = entity.func_193076_bZ().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!predic.test((Effect)entry.getKey())) continue;
                try {
                    methodOnFinishedPotionEffect.invoke((Object)entity, entry.getValue());
                    it.remove();
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void clearBadEffects(@Nullable LivingEntity entity) {
        if (entity != null) {
            EffectHelper.clearEffect(entity, (Effect effect) -> effect.func_220303_e() == EffectType.HARMFUL || (Boolean)ConfigTombstone.decorative_grave.purificationAffectNeutralEffects.get() != false && effect.func_220303_e() == EffectType.NEUTRAL);
            if (entity.func_70027_ad()) {
                entity.func_70066_B();
            }
            if (entity.func_225510_bt_()) {
                entity.func_184195_f(false);
            }
        }
    }

    @Nullable
    public static EffectInstance getRandomEffect(int duration, boolean isBad) {
        return EffectHelper.getRandomEffect(duration, isBad, RANDOM_EFFECT_LEVEL);
    }

    @Nullable
    public static EffectInstance getRandomEffect(int duration, boolean isBad, Function<Random, Integer> functionEffectLevel) {
        Effect effect;
        List effects = ForgeRegistries.POTIONS.getValues().stream().filter(isBad ? EffectHelper::isBadEffect : EffectHelper::isAllowedEffect).collect(Collectors.toList());
        if (effects.size() > 0 && (effect = (Effect)effects.get(Helper.random.nextInt(effects.size()))) != null) {
            return new EffectInstance(effect, duration, functionEffectLevel.apply(Helper.random).intValue());
        }
        return null;
    }

    public static void addRandomEffect(PlayerEntity player, int duration, boolean withMessage) {
        EffectHelper.addRandomEffect(player, duration, withMessage, false);
    }

    public static void addRandomEffect(PlayerEntity player, int duration, boolean withMessage, boolean isBad) {
        EffectInstance effect = EffectHelper.getRandomEffect(duration, isBad);
        if (effect != null) {
            if (withMessage && !effect.func_188419_a().func_76393_a().isEmpty()) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage(player, StyleType.MESSAGE_SPELL, new Object[]{new TranslationTextComponent(effect.func_188419_a().func_76393_a()).func_230530_a_(StyleType.MESSAGE_SPECIAL)});
            }
            EffectHelper.addEffect((LivingEntity)player, effect);
        }
    }

    public static boolean isBadEffect(@Nullable Effect effect) {
        return effect != null && effect.func_220303_e() == EffectType.HARMFUL && !Helper.containRL((List)ConfigTombstone.general.unhandledHarmfulEffects.get(), effect.getRegistryName());
    }

    public static boolean isAllowedEffect(@Nullable EffectInstance effectInstance) {
        return effectInstance != null && EffectHelper.isAllowedEffect(effectInstance.func_188419_a());
    }

    public static boolean isAllowedEffect(@Nullable Effect effect) {
        return effect != null && effect.field_220305_b == EffectType.BENEFICIAL && !Helper.containRL((List)ConfigTombstone.general.unhandledBeneficialEffects.get(), effect.getRegistryName());
    }

    public static boolean hasAttribute(Effect effect, Attribute attribute) {
        return Optional.ofNullable(effect.func_111186_k().get(attribute)).map(m -> m.func_111164_d() < 0.0).orElse(false);
    }
}

