/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.registry.ModBlocks;

public class SpawnHelper {
    private final ServerWorld world;
    private final RegistryKey<World> dimId;
    private final int minHeight;
    private final int actualHeight;
    private BlockPos initPos;
    private List<BlockPos> positions;
    private final CacheLoader<BlockPos, PlaceType> loader = new CacheLoader<BlockPos, PlaceType>(){

        public PlaceType load(BlockPos pos) {
            return SpawnHelper.getPathNodeTypeRaw(SpawnHelper.this.world, pos);
        }
    };
    private final LoadingCache<BlockPos, PlaceType> spawnPlaces = CacheBuilder.newBuilder().maximumSize(2052L).build(this.loader);
    private BlockPos spawnPos = null;
    private SpawnResult spawnType = SpawnResult.NONE;
    private ConfigTombstone.Client.GraveSpawnRule graveSpawnRule = ConfigTombstone.Client.GraveSpawnRule.getDefault();
    private boolean graveInWater = true;
    private int move = 0;
    private static final Material[] UNSAFE_MATERIAL = new Material[]{Material.field_151587_i, Material.field_151581_o, Material.field_151567_E, Material.field_151570_A, Material.field_175972_I, Material.field_151590_u, Material.field_151569_G};
    private static final Material[] GROUND_MATERIAL = new Material[]{Material.field_151584_j, Material.field_151593_r, Material.field_151596_z, Material.field_151578_c, Material.field_151588_w};

    public SpawnHelper(ServerWorld world, BlockPos initPos) {
        this.world = world;
        this.dimId = world.func_234923_W_();
        this.minHeight = 0;
        this.actualHeight = world.func_230315_m_().func_241513_m_();
        this.initPos = Helper.getCloserValidPos((World)world, initPos);
    }

    public SpawnHelper withPlayerPreference(PlayerPreference playerPreference) {
        this.graveSpawnRule = playerPreference.getGraveSpawnRule();
        this.graveInWater = playerPreference.allowGraveInWater();
        return this;
    }

    public Location findSafePlace(int range, boolean withHeight) {
        this.initPositions(this.initPos.func_177982_a(-range, withHeight ? -range : 0, -range), this.initPos.func_177982_a(range, withHeight ? range : 0, range));
        for (BlockPos currentPos : this.positions) {
            if (!this.isIdealSpawnPlace(currentPos)) continue;
            return new Location(currentPos, (World)this.world);
        }
        return Location.ORIGIN;
    }

    public Location findStructurePlace(ResourceLocation structureRL) {
        return this.findStructurePlace(structureRL.func_110624_b(), structureRL.func_110623_a());
    }

    public Location findStructurePlace(String structureRL) {
        Pair<String, String> rl = Helper.parseRLString(structureRL);
        return this.findStructurePlace((String)rl.getLeft(), (String)rl.getRight());
    }

    private Location findStructurePlace(String domain, String path) {
        this.initPos = new BlockPos(this.initPos.func_177958_n(), SupportStructures.getY(domain, path), this.initPos.func_177952_p());
        return this.findSpawnPlace(SupportStructures.BURIED_TREASURE.is(domain, path) ? PlacementType.SPAWN_BURIED_TREASURE : PlacementType.SPAWN_STRUCTURE);
    }

    public Location findSpawnPlace() {
        return this.findSpawnPlace(PlacementType.SPAWN_PLACE);
    }

    public Location findGravePlace() {
        return this.findSpawnPlace(PlacementType.SPAWN_GRAVE);
    }

    public Pair<Location, SpawnResult> findGravePlaceWithResult() {
        return Pair.of((Object)this.findSpawnPlace(PlacementType.SPAWN_GRAVE), (Object)((Object)this.spawnType));
    }

    private BlockPos getInitPosInFluid(PlacementType placementType) {
        BlockPos adjustedPos = this.initPos;
        BlockState state = this.world.func_180495_p(adjustedPos);
        FluidState fluidState = state.func_204520_s();
        if (fluidState.func_206888_e() && !World.func_189509_E((BlockPos)(adjustedPos = adjustedPos.func_177984_a()))) {
            state = this.world.func_180495_p(adjustedPos);
            fluidState = state.func_204520_s();
        }
        if (fluidState.func_206888_e() || fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && (!placementType.isGrave() || this.graveInWater)) {
            return this.initPos;
        }
        while (!this.world.func_180495_p(adjustedPos).func_204520_s().func_206888_e()) {
            if (!World.func_189509_E((BlockPos)(adjustedPos = adjustedPos.func_177984_a()))) continue;
            return this.initPos;
        }
        return adjustedPos;
    }

    private Location findSpawnPlace(PlacementType placementType) {
        int minY;
        int maxY;
        boolean wasInLiquid;
        Predicate<BlockPos> predicPos;
        Predicate<BlockPos> predicate = predicPos = placementType.isGrave() ? this::isIdealGravePlace : this::isIdealSpawnPlace;
        if (predicPos.test(this.initPos)) {
            return new Location(this.initPos, this.dimId);
        }
        if (placementType.isBuriedTreasure()) {
            this.initUniquePosition();
        } else {
            this.initChunkPositions();
        }
        BlockPos adjustedPos = this.getInitPosInFluid(placementType);
        boolean bl = wasInLiquid = !adjustedPos.equals((Object)this.initPos);
        if (placementType.isGrave()) {
            maxY = this.actualHeight;
            minY = this.minHeight;
        } else {
            int borne = placementType.isSpawn() ? 70 : 16;
            maxY = Math.min(adjustedPos.func_177956_o() + borne, this.actualHeight);
            minY = Math.max(adjustedPos.func_177956_o() - borne, this.minHeight);
        }
        int yUp = adjustedPos.func_177956_o();
        int yDown = yUp - 1;
        boolean canGoDown = true;
        boolean canGoUp = true;
        this.move = 0;
        while (canGoUp || canGoDown) {
            canGoUp = yUp < maxY;
            canGoDown = !wasInLiquid && yDown > minY;
            for (BlockPos pos : this.positions) {
                BlockPos currentPos;
                if (canGoUp && predicPos.test(currentPos = new BlockPos(pos.func_177958_n(), yUp, pos.func_177952_p()))) {
                    return new Location(this.spawnPos, this.dimId);
                }
                if (!canGoDown || !predicPos.test(currentPos = new BlockPos(pos.func_177958_n(), yDown, pos.func_177952_p()))) continue;
                return new Location(this.spawnPos, this.dimId);
            }
            ++yUp;
            --yDown;
            ++this.move;
        }
        return placementType.isGrave() && SpawnResult.MINIMAL.hasPattern(this.spawnType) ? new Location(this.spawnPos, (World)this.world) : Location.ORIGIN;
    }

    private boolean isIdealSpawnPlace(BlockPos pos) {
        if (this.isSafeGround(pos.func_177977_b()) && this.isSafePlace(pos) && this.isSafePlace(pos.func_177984_a())) {
            this.setTypeAndPosition(SpawnResult.IDEAL, pos);
            return true;
        }
        return false;
    }

    private boolean isIdealGravePlace(BlockPos pos) {
        if (this.isGravePlace(pos)) {
            SpawnResult type = this.isSafeGround(pos.func_177977_b()) ? (this.isSafePlace(pos.func_177984_a()) ? (this.isSafePlace(pos.func_177981_b(2)) ? SpawnResult.IDEAL : SpawnResult.FIT) : SpawnResult.NORMAL) : SpawnResult.MINIMAL;
            this.setTypeAndPosition(type, pos);
            if (this.graveSpawnRule == ConfigTombstone.Client.GraveSpawnRule.SAFEST) {
                return type == SpawnResult.IDEAL;
            }
            if (this.graveSpawnRule == ConfigTombstone.Client.GraveSpawnRule.NEAREST) {
                return SpawnResult.MINIMAL.hasPattern(type);
            }
            return this.move > 70 ? SpawnResult.NORMAL.hasPattern(this.spawnType) : type == SpawnResult.IDEAL;
        }
        return false;
    }

    private boolean isGravePlace(BlockPos pos) {
        BlockState state = this.world.func_180495_p(pos);
        return (state.func_196958_f() || state.func_185904_a() == Material.field_151596_z || state.func_185904_a() == Material.field_151581_o || this.graveInWater && state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) && !state.hasTileEntity();
    }

    private boolean isSafeGround(BlockPos pos) {
        PlaceType placeType = this.getPlaceType(pos);
        return placeType.isGround() || placeType.isWater();
    }

    private boolean isSafePlace(BlockPos pos) {
        PlaceType placeType = this.getPlaceType(pos);
        return placeType.isSafe() || placeType.isWater();
    }

    private void setTypeAndPosition(SpawnResult type, BlockPos pos) {
        if (type.ordinal() > this.spawnType.ordinal()) {
            this.spawnType = type;
            this.spawnPos = pos;
        }
    }

    private PlaceType getPlaceType(BlockPos pos) {
        return (PlaceType)((Object)this.spawnPlaces.getUnchecked((Object)pos));
    }

    private void initChunkPositions() {
        ChunkPos chunkPos = new ChunkPos(this.initPos);
        this.initPositions(new BlockPos(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d()), new BlockPos(chunkPos.func_180332_e(), 0, chunkPos.func_180330_f()));
    }

    private void initPositions(BlockPos startPos, BlockPos endPos) {
        this.spawnPos = null;
        this.spawnType = SpawnResult.NONE;
        this.positions = SpawnHelper.getAllInBox(startPos, endPos).sorted(Comparator.comparingDouble(pos -> Helper.getDistanceSq((Vector3i)pos, this.initPos.func_177958_n(), 0, this.initPos.func_177952_p()))).collect(Collectors.toList());
    }

    private void initUniquePosition() {
        this.spawnPos = null;
        this.spawnType = SpawnResult.NONE;
        this.positions = ImmutableList.of((Object)this.initPos);
    }

    public static Stream<BlockPos> getAllInBox(BlockPos startPos, BlockPos endPos) {
        int minX = Math.min(startPos.func_177958_n(), endPos.func_177958_n());
        int maxX = Math.max(startPos.func_177958_n(), endPos.func_177958_n());
        int minY = Math.min(startPos.func_177956_o(), endPos.func_177956_o());
        int maxY = Math.max(startPos.func_177956_o(), endPos.func_177956_o());
        int minZ = Math.min(startPos.func_177952_p(), endPos.func_177952_p());
        int maxZ = Math.max(startPos.func_177952_p(), endPos.func_177952_p());
        Stream.Builder<BlockPos> list = Stream.builder();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    list.accept(new BlockPos(x, y, z));
                }
            }
        }
        return list.build();
    }

    private static PlaceType getPathNodeTypeRaw(ServerWorld world, BlockPos pos) {
        if (!world.func_175723_af().func_177746_a(pos)) {
            return PlaceType.UNSAFE;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        PathNodeType type = block.getAiPathNodeType(state, (IBlockReader)world, pos, null);
        if (type != null) {
            switch (type) {
                case OPEN: 
                case BREACH: {
                    return PlaceType.SAFE;
                }
                case BLOCKED: 
                case WALKABLE: 
                case LEAVES: {
                    return PlaceType.GROUND;
                }
                case WATER: 
                case WATER_BORDER: {
                    return PlaceType.WATER;
                }
            }
            return PlaceType.UNSAFE;
        }
        Material mat = state.func_185904_a();
        if (Arrays.stream(UNSAFE_MATERIAL).anyMatch(m -> m == mat) || block == Blocks.field_222434_lW || block == Blocks.field_196814_hQ) {
            return PlaceType.UNSAFE;
        }
        FluidState fluidState = state.func_204520_s();
        if (!fluidState.func_206888_e()) {
            return fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && state.func_196952_d((IBlockReader)world, pos).func_197766_b() ? PlaceType.WATER : PlaceType.UNSAFE;
        }
        if (state.func_196958_f()) {
            return PlaceType.SAFE;
        }
        if (Arrays.stream(GROUND_MATERIAL).anyMatch(m -> m == mat)) {
            return PlaceType.GROUND;
        }
        VoxelShape collisionShape = state.func_196952_d((IBlockReader)world, pos);
        if (collisionShape.func_197766_b()) {
            return PlaceType.SAFE;
        }
        if (collisionShape == VoxelShapes.func_197868_b()) {
            return PlaceType.GROUND;
        }
        if (!mat.func_76230_c()) {
            return block == Blocks.field_196651_dG ? PlaceType.GROUND : PlaceType.UNSAFE;
        }
        if (block.func_203417_a((ITag)BlockTags.field_203292_x) || block.func_203417_a((ITag)BlockTags.field_203291_w) || block.func_203417_a((ITag)BlockTags.field_219757_z) || block.func_203417_a((ITag)BlockTags.field_219747_F) || ModBlocks.isAnyGrave(block)) {
            return PlaceType.GROUND;
        }
        return PlaceType.UNSAFE;
    }

    public static enum SpawnResult {
        NONE,
        MINIMAL,
        NORMAL,
        FIT,
        IDEAL;


        public boolean hasPattern(SpawnResult actualPattern) {
            return this.ordinal() <= actualPattern.ordinal();
        }
    }

    private static enum PlacementType {
        SPAWN_PLACE,
        SPAWN_GRAVE,
        SPAWN_STRUCTURE,
        SPAWN_BURIED_TREASURE;


        public boolean isSpawn() {
            return this == SPAWN_PLACE;
        }

        public boolean isGrave() {
            return this == SPAWN_GRAVE;
        }

        public boolean isStructure() {
            return this == SPAWN_STRUCTURE || this == SPAWN_BURIED_TREASURE;
        }

        public boolean isBuriedTreasure() {
            return this == SPAWN_BURIED_TREASURE;
        }
    }

    private static enum PlaceType {
        SAFE,
        GROUND,
        UNSAFE,
        WATER;


        public boolean isSafe() {
            return this == SAFE;
        }

        public boolean isGround() {
            return this == GROUND;
        }

        public boolean isWater() {
            return this == WATER;
        }
    }
}

