/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.compatibility.CompatibilityDruidCraft;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;

public enum TameableType {
    TAMEABLE(e -> e instanceof TameableEntity, (player, entity) -> ((TameableEntity)entity).func_193101_c(player), entity -> ((TameableEntity)entity).func_184753_b(), (entity, tag) -> {}),
    HORSE(e -> e instanceof AbstractHorseEntity, (player, entity) -> ((AbstractHorseEntity)entity).func_110263_g(player), entity -> ((AbstractHorseEntity)entity).func_184780_dh(), (entity, tag) -> {
        if (entity instanceof AbstractChestedHorseEntity) {
            ((AbstractChestedHorseEntity)entity).func_110207_m(false);
        }
    }),
    DRUIDCRAFT(CompatibilityDruidCraft.instance::isTameable, CompatibilityDruidCraft.instance::setTameBy, CompatibilityDruidCraft.instance::getOwnerId, (entity, tag) -> tag.func_82580_o("OwnerUUID"));

    final Predicate<Entity> predic;
    final BiConsumer<PlayerEntity, Entity> tame;
    final Function<Entity, UUID> ownerId;
    final BiConsumer<Entity, CompoundNBT> onCapture;
    static final Map<String, TameableType> TAMEABLE_TYPE;

    private TameableType(Predicate<Entity> predic, BiConsumer<PlayerEntity, Entity> tame, Function<Entity, UUID> ownerId, BiConsumer<Entity, CompoundNBT> onCapture) {
        this.predic = predic;
        this.tame = tame;
        this.ownerId = ownerId;
        this.onCapture = onCapture;
    }

    public static void init(MinecraftServer server) {
        if (!TAMEABLE_TYPE.isEmpty()) {
            return;
        }
        ServerWorld world = server.func_241755_D_();
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            String registryName = EntityHelper.getRegistryString(entityType);
            if (registryName.isEmpty()) continue;
            try {
                Entity entity = entityType.func_200721_a((World)world);
                if (entity == null) continue;
                Arrays.stream(TameableType.values()).filter(t -> t.predic.test(entity)).findFirst().ifPresent(tameable -> TAMEABLE_TYPE.put(registryName, (TameableType)((Object)tameable)));
            }
            catch (Exception exception) {}
        }
    }

    public static void setTamedBy(PlayerEntity player, Entity entity) {
        Optional.ofNullable(TameableType.getType(entity)).ifPresent(t -> t.tame.accept(player, entity));
    }

    @Nullable
    public UUID getOwnerId(Entity entity) {
        return this.ownerId.apply(entity);
    }

    public void onCapture(Entity entity, CompoundNBT tag) {
        this.onCapture.accept(entity, tag);
    }

    public static boolean isTameable(String entityTypeString) {
        return TameableType.getType(entityTypeString) != null;
    }

    @Nullable
    public static TameableType getType(@Nullable Entity entity) {
        return TameableType.getType(EntityHelper.getRegistryString(entity));
    }

    @Nullable
    public static TameableType getType(String entityTypeString) {
        return TAMEABLE_TYPE.get(entityTypeString);
    }

    public static String getRandomTameableEntityTypeString() {
        if (!TAMEABLE_TYPE.isEmpty()) {
            return TAMEABLE_TYPE.keySet().stream().skip(Helper.random.nextInt(TAMEABLE_TYPE.size())).findFirst().orElse("minecraft:cat");
        }
        return "minecraft:cat";
    }

    static {
        TAMEABLE_TYPE = new HashMap<String, TameableType>();
    }
}

