/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class TeleportationHandler {
    public static <T extends Entity> T teleportEntity(T entity, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord) {
        if (!entity.field_70170_p.func_201670_d() && entity.func_70089_S()) {
            ServerWorld sourceWorld = (ServerWorld)entity.field_70170_p;
            if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
                return (T)TeleportationHandler.teleportEntity(entity, sourceWorld, targetWorld, xCoord, yCoord, zCoord);
            }
            Entity lowestRidingEntity = entity.func_184208_bv();
            PassengerHelper passengerHelper = new PassengerHelper(lowestRidingEntity);
            passengerHelper.teleport(sourceWorld, targetWorld, xCoord, yCoord, zCoord);
            passengerHelper.remountRiders();
            passengerHelper.updateClients();
            return (T)Optional.ofNullable(passengerHelper.getPassenger(entity)).map(e -> ((PassengerHelper)e).entity).orElse(entity);
        }
        return entity;
    }

    private static Entity teleportEntity(Entity entity, ServerWorld sourceWorld, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord) {
        if (!entity.func_70089_S()) {
            return entity;
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (player.func_70608_bn()) {
                player.func_225652_a_(true, true);
            }
            return TeleportationHandler.teleportPlayerToDimension(player, targetWorld, xCoord, yCoord, zCoord);
        }
        if (sourceWorld != targetWorld) {
            return Optional.ofNullable(entity.func_200600_R().func_200721_a((World)targetWorld)).map(newEntity -> {
                entity.func_213319_R();
                newEntity.func_180432_n(entity);
                newEntity.func_70012_b(xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
                newEntity.func_213293_j(0.0, 0.0, 0.0);
                if (newEntity instanceof MobEntity) {
                    ((MobEntity)entity).func_70661_as().func_75499_g();
                }
                targetWorld.func_217460_e(newEntity);
                entity.remove(false);
                sourceWorld.func_82742_i();
                targetWorld.func_82742_i();
                return newEntity;
            }).orElse(entity);
        }
        entity.func_70012_b(xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
        return entity;
    }

    private static PlayerEntity teleportPlayerToDimension(ServerPlayerEntity player, ServerWorld targetWorld, double x, double y, double z) {
        player.func_175399_e((Entity)player);
        if (targetWorld == player.field_70170_p) {
            player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
        } else {
            ChunkPos chunkpos = new ChunkPos(new BlockPos(x, y, z));
            targetWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)player.func_145782_y());
            ServerWorld serverworld = player.func_71121_q();
            IWorldInfo iworldinfo = targetWorld.func_72912_H();
            player.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(targetWorld.func_230315_m_(), targetWorld.func_234923_W_(), BiomeManager.func_235200_a_((long)targetWorld.func_72905_C()), player.field_71134_c.func_73081_b(), player.field_71134_c.func_241815_c_(), targetWorld.func_234925_Z_(), targetWorld.func_241109_A_(), true));
            player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(iworldinfo.func_176130_y(), iworldinfo.func_176123_z()));
            player.field_71133_b.func_184103_al().func_187243_f(player);
            serverworld.removePlayer(player, true);
            player.revive();
            player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
            player.func_70029_a((World)targetWorld);
            targetWorld.func_217446_a(player);
            player.func_213846_b(serverworld);
            player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
            player.field_71134_c.func_73080_a(targetWorld);
            player.field_71133_b.func_184103_al().func_72354_b(player, targetWorld);
            player.field_71133_b.func_184103_al().func_72385_f(player);
            BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)player, (RegistryKey)serverworld.func_234923_W_(), (RegistryKey)targetWorld.func_234923_W_());
        }
        return player;
    }

    private static class PassengerHelper {
        private Entity entity;
        private final LinkedList<PassengerHelper> passengers = new LinkedList();
        private double offsetX;
        private double offsetY;
        private double offsetZ;

        PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                assert (entity.func_184187_bx() != null);
                this.offsetX = entity.func_226277_ct_() - entity.func_184187_bx().func_226277_ct_();
                this.offsetY = entity.func_226278_cu_() - entity.func_184187_bx().func_226278_cu_();
                this.offsetZ = entity.func_226281_cx_() - entity.func_184187_bx().func_226281_cx_();
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        private void teleport(ServerWorld sourceWorld, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord) {
            this.entity.func_184226_ay();
            this.entity = TeleportationHandler.teleportEntity(this.entity, sourceWorld, targetWorld, xCoord, yCoord, zCoord);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(sourceWorld, targetWorld, xCoord, yCoord, zCoord);
            }
        }

        private void remountRiders() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.func_226277_ct_() + this.offsetX, this.entity.func_226278_cu_() + this.offsetY, this.entity.func_226281_cx_() + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        private void updateClients() {
            if (this.entity instanceof ServerPlayerEntity) {
                this.updateClient((ServerPlayerEntity)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayerEntity playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        @Nullable
        private PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

