/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.ProtectedEntityProvider;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.EffectMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemAnkhOfPray
extends ItemGeneric
implements ISoulConsumer {
    public ItemAnkhOfPray() {
        super("ankh_of_pray", ItemAnkhOfPray.getBuilder(true).func_200917_a(1).func_200915_b(30).func_234689_a_());
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                if (!this.func_77636_d(stack)) {
                    int cd = CooldownHandler.INSTANCE.getCooldown((PlayerEntity)player, CooldownType.NEXT_PRAY) / 20;
                    if (cd > 0) {
                        long hour = cd / 3600;
                        StringBuilder timeString = new StringBuilder("[");
                        if (hour > 0L) {
                            cd = (int)((long)cd - hour * 3600L);
                            timeString.append(String.format("%02d", hour)).append(":");
                        }
                        timeString.append(String.format("%02d", cd / 60)).append(":").append(String.format("%02d", cd % 60)).append("]");
                        this.addItemUse(list, "1", new StringTextComponent(timeString.toString()).func_240703_c_(StyleType.TOOLTIP_DESC));
                    }
                } else {
                    this.addItemUse(list, "2", new Object[0]);
                }
                if (CooldownHandler.INSTANCE.getCooldown((PlayerEntity)player, CooldownType.RESET_PERKS) <= 0) {
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (EntityHelper.isValidPlayer(context.func_195999_j())) {
            BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
            if (ModBlocks.isDecorativeGrave(state.func_177230_c()) && ((SoulType)((Object)state.func_177229_b(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
                return ActionResultType.PASS;
            }
            this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (EntityHelper.isValidPlayer(playerIn) && hand == Hand.MAIN_HAND && playerIn.func_184614_ca().func_77973_b() == this && !EntityHelper.hasGlobalItemCooldown(playerIn, this) && target != null) {
            if (target instanceof ZombieVillagerEntity) {
                ZombieVillagerEntity zombieVillager2 = (ZombieVillagerEntity)target;
                EntityHelper.setGlobalItemCooldown(playerIn, this, 10);
                if (CooldownHandler.INSTANCE.noCooldown(playerIn, CooldownType.NEXT_PRAY) && !playerIn.field_70170_p.func_201670_d()) {
                    ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
                    EffectInstance effectInstance = new EffectInstance(ModEffects.exorcism, 200, 1);
                    EffectHelper.addEffect((LivingEntity)zombieVillager2, effectInstance);
                    PacketHandler.sendToAllTrackingPlayers(new EffectMessage(zombieVillager2.func_145782_y(), effectInstance), (LivingEntity)zombieVillager2);
                    zombieVillager2.field_191992_by = null;
                    zombieVillager2.field_82234_d = 200;
                    zombieVillager2.func_184212_Q().func_187227_b(ZombieVillagerEntity.field_184739_bx, (Object)true);
                    zombieVillager2.func_195063_d(Effects.field_76437_t);
                    zombieVillager2.field_70170_p.func_72960_a((Entity)zombieVillager2, (byte)16);
                    zombieVillager2.getPersistentData().func_74757_a("tb_converting", true);
                    CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                    EntityHelper.addKnowledge(player, 3L);
                    EntityHelper.addAlignment(player, (Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get());
                    Helper.damageItem(player.func_184614_ca(), 3, player, Hand.MAIN_HAND);
                    LangKey.MESSAGE_EXORCISM.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                    ModTriggers.EXORCISM.trigger(player);
                }
                return ActionResultType.SUCCESS;
            }
            int alignement = playerIn.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
            if (alignement < 0 && target instanceof VillagerEntity) {
                VillagerEntity villager = (VillagerEntity)target;
                EntityHelper.setGlobalItemCooldown(playerIn, this, 10);
                if (CooldownHandler.INSTANCE.noCooldown(playerIn, CooldownType.NEXT_PRAY) && !playerIn.field_70170_p.func_201670_d()) {
                    ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
                    Optional.ofNullable(villager.func_233656_b_(EntityType.field_200727_aF, false)).ifPresent(zombieVillager -> {
                        zombieVillager.func_213386_a((IServerWorld)player.func_71121_q(), player.func_71121_q().func_175649_E(zombieVillager.func_233580_cy_()), SpawnReason.CONVERSION, (ILivingEntityData)new ZombieEntity.GroupData(false, false), null);
                        zombieVillager.func_213792_a(villager.func_213700_eh());
                        zombieVillager.func_223727_a((INBT)villager.func_223722_es().func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
                        zombieVillager.func_213790_g(villager.func_213706_dY().func_222199_a());
                        zombieVillager.func_213789_a(villager.func_213708_dV());
                        EffectInstance effectInstance = new EffectInstance(ModEffects.exorcism, 200, 1);
                        EffectHelper.addEffect((LivingEntity)zombieVillager, effectInstance);
                        PacketHandler.sendToAllTrackingPlayers(new EffectMessage(zombieVillager.func_145782_y(), effectInstance), (LivingEntity)zombieVillager);
                        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                        EntityHelper.addKnowledge(player, 3L);
                        EntityHelper.addAlignment(player, -((Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get()).intValue());
                        Helper.damageItem(player.func_184614_ca(), 3, player, Hand.MAIN_HAND);
                        LangKey.MESSAGE_EXORCISM.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                        ModTriggers.ZOMBIFY.trigger(player);
                    });
                }
                return ActionResultType.SUCCESS;
            }
            if (Helper.isContributor(playerIn) || alignement > 0) {
                return target.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(cap -> {
                    EntityHelper.setGlobalItemCooldown(playerIn, this, 10);
                    if (CooldownHandler.INSTANCE.noCooldown(playerIn, CooldownType.NEXT_PRAY) && !playerIn.field_70170_p.func_201670_d()) {
                        ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
                        if (!cap.isActive()) {
                            cap.apply(target, true);
                            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                            EntityHelper.addKnowledge(player, 3L);
                            EntityHelper.addAlignment(player, (Integer)ConfigTombstone.alignment.pointsPrayOfProtection.get());
                            LangKey.MESSAGE_PRAY_OF_PROTECTION_SUCCESS.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[]{target.func_200200_C_()});
                            ModTriggers.PRAY_OF_PROTECTION.trigger(player);
                        } else {
                            LangKey.MESSAGE_PRAY_OF_PROTECTION_FAILED.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[]{target.func_200200_C_()});
                        }
                    }
                    return ActionResultType.SUCCESS;
                }).orElse(ActionResultType.FAIL);
            }
        }
        return ActionResultType.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (hand == Hand.MAIN_HAND && heldStack.func_77973_b() == this && !EntityHelper.hasGlobalItemCooldown(player, this) && CooldownHandler.INSTANCE.getCooldown(player, CooldownType.NEXT_PRAY) <= 0) {
            IFormattableTextComponent failedMessage = null;
            ItemStack offhand = player.func_184592_cb();
            if (ModItems.familiar_receptacle.containSoul(offhand)) {
                if (ModItems.familiar_receptacle.getDurabilityForDisplay(offhand) != 0.0) {
                    failedMessage = LangKey.MESSAGE_RECOVERING_RECEPTACLE.getText(StyleType.COLOR_OFF, new Object[0]);
                } else if (player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getTotalPerkPoints).orElse(0) < (Integer)SharedConfigTombstone.general.familiarReceptacleRequiredLevel.get()) {
                    failedMessage = LangKey.MESSAGE_CRAFTING_KNOWLEDGE_REQUIRED.getText(StyleType.COLOR_OFF, SharedConfigTombstone.general.familiarReceptacleRequiredLevel.get());
                }
                if (failedMessage != null) {
                    EntityHelper.setGlobalItemCooldown(player, this, 10);
                    if (!player.field_70170_p.func_201670_d()) {
                        LangKey.sendMessage((ITextComponent)failedMessage, player);
                    }
                    return new ActionResult(ActionResultType.FAIL, (Object)heldStack);
                }
            }
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldStack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)heldStack);
    }

    @Nullable
    private BlockPos findGraveAround(IWorld world, BlockPos startPos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos currentPos = new BlockPos(startPos.func_177958_n() + x, startPos.func_177956_o() + y, startPos.func_177952_p() + z);
                    if (!ModBlocks.isDecorativeGrave(world.func_180495_p(currentPos).func_177230_c())) continue;
                    return currentPos;
                }
            }
        }
        return null;
    }

    public ItemStack func_77654_b(ItemStack stack, @Nullable World world, LivingEntity entity) {
        ServerPlayerEntity player;
        if (EntityHelper.isValidServerPlayer((Entity)entity) && !EntityHelper.hasGlobalItemCooldown((PlayerEntity)(player = (ServerPlayerEntity)entity), this)) {
            BlockPos gravePos = this.findGraveAround((IWorld)player.field_70170_p, player.func_233580_cy_());
            if (gravePos != null) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                    ItemStack offhandStack = player.func_184592_cb();
                    if (offhandStack.func_77973_b() == ModItems.familiar_receptacle) {
                        if (ModItems.familiar_receptacle.containSoul(offhandStack)) {
                            if (ModItems.familiar_receptacle.getDurabilityForDisplay(offhandStack) > 0.0) {
                                LangKey.MESSAGE_RECOVERING_RECEPTACLE.sendMessage((PlayerEntity)player, StyleType.COLOR_OFF, new Object[0]);
                            } else if (ModItems.familiar_receptacle.revive((PlayerEntity)player, gravePos, offhandStack)) {
                                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                                cap.addKnowledgeAndSync(player, 5L);
                                Helper.damageItem(stack, 1, player, Hand.MAIN_HAND);
                                ModTriggers.REVIVE_FAMILIAR.trigger(player);
                                LangKey.MESSAGE_REVIVE_FAMILIAR.sendMessage((PlayerEntity)player, LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0]));
                                offhandStack.func_190918_g(1);
                            } else {
                                CompoundNBT tag = offhandStack.func_77978_p();
                                if (tag != null) {
                                    tag.func_82580_o("dead_pet");
                                }
                                LangKey.MESSAGE_CANT_REVIVE_FAMILIAR.sendMessage((PlayerEntity)player, StyleType.COLOR_OFF, new Object[]{LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])});
                            }
                        } else {
                            LangKey.MESSAGE_EMPTY_RECEPTACLE.sendMessage((PlayerEntity)player, StyleType.COLOR_OFF, new Object[0]);
                        }
                    } else {
                        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                        cap.addKnowledgeAndSync(player, 1L);
                        Helper.damageItem(stack, 1, player, Hand.MAIN_HAND);
                        ModTriggers.PRAY_ON_GRAVE.trigger(player);
                        if (Helper.isAprilFoolsDay()) {
                            EffectHelper.addEffect((LivingEntity)player, Effects.field_220309_E, TimeHelper.tickFromDay(1));
                        } else if (EffectHelper.clearEffect((LivingEntity)player, Effects.field_220309_E)) {
                            LangKey.MESSAGE_DISPEL_BAD_OMEN.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[0]);
                        }
                        int res = Helper.getRandom(1, 100) + cap.getTotalPerkPoints();
                        if (res >= 100 || Helper.isAprilFoolsDay() && res < 50) {
                            EntityType.func_220327_a((String)TameableType.getRandomTameableEntityTypeString()).ifPresent(entityType -> {
                                Entity pet = entityType.func_200721_a(player.field_70170_p);
                                if (pet != null) {
                                    pet.func_70107_b((double)((float)gravePos.func_177958_n() + Helper.random.nextFloat()) - 0.5, (double)gravePos.func_177956_o() + 1.0, (double)((float)gravePos.func_177952_p() + Helper.random.nextFloat()) - 0.5);
                                    if (pet instanceof MobEntity) {
                                        ((MobEntity)pet).func_213386_a((IServerWorld)player.func_71121_q(), player.field_70170_p.func_175649_E(pet.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                                    }
                                    TameableType.setTamedBy((PlayerEntity)player, pet);
                                    player.field_70170_p.func_217376_c(pet);
                                }
                            });
                        }
                        if (Helper.isDateAroundHalloween() || res < (Integer)ConfigTombstone.decorative_grave.chancePrayReward.get() + cap.getTotalPerkPoints() * 3) {
                            EffectHelper.addRandomEffect((PlayerEntity)player, (Integer)SharedConfigTombstone.decorative_grave.cooldownToPray.get() * 5000, true);
                        }
                    }
                });
            } else {
                LangKey.MESSAGE_CANT_PRAY.sendMessage((PlayerEntity)player, StyleType.COLOR_OFF, new Object[0]);
            }
            EntityHelper.setGlobalItemCooldown((PlayerEntity)player, this, 10);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (entity != null && entity.field_70170_p.func_201670_d() && timeLeft == this.func_77626_a(stack)) {
            ModTombstone.PROXY.produceParticleCasting(entity, p -> !p.func_184587_cr());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || EntityHelper.hasGlobalItemCooldown((PlayerEntity)player, stack)) {
            return false;
        }
        int cooldownToPray = CooldownHandler.INSTANCE.getCooldown((PlayerEntity)player, CooldownType.NEXT_PRAY);
        if (cooldownToPray > 0) {
            int maxTime = CooldownType.NEXT_PRAY.getMaxCooldown((PlayerEntity)player);
            int elapsedTime = maxTime - cooldownToPray;
            CooldownTracker cd = player.func_184811_cZ();
            cd.field_185148_b -= elapsedTime;
            cd.func_185145_a((Item)this, maxTime);
            cd.field_185148_b += elapsedTime;
            return false;
        }
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        return player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> {
            boolean hasReset = cap.resetPerks(player);
            if (hasReset) {
                ModTriggers.RESET_PERKS.trigger(player);
                return 1;
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_PERK_RESET_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        int cd;
        if (!player.field_70170_p.func_201670_d() && (cd = CooldownHandler.INSTANCE.getCooldown(player, CooldownType.RESET_PERKS)) > 0) {
            int min = cd / 1200;
            if (min > 0) {
                cd -= min * 1200;
            }
            return LangKey.MESSAGE_PERK_RESET_IN_COOLDOWN.getText(min, cd / 20);
        }
        return LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0]);
    }

    @Override
    public int getKnowledge() {
        return 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

